/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ISetMessage;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ISetMessageEx;
import org.eclipse.m2m.internal.qvt.oml.common.project.TransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.common.ui.controls.BrowseInterpretedTransformationDialog;
import org.eclipse.m2m.internal.qvt.oml.common.ui.controls.UniSelectTransformationControl;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.IUriGroup;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.MdaLaunchTab;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.OptionalFileGroup;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.TraceFileControl;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.TransformationControls;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.project.QvtEngine;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtValidator;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.ITransformationMaker;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.AbstractLaunchConfigurationTabCompatibility;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.TransformationSignatureLaunchControl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class QvtLauncherTab
extends MdaLaunchTab {
    private final ModifyListener QVT_FILE_MODIFY_LISTENER = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            QvtLauncherTab.this.validateQvtFile();
            QvtLauncherTab.this.myTransfSignatureControl.setTransformation(QvtLauncherTab.this.myTransformation, QvtLauncherTab.this.myUriListeners);
            QvtLauncherTab.this.myTraceNameNonChanged = true;
            QvtLauncherTab.this.initTraceFileText();
            QvtLauncherTab.this.updateLaunchConfigurationDialog();
        }
    };
    private final ISetMessage SET_MESSAGE = new ISetMessageEx(){

        public void setErrorMessage(String message) {
            QvtLauncherTab.this.setErrorMessage(message);
            QvtLauncherTab.this.getLaunchConfigurationDialog().updateMessage();
        }

        public void setMessage(String message) {
            QvtLauncherTab.this.setMessage(message);
            QvtLauncherTab.this.getLaunchConfigurationDialog().updateMessage();
        }

        public void setWarningMessage(String message) {
            if (!AbstractLaunchConfigurationTabCompatibility.setWarningMessage((Object)QvtLauncherTab.this, message)) {
                QvtLauncherTab.this.setMessage(message);
            }
            QvtLauncherTab.this.getLaunchConfigurationDialog().updateMessage();
        }
    };
    private final ITransformationMaker myTransformationMaker;
    private Text myQvtFile;
    private QvtTransformation myTransformation;
    private TraceFileControl myTraceFile;
    private boolean myTraceNameNonChanged;
    private TransformationSignatureLaunchControl myTransfSignatureControl;
    private final List<IUriGroup.IModifyListener> myUriListeners;

    public QvtLauncherTab(ITransformationMaker transformationMaker) {
        this.myTransformationMaker = transformationMaker;
        this.myUriListeners = new ArrayList<IUriGroup.IModifyListener>(1);
        this.myUriListeners.add(new IUriGroup.IModifyListener(){

            public void modified() {
                QvtLauncherTab.this.initTraceFileText();
                QvtLauncherTab.this.updateLaunchConfigurationDialog();
            }

            public void performValidation(boolean isLightweight) {
                QvtLauncherTab.this.validateTab(isLightweight ? QvtValidator.ValidationType.LIGHTWEIGHT_VALIDATION : QvtValidator.ValidationType.FULL_VALIDATION);
            }
        });
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.m2m.qvt.oml._transformation");
    }

    public void dispose() {
        super.dispose();
        try {
            if (this.myTransformation != null) {
                this.myTransformation.cleanup();
            }
        }
        catch (MdaException mdaException) {
            // empty catch block
        }
    }

    protected void createTransformationSection(Composite parent) {
        TransformationControls.createLabel((Composite)parent, (String)Messages.QvtLauncherTab_ModuleLabel, (int)2);
        this.myQvtFile = TransformationControls.createText((Composite)parent, (int)1);
        this.myQvtFile.addModifyListener(this.QVT_FILE_MODIFY_LISTENER);
        Button button = TransformationControls.createButton((Composite)parent, (String)Messages.QvtLauncherTab_BrowseButtonLabel);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URI selectedUri;
                final String fileName = QvtLauncherTab.this.myQvtFile.getText();
                UniSelectTransformationControl.SelectionListenerAdapter selectionListener = new UniSelectTransformationControl.SelectionListenerAdapter(){

                    public IStatus selectionChanged(URI selectedUri) {
                        String transfName = "";
                        try {
                            if (selectedUri == null) {
                                return TransformationControls.makeStatus((int)4, (String)Messages.QvtLauncherTab_NoTransformationModule);
                            }
                            QvtTransformation transformation = QvtLauncherTab.this.myTransformationMaker.makeTransformation(selectedUri);
                            transfName = transformation.getModuleName();
                        }
                        catch (Exception e) {
                            return TransformationControls.makeStatus((int)4, (String)e.getMessage());
                        }
                        return TransformationControls.makeStatus((int)0, (String)NLS.bind((String)Messages.QvtLauncherTab_TransformationSelected, (Object)transfName));
                    }

                    public UniSelectTransformationControl.ISelectionListener.TreeAction getTreeAction(URI uri) {
                        String item = uri.toString();
                        if (fileName.equals(item)) {
                            return UniSelectTransformationControl.ISelectionListener.TreeAction.SELECT;
                        }
                        return fileName.startsWith(item) ? UniSelectTransformationControl.ISelectionListener.TreeAction.EXPAND : UniSelectTransformationControl.ISelectionListener.TreeAction.NONE;
                    }
                };
                BrowseInterpretedTransformationDialog dialog = new BrowseInterpretedTransformationDialog(QvtLauncherTab.this.getShell(), UniSelectTransformationControl.QVTO_FILE_FILTER, (TransformationRegistry)QvtTransformationRegistry.getInstance(), fileName, (UniSelectTransformationControl.ISelectionListener)selectionListener);
                dialog.create();
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.m2m.qvt.oml._transformation");
                if (dialog.open() == 0 && (selectedUri = dialog.getSelectedUri()) != null) {
                    QvtLauncherTab.this.myQvtFile.setText(selectedUri.toString());
                }
            }
        });
        this.myTraceFile = new TraceFileControl(parent, Messages.QvtLauncherTab_TraceFile);
        this.myTraceFile.addModifyListener(new OptionalFileGroup.IModifyListener(){

            public void modified() {
                QvtLauncherTab.this.myTraceNameNonChanged = QvtLauncherTab.this.myTraceFile.getText().equals(QvtLauncherTab.this.getTraceFileName());
                QvtLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        TransformationControls.createLabel((Composite)parent, (String)Messages.QvtLauncherTab_ParametersLabel, (int)2);
        this.myTransfSignatureControl = new TransformationSignatureLaunchControl(parent, 2048);
    }

    private void initTraceFileText() {
        if (this.myTraceNameNonChanged || this.myTraceFile.getText().length() == 0) {
            String traceFileName = this.getTraceFileName();
            this.myTraceFile.setText(traceFileName);
            if (traceFileName != null) {
                IPath path = Path.fromOSString((String)traceFileName);
                this.myTraceFile.update(path.lastSegment().replaceAll(".qvtotrace", ""), "qvtotrace");
            }
        }
    }

    private String getTraceFileName() {
        URI uri = this.myTransfSignatureControl.getDefaultTraceName();
        return uri == null ? null : uri.toString();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IFile file = QvtLauncherTab.getFileContext();
        if (file == null) {
            return;
        }
        try {
            Module module;
            ImperativeOperation mainOperation;
            URI uri = URIUtils.getResourceURI((IResource)file);
            UnitProxy unit = UnitResolverFactory.Registry.INSTANCE.getUnit(uri);
            if (unit == null) {
                return;
            }
            CompiledUnit compiledUnit = QvtEngine.getInstance((IResource)file).compileUnit(unit, null);
            if (compiledUnit != null && compiledUnit.getModules().size() >= 1 && (mainOperation = QvtOperationalParserUtil.getMainOperation((Module)(module = (Module)compiledUnit.getModules().get(0)))) != null) {
                this.initializeName(configuration, compiledUnit.getName());
                URI transfUri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
                configuration.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", transfUri.toString());
            }
        }
        catch (MdaException e) {
            Logger.getLogger().log(Logger.INFO, e.getMessage(), e);
        }
    }

    private void initializeName(ILaunchConfigurationWorkingCopy config, String name) {
        if (name == null) {
            name = "";
        }
        if (name.length() > 0) {
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String module = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", "");
            if (!this.myQvtFile.getText().equals(module)) {
                this.myQvtFile.setText(module);
            }
        }
        catch (CoreException e) {
            this.myQvtFile.setText("");
        }
        try {
            this.myTransfSignatureControl.initializeFrom(configuration);
        }
        catch (CoreException e) {
            // empty catch block
        }
        try {
            String traceFile = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", "");
            if (traceFile.length() > 0) {
                if (!this.myTraceFile.getText().equals(traceFile)) {
                    this.myTraceFile.setText(traceFile);
                }
            } else {
                this.myTraceNameNonChanged = true;
                this.initTraceFileText();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            this.myTraceFile.setUseFileFlag(configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", false));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            this.myTraceFile.setIncrementalUpdate(configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.isInrementalUpdate", false));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", this.myQvtFile.getText());
        this.myTransfSignatureControl.performApply(configuration);
        configuration.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", this.myTraceFile.getText());
        configuration.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", this.myTraceFile.getUseFileFlag());
        configuration.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.isInrementalUpdate", this.myTraceFile.isIncrementalUpdate());
    }

    public boolean isValid(ILaunchConfiguration unused) {
        return this.validateTab(QvtValidator.ValidationType.LIGHTWEIGHT_VALIDATION);
    }

    private boolean validateTab(QvtValidator.ValidationType validationType) {
        String moduleName;
        if (this.myTransformation == null) {
            return false;
        }
        this.setMessage(null);
        AbstractLaunchConfigurationTabCompatibility.setWarningMessage((Object)this, null);
        this.setErrorMessage(null);
        try {
            moduleName = this.myTransformation.getModuleName();
        }
        catch (MdaException e) {
            IStatus status = StatusUtil.makeErrorStatus((String)e.getMessage(), (Exception)((Object)e));
            return TransformationControls.statusToTab((IStatus)status, (ISetMessage)this.SET_MESSAGE);
        }
        if (this.myTraceFile.getText().length() == 0) {
            this.myTraceFile.update(moduleName, "qvtotrace");
        }
        IStatus status = this.myTransfSignatureControl.validate(moduleName, this.getShell(), this.myTraceFile.getText(), this.myTraceFile.getUseFileFlag(), this.myTraceFile.isIncrementalUpdate(), validationType);
        return TransformationControls.statusToTab((IStatus)status, (ISetMessage)this.SET_MESSAGE);
    }

    private boolean validateQvtFile() {
        String fileName;
        if (this.myTransformation != null) {
            try {
                this.myTransformation.cleanup();
            }
            catch (MdaException mdaException) {
                // empty catch block
            }
            this.myTransformation = null;
        }
        if ((fileName = this.myQvtFile.getText()) == null || fileName.length() == 0) {
            this.setErrorMessage(NLS.bind((String)Messages.QvtLauncherTab_NoTransformationModule, null));
            return false;
        }
        URI uri = EmfUtil.makeUri((String)fileName);
        if (uri == null) {
            this.setErrorMessage(NLS.bind((String)Messages.QvtLauncherTab_InvalidTransformationUri, (Object)fileName));
            return false;
        }
        try {
            this.myTransformation = this.myTransformationMaker.makeTransformation(uri);
        }
        catch (MdaException e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
        return true;
    }
}

