/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.IQVTReconcilingListener;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Messages;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtCompilerFacade;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;

public class QvtReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private static final int MAX_LOGGED_COMPILATION_EXCEPTIONS = 5;
    private IProgressMonitor myMonitor;
    private IDocument myDocument;
    private IQVTReconcilingListener myReconcilingListener;
    private final QvtEditor myEditor;
    private int myLoggedCompilationExceptionsCount = 0;

    public QvtReconcilingStrategy(QvtEditor editor) {
        this.myEditor = editor;
        this.myReconcilingListener = editor;
    }

    public void setDocument(IDocument document) {
        this.myDocument = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcileInternal();
    }

    public void reconcile(IRegion partition) {
        this.reconcileInternal();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.myMonitor = monitor;
    }

    public void initialReconcile() {
        this.reconcileInternal();
    }

    private void reconcileInternal() {
        boolean editingInQvtSourceContainer = QvtCompilerFacade.isEditingInQvtSourceContainer(this.myEditor);
        if (!editingInQvtSourceContainer) {
            return;
        }
        CompiledUnit compilationResult = null;
        try {
            try {
                this.myReconcilingListener.aboutToBeReconciled();
                compilationResult = this.getCompiler(editingInQvtSourceContainer);
            }
            catch (Exception ex) {
                this.handleError(ex);
                this.myReconcilingListener.reconciled(compilationResult, this.myMonitor);
            }
        }
        finally {
            this.myReconcilingListener.reconciled(compilationResult, this.myMonitor);
        }
    }

    private CompiledUnit getCompiler(boolean editingInQvtSourceContainer) {
        QvtCompilerOptions options = new QvtCompilerOptions();
        options.setShowAnnotations(editingInQvtSourceContainer);
        options.setSourceLineNumbersEnabled(false);
        options.enableCSTModelToken(true);
        CompiledUnit compilationResult = QvtCompilerFacade.getInstance().compile(this.myEditor, this.myDocument, options, this.myMonitor);
        return compilationResult;
    }

    private void handleError(Exception ex) {
        if (this.myLoggedCompilationExceptionsCount < 5) {
            ++this.myLoggedCompilationExceptionsCount;
            Activator.log(ex);
            if (this.myLoggedCompilationExceptionsCount == 5) {
                Activator.log((IStatus)new Status(2, "org.eclipse.m2m.qvt.oml.editor.ui", Messages.QvtReconcilingStrategy_TooManyExceptions));
            }
        }
    }
}

