/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTRelation.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTBase.Pattern;
import org.eclipse.qvt.declarative.ecore.QVTBase.Predicate;
import org.eclipse.qvt.declarative.ecore.QVTBase.Rule;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.TransformationOperations;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Relation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationCallExp;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationDomain;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.AbstractQVTRelationOperations;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.QVTRelationMessages;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.PropertyTemplateItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationCallExpOperations
extends AbstractQVTRelationOperations {
    public static RelationCallExpOperations INSTANCE = new RelationCallExpOperations();

    public boolean checkEveryWhenReferredRelationArgumentTypeMatches(RelationCallExp relationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Pattern pattern = this.getPattern((EObject)relationCallExp);
        if (pattern == null) {
            return true;
        }
        Relation relation = this.getRelation((EObject)relationCallExp);
        if (relation == null) {
            return true;
        }
        if (pattern != relation.getWhen()) {
            return true;
        }
        Relation referredRelation = relationCallExp.getReferredRelation();
        if (referredRelation == null) {
            return true;
        }
        EList referredDomains = referredRelation.getDomain();
        int referredArgumentCount = referredDomains.size();
        int argumentCount = relationCallExp.getArgument().size();
        if (argumentCount != referredArgumentCount) {
            return true;
        }
        boolean allOk = true;
        int i = 0;
        while (i < argumentCount) {
            OCLExpression argument = (OCLExpression)relationCallExp.getArgument().get(i);
            EClassifier argumentType = argument.getEType();
            RelationDomain domain = (RelationDomain)referredDomains.get(i);
            EClassifier domainType = domain.getRootVariable().getEType();
            if (!this.assignableFrom(domainType, argumentType)) {
                Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)argumentType, context), this.getObjectLabel((EObject)domainType, context), this.getObjectLabel((EObject)domain, context)};
                this.appendError(diagnostics, argument, QVTRelationMessages._UI_RelationCallExp_WhenReferredRelationArgumentTypeDoesNotMatch, messageSubstitutions);
                allOk = false;
            }
            ++i;
        }
        return allOk;
    }

    public boolean checkEveryWhereReferredRelationArgumentTypeIsMatchableWarning(RelationCallExp relationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Pattern pattern = this.getPattern((EObject)relationCallExp);
        if (pattern == null) {
            return true;
        }
        Relation relation = this.getRelation((EObject)relationCallExp);
        if (relation == null) {
            return true;
        }
        if (pattern != relation.getWhere()) {
            return true;
        }
        Relation referredRelation = relationCallExp.getReferredRelation();
        EList referredDomains = referredRelation.getDomain();
        int referredArgumentCount = referredDomains.size();
        int argumentCount = relationCallExp.getArgument().size();
        if (argumentCount != referredArgumentCount) {
            return true;
        }
        boolean allOk = true;
        int i = 0;
        while (i < argumentCount) {
            RelationDomain domain;
            EClassifier domainType;
            OCLExpression argument = (OCLExpression)relationCallExp.getArgument().get(i);
            EClassifier argumentType = argument.getEType();
            if (!this.assignableFrom(argumentType, domainType = (domain = (RelationDomain)referredDomains.get(i)).getRootVariable().getEType()) && !this.assignableFrom(domainType, argumentType)) {
                Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)argumentType, context), this.getObjectLabel((EObject)domainType, context), this.getObjectLabel((EObject)domain, context)};
                this.appendWarning(diagnostics, argument, QVTRelationMessages._UI_RelationCallExp_WhereReferredRelationArgumentTypeIsNotMatchableWarning, messageSubstitutions);
                allOk = false;
            }
            ++i;
        }
        return allOk;
    }

    public boolean checkInvokedFromWhenOrWhereClause(RelationCallExp relationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Pattern pattern = this.getPattern((EObject)relationCallExp);
        if (pattern == null) {
            return true;
        }
        Relation relation = this.getRelation((EObject)relationCallExp);
        if (relation == null) {
            return true;
        }
        if (pattern == relation.getWhen() || pattern == relation.getWhere()) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)relationCallExp, context)};
        this.appendError(diagnostics, relationCallExp, QVTRelationMessages._UI_RelationCallExp_NotInvokedFromWhenOrWhereClause, messageSubstitutions);
        return false;
    }

    public boolean checkPatternExists(RelationCallExp relationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Pattern pattern = this.getPattern((EObject)relationCallExp);
        if (pattern != null) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)relationCallExp, context)};
        this.appendError(diagnostics, relationCallExp, QVTRelationMessages._UI_RelationCallExp_PatternDoesNotExist, messageSubstitutions);
        return false;
    }

    public boolean checkReferredRelationArgumentNumberMatches(RelationCallExp relationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int argumentCount = relationCallExp.getArgument().size();
        Relation referredRelation = relationCallExp.getReferredRelation();
        if (referredRelation == null) {
            return true;
        }
        int referredArgumentCount = referredRelation.getDomain().size();
        if (argumentCount == referredArgumentCount) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{argumentCount, referredArgumentCount, this.getObjectLabel((EObject)relationCallExp, context)};
        this.appendError(diagnostics, relationCallExp, QVTRelationMessages._UI_RelationCallExp_ReferredRelationArgumentNumberDoesNotMatch, messageSubstitutions);
        return false;
    }

    public boolean checkReferredRelationDeclaredByTransformation(RelationCallExp relationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Relation relation = this.getRelation((EObject)relationCallExp);
        if (relation == null) {
            return true;
        }
        Transformation transformation = relation.getTransformation();
        Relation referredRelation = relationCallExp.getReferredRelation();
        if (referredRelation == null) {
            return true;
        }
        if (TransformationOperations.INSTANCE.declaresRule(transformation, (Rule)referredRelation)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)referredRelation, context), this.getObjectLabel((EObject)transformation, context)};
        this.appendError(diagnostics, relationCallExp, QVTRelationMessages._UI_RelationCallExp_ReferredRelationIsNotDeclaredByTransformation, messageSubstitutions);
        return false;
    }

    public boolean checkRelationExists(RelationCallExp relationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Pattern pattern = this.getPattern((EObject)relationCallExp);
        if (pattern == null) {
            return true;
        }
        Relation relation = this.getRelation((EObject)relationCallExp);
        if (relation != null) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)relationCallExp, context)};
        this.appendError(diagnostics, relationCallExp, QVTRelationMessages._UI_RelationCallExp_RelationDoesNotExist, messageSubstitutions);
        return false;
    }

    public boolean checkTypeIsBoolean(RelationCallExp relationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EClassifier type = relationCallExp.getEType();
        if (type == null) {
            return true;
        }
        if (type != RelationCallExpOperations.getBooleanType()) {
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)relationCallExp, context)};
            this.appendError(diagnostics, relationCallExp, QVTRelationMessages._UI_RelationCallExp_TypeIsNotBoolean, messageSubstitutions);
            return false;
        }
        return true;
    }

    public Pattern getPattern(EObject eObject) {
        EObject parent = eObject.eContainer();
        if (parent instanceof Pattern) {
            return (Pattern)parent;
        }
        if (parent instanceof Predicate) {
            return this.getPattern(parent);
        }
        if (parent instanceof OCLExpression) {
            return this.getPattern(parent);
        }
        if (parent instanceof PropertyTemplateItem) {
            return this.getPattern(parent);
        }
        return null;
    }

    public Relation getRelation(EObject eObject) {
        EObject parent = eObject.eContainer();
        if (parent instanceof Relation) {
            return (Relation)parent;
        }
        if (parent instanceof Domain) {
            return this.getRelation(parent);
        }
        if (parent instanceof Pattern) {
            return this.getRelation(parent);
        }
        if (parent instanceof Predicate) {
            return this.getRelation(parent);
        }
        if (parent instanceof OCLExpression) {
            return this.getRelation(parent);
        }
        if (parent instanceof PropertyTemplateItem) {
            return this.getRelation(parent);
        }
        return null;
    }
}

