/*******************************************************************************
 * Copyright (c) 2015 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
/**
 *
 * $Id$
 */
package org.eclipse.qvtd.compiler.internal.qvtcconfig.validation;

import org.eclipse.emf.common.util.EList;

import org.eclipse.qvtd.compiler.internal.qvtcconfig.Direction;
import org.eclipse.qvtd.compiler.internal.qvtcconfig.Mode;
import org.eclipse.qvtd.compiler.internal.qvtcconfig.Transformation;

/**
 * A sample validator interface for {@link org.eclipse.qvtd.compiler.internal.qvtcconfig.Configuration}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface ConfigurationValidator {
	boolean validate();

	boolean validateInputDirection(Direction value);
	boolean validateOutputDirection(EList<Direction> value);
	boolean validateMode(Mode value);
	boolean validateTransformation(Transformation value);
	boolean validateMiddle(Direction value);
}
