/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.VMStackTraceElement;
import org.eclipse.ocl.pivot.NamedElement;

public class VMStackTraceBuilder {
    private static final @NonNull String UNKNOWN_NAME = "<Unknown>";
    private static final int UNKNOWN_LINE_NUM = -1;
    private @NonNull VMEvaluationEnvironment fEvalEnv;

    public VMStackTraceBuilder(@NonNull VMEvaluationEnvironment evalEnv) {
        this.fEvalEnv = evalEnv;
    }

    public List<VMStackTraceElement> buildStackTrace() {
        LinkedList<VMStackTraceElement> elements = new LinkedList<VMStackTraceElement>();
        VMEvaluationEnvironment nextEnv = this.fEvalEnv;
        while (nextEnv != null) {
            VMEvaluationEnvironment parent = nextEnv.getVMParentEvaluationEnvironment();
            if (parent != null && parent.getDebuggableElement() != null) {
                elements.addLast(this.createStackElement(nextEnv));
            }
            nextEnv = nextEnv.getVMParentEvaluationEnvironment();
        }
        VMEvaluationEnvironment rootEnv = this.fEvalEnv.getVMRootEvaluationEnvironment();
        return Collections.unmodifiableList(elements);
    }

    private @NonNull VMStackTraceElement createStackElement(@NonNull VMEvaluationEnvironment env) {
        String unitName = null;
        String moduleName = UNKNOWN_NAME;
        String operName = UNKNOWN_NAME;
        int lineNumber = -1;
        NamedElement operation = env.getOperation();
        NamedElement currentExpressionInOCL = env.getDebuggableElement();
        moduleName = currentExpressionInOCL.getName();
        operName = operation.getName();
        return new VMStackTraceElement(moduleName, operName, unitName, lineNumber);
    }
}

