/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.state.xtext.validation;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.BehaviorKind;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.DoRule;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.EntryRule;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.ExitRule;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.StateRule;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.SubmachineRule;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.UmlStatePackage;
import org.eclipse.papyrus.uml.textedit.state.xtext.validation.AbstractUmlStateJavaValidator;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementUtil;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtext.validation.Check;

public class UmlStateJavaValidator
extends AbstractUmlStateJavaValidator {
    @Check
    public void checkStateName(StateRule stateRule) {
        boolean deletionOfEntry;
        if (stateRule.getName() == null || stateRule.getName().equals("")) {
            return;
        }
        State editedState = (State)ContextElementUtil.getContextElement((Resource)stateRule.eResource());
        ArrayList<CallSite> alreadyUsedNames = new ArrayList<CallSite>();
        for (Vertex v : editedState.getContainer().getSubvertices()) {
            State s;
            if (!(v instanceof State) || (s = (State)v) == editedState) continue;
            alreadyUsedNames.add((CallSite)((Object)s.getName()));
        }
        String newName = stateRule.getName();
        if (alreadyUsedNames.contains(newName) && InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)stateRule)) {
            this.warning("Name " + newName + " is already used by another State in this Region", (EStructuralFeature)UmlStatePackage.eINSTANCE.getStateRule_Name());
        }
        if (stateRule.getSubmachine() == null && !editedState.getConnections().isEmpty()) {
            this.error(this.getErrorMessageForSubmachineState(), (EStructuralFeature)UmlStatePackage.eINSTANCE.getStateRule_Submachine());
        }
        boolean deletionOfDoActivity = editedState.getDoActivity() != null && stateRule.getDo() == null;
        boolean deletionOfExit = editedState.getExit() != null && stateRule.getExit() == null;
        boolean bl = deletionOfEntry = editedState.getEntry() != null && stateRule.getEntry() == null;
        if (deletionOfDoActivity) {
            this.warning(UmlStateJavaValidator.getBehaviorKindAsString(UmlStateJavaValidator.getBehaviorKind(editedState.getDoActivity())) + " " + editedState.getDoActivity().getName() + " will be deleted", (EStructuralFeature)UmlStatePackage.eINSTANCE.getStateRule_Name());
        }
        if (deletionOfExit) {
            this.warning(UmlStateJavaValidator.getBehaviorKindAsString(UmlStateJavaValidator.getBehaviorKind(editedState.getExit())) + " " + editedState.getExit().getName() + " will be deleted", (EStructuralFeature)UmlStatePackage.eINSTANCE.getStateRule_Name());
        }
        if (deletionOfEntry) {
            this.warning(UmlStateJavaValidator.getBehaviorKindAsString(UmlStateJavaValidator.getBehaviorKind(editedState.getEntry())) + " " + editedState.getEntry().getName() + " will be deleted", (EStructuralFeature)UmlStatePackage.eINSTANCE.getStateRule_Name());
        }
    }

    @Check
    public void checkDoRule(DoRule doRule) {
        if (doRule.getKind() == null) {
            return;
        }
        if (doRule.getBehaviorName() == null || doRule.getBehaviorName().equals("")) {
            return;
        }
        State editedState = (State)ContextElementUtil.getContextElement((Resource)doRule.eResource());
        BehaviorKind oldDoKind = UmlStateJavaValidator.getBehaviorKind(editedState.getDoActivity());
        BehaviorKind newDoKind = doRule.getKind();
        if (oldDoKind != null && oldDoKind != newDoKind) {
            this.warning("Changing the kind of " + doRule.getBehaviorName() + " from <<" + UmlStateJavaValidator.getBehaviorKindAsString(oldDoKind) + ">> to <<" + UmlStateJavaValidator.getBehaviorKindAsString(newDoKind) + ">> will cause the deletion of " + UmlStateJavaValidator.getBehaviorKindAsString(oldDoKind) + " " + doRule.getBehaviorName() + ". Any changes made to " + UmlStateJavaValidator.getBehaviorKindAsString(oldDoKind) + " " + doRule.getBehaviorName() + " will be lost", (EStructuralFeature)UmlStatePackage.eINSTANCE.getDoRule_Kind());
        }
    }

    @Check
    public void checkEntryRule(EntryRule entryRule) {
        if (entryRule.getKind() == null) {
            return;
        }
        if (entryRule.getBehaviorName() == null || entryRule.getBehaviorName().equals("")) {
            return;
        }
        State editedState = (State)ContextElementUtil.getContextElement((Resource)entryRule.eResource());
        BehaviorKind oldDoKind = UmlStateJavaValidator.getBehaviorKind(editedState.getEntry());
        BehaviorKind newDoKind = entryRule.getKind();
        if (oldDoKind != null && oldDoKind != newDoKind) {
            this.warning("Changing the kind of " + entryRule.getBehaviorName() + " from <<" + UmlStateJavaValidator.getBehaviorKindAsString(oldDoKind) + ">> to <<" + UmlStateJavaValidator.getBehaviorKindAsString(newDoKind) + ">> will cause the deletion of " + UmlStateJavaValidator.getBehaviorKindAsString(oldDoKind) + " " + entryRule.getBehaviorName() + ". Any changes made to " + UmlStateJavaValidator.getBehaviorKindAsString(oldDoKind) + " " + entryRule.getBehaviorName() + " will be lost", (EStructuralFeature)UmlStatePackage.eINSTANCE.getEntryRule_Kind());
        }
    }

    @Check
    public void checkExitRule(ExitRule exitRule) {
        if (exitRule.getKind() == null) {
            return;
        }
        if (exitRule.getBehaviorName() == null || exitRule.getBehaviorName().equals("")) {
            return;
        }
        State editedState = (State)ContextElementUtil.getContextElement((Resource)exitRule.eResource());
        BehaviorKind oldDoKind = UmlStateJavaValidator.getBehaviorKind(editedState.getExit());
        BehaviorKind newDoKind = exitRule.getKind();
        if (oldDoKind != null && oldDoKind != newDoKind) {
            this.warning("Changing the kind of " + exitRule.getBehaviorName() + " from <<" + UmlStateJavaValidator.getBehaviorKindAsString(oldDoKind) + ">> to <<" + UmlStateJavaValidator.getBehaviorKindAsString(newDoKind) + ">> will cause the deletion of " + UmlStateJavaValidator.getBehaviorKindAsString(oldDoKind) + " " + exitRule.getBehaviorName() + ". Any changes made to " + UmlStateJavaValidator.getBehaviorKindAsString(oldDoKind) + " " + exitRule.getBehaviorName() + " will be lost", (EStructuralFeature)UmlStatePackage.eINSTANCE.getExitRule_Kind());
        }
    }

    @Check
    public void checkSubmachineRule(SubmachineRule rule) {
        EObject contextElement = ContextElementUtil.getContextElement((Resource)rule.eResource());
        if (contextElement == null || !(contextElement instanceof State)) {
            return;
        }
        State contextState = (State)contextElement;
        if (contextState.isOrthogonal()) {
            this.error(this.getErrorMessageForOrthogonalState(), (EStructuralFeature)UmlStatePackage.eINSTANCE.getSubmachineRule_Submachine());
        }
        if (contextState.isComposite()) {
            this.error(this.getErrorMessageForCompositeState(), (EStructuralFeature)UmlStatePackage.eINSTANCE.getSubmachineRule_Submachine());
        }
    }

    private String getErrorMessageForOrthogonalState() {
        return "An orthogonal state cannot reference a submachine.";
    }

    private String getErrorMessageForCompositeState() {
        return "A composite state cannot reference a submachine.";
    }

    private String getErrorMessageForSubmachineState() {
        return "A simple state cannot have ConnectionPointReferences. You should delete them before removing the reference to the submachine.";
    }

    private static BehaviorKind getBehaviorKind(Behavior behavior) {
        if (behavior == null) {
            return null;
        }
        if (behavior instanceof Activity) {
            return BehaviorKind.ACTIVITY;
        }
        if (behavior instanceof OpaqueBehavior) {
            return BehaviorKind.OPAQUE_BEHAVIOR;
        }
        if (behavior instanceof StateMachine) {
            return BehaviorKind.STATE_MACHINE;
        }
        return null;
    }

    private static String getBehaviorKindAsString(BehaviorKind behaviorKind) {
        if (behaviorKind == BehaviorKind.ACTIVITY) {
            return "Activity";
        }
        if (behaviorKind == BehaviorKind.OPAQUE_BEHAVIOR) {
            return "OpaqueBehavior";
        }
        if (behaviorKind == BehaviorKind.STATE_MACHINE) {
            return "StateMachine";
        }
        return "";
    }
}

