/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActivityPartitionNameEditPart;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class ActivityPartitionLabelHelper
extends StereotypedElementLabelHelper {
    public static final String SHOW_REPRESENT_NAME = "representsName";
    public static final String SHOW_REPRESENT_SELECTOR = "representsSelector";
    public static final String SHOW_REPRESENT_TYPE = "representsType";
    public static final String SHOW_UNDEFINED_TYPE = "undefinedType";
    public static final String SHOW_ACTIVITY_PARTITION_NAME = "activitypartitionName";
    public static final Collection<String> DEFAULT_LABEL_DISPLAY = Arrays.asList("representsName", "representsSelector", "representsType");
    private static final String UNNAMED = "<Unnamed>";
    private static ActivityPartitionLabelHelper labelHelper;
    protected final Map<String, String> masks = new HashMap<String, String>();

    public static ActivityPartitionLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new ActivityPartitionLabelHelper();
        }
        return labelHelper;
    }

    protected ActivityPartitionLabelHelper() {
        this.masks.put(SHOW_REPRESENT_NAME, "Show represent name");
        this.masks.put(SHOW_REPRESENT_SELECTOR, "Show represent selector");
        this.masks.put(SHOW_REPRESENT_TYPE, "Show represent type");
        this.masks.put(SHOW_UNDEFINED_TYPE, "Always show undefined type");
        this.masks.put(SHOW_ACTIVITY_PARTITION_NAME, "Always show activity partition name");
    }

    public Map<String, String> getMasks() {
        return this.masks;
    }

    public ActivityPartition getUMLElement(GraphicalEditPart editPart) {
        return (ActivityPartition)UMLUtil.resolveUMLElement((Object)editPart);
    }

    protected String elementLabel(GraphicalEditPart editPart) {
        GraphicalEditPart graphicalEditPart = editPart;
        if (editPart instanceof ActivityPartitionNameEditPart) {
            graphicalEditPart = (GraphicalEditPart)editPart.getParent();
        }
        Collection displayValue = DEFAULT_LABEL_DISPLAY;
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        return this.getCustomLabel(this.getUMLElement(graphicalEditPart), displayValue);
    }

    private String getCustomLabel(ActivityPartition activitypartition, Collection<String> displayValue) {
        StringBuilder sb = new StringBuilder();
        this.appendName(activitypartition, displayValue, sb);
        return sb.toString();
    }

    protected void appendName(ActivityPartition activitypartition, Collection<String> displayValue, StringBuilder sb) {
        Element represents = activitypartition.getRepresents();
        String activitypartitionName = UMLLabelInternationalization.getInstance().getLabel((NamedElement)activitypartition);
        if (represents instanceof NamedElement) {
            activitypartitionName = ((NamedElement)represents).getName();
        }
        this.appendString(sb, activitypartitionName, UNNAMED);
    }

    private void appendString(StringBuilder sb, String str, String defaultValue) {
        if (str != null) {
            sb.append(str);
        } else {
            sb.append(defaultValue);
        }
    }
}

