/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import java.util.LinkedList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.CircuitEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.GroupTests;

public class GroupsInCompartmentTests
extends GroupTests {
    private static IElementType CIRCUIT_TYPE = ElementTypeRegistry.getInstance().getType("logic.circuit");
    private IGraphicalEditPart logicCompartmentEP;

    public static Test suite() {
        TestSuite s = new TestSuite(GroupsInCompartmentTests.class);
        return s;
    }

    protected IGraphicalEditPart getContainerEP() {
        return this.logicCompartmentEP;
    }

    protected void setTestFixture() {
        this.testFixture = new GroupTests.GroupTestFixture(this){

            protected void createShapesAndConnectors() throws Exception {
                CircuitEditPart circuitEP = (CircuitEditPart)GroupsInCompartmentTests.this.getFixture().createShapeUsingTool(CIRCUIT_TYPE, new Point(5, 5), new Dimension(300, 300));
                GroupsInCompartmentTests.this.logicCompartmentEP = circuitEP.getChildBySemanticHint("LogicCompartment");
            }
        };
    }

    public void testRefreshCanonicalDoesNotCreateDoubles() throws Exception {
        this.setupShapesAndGroups();
        GroupsInCompartmentTests.assertEquals((int)2, (int)this.getContainerEP().getChildren().size());
        this.getFixture().createShapeUsingTool(CIRCUIT_TYPE, new Point(10, 10), new Dimension(50, 50), this.getContainerEP());
        this.flushEventQueue();
        GroupsInCompartmentTests.assertEquals((int)3, (int)this.getContainerEP().getChildren().size());
    }

    public void testDeleteShapeInGroupDoesNotReappear() throws Exception {
        this.setupShapes();
        LinkedList<ShapeEditPart> shapes = new LinkedList<ShapeEditPart>();
        shapes.add(this.getNWShape());
        shapes.add(this.getSWShape());
        shapes.add(this.getSEShape());
        GroupEditPart groupEP = this.groupShapes(shapes);
        GroupsInCompartmentTests.assertEquals((int)2, (int)this.getContainerEP().getChildren().size());
        GroupsInCompartmentTests.assertEquals((int)3, (int)groupEP.getChildren().size());
        GroupRequest request = new GroupRequest((Object)"delete");
        this.getCommandStack().execute(this.getNWShape().getCommand((Request)request));
        GroupsInCompartmentTests.assertEquals((int)2, (int)this.getContainerEP().getChildren().size());
        GroupsInCompartmentTests.assertEquals((int)2, (int)groupEP.getChildren().size());
        this.getFixture().createShapeUsingTool(CIRCUIT_TYPE, new Point(10, 10), new Dimension(50, 50), this.getContainerEP());
        this.flushEventQueue();
        GroupsInCompartmentTests.assertEquals((int)3, (int)this.getContainerEP().getChildren().size());
        GroupsInCompartmentTests.assertEquals((int)2, (int)groupEP.getChildren().size());
    }
}

