/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.label;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TextCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.SharedImages;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.draw2d.ui.figures.LabelEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextFlowEx;
import org.eclipse.gmf.tests.runtime.diagram.ui.label.OriginalWrapLabel;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.TestsPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.osgi.framework.Bundle;

public class TextLabelPropertySection
extends AbstractPropertySection {
    private static final String ICON = "Icon";
    private static final String LABEL_ALIGNMENT = "Label Alignment";
    private static final String ICON_ALIGNMENT = "Icon Alignment";
    private static final String TEXT_ALIGNMENT = "Text Alignment";
    private static final String TEXT_PLACEMENT = "Text Placement";
    private static final String TEXT_JUSTIFICATION = "Text Justification";
    private static final String TEXT_UNDERLINE = "Text Underline";
    private static final String TEXT_STRIKETHROUGH = "Text Strikethrough";
    private static final String TEXT_WRAP = "Text Wrapping";
    private static final String BIG_IMAGE_PATH = "images/test4.gif";
    private static Image bigIcon;
    protected Map buttons = new HashMap();

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.initializeControls(parent);
    }

    private void initializeControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.createTextJustificationGroup(parent);
        this.createTextPlacementGroup(parent);
        this.createLabelAlignmentGroup(parent);
        this.createIconAlignmentGroup(parent);
        this.createTextAlignmentGroup(parent);
        this.createIconGroup(parent);
        this.createTextUnderlineGroup(parent);
        this.createTextStrikethroughGroup(parent);
        this.createTextWrappingGroup(parent);
    }

    public void refresh() {
        super.refresh();
        Iterator i = this.buttons.keySet().iterator();
        while (i.hasNext()) {
            Button radioButton = (Button)this.buttons.get(i.next());
            radioButton.setSelection(false);
        }
        IGraphicalEditPart ep = (IGraphicalEditPart)this.getPrimarySelection();
        if (ep == null) {
            return;
        }
        this.enableLabelAlignmentButtons();
        this.checkButton(new ButtonKey(LABEL_ALIGNMENT, new Integer(this.getLabelAlignment(ep))));
        this.checkButton(new ButtonKey(ICON_ALIGNMENT, new Integer(this.getIconAlignment(ep))));
        this.checkButton(new ButtonKey(TEXT_ALIGNMENT, new Integer(this.getTextAlignment(ep))));
        this.checkButton(new ButtonKey(TEXT_PLACEMENT, new Integer(this.getTextPlacement(ep))));
        this.checkButton(new ButtonKey(TEXT_JUSTIFICATION, new Integer(this.getTextJustification(ep))));
        this.checkButton(new ButtonKey(TEXT_UNDERLINE, new Boolean(this.getTextUnderline(ep))));
        this.checkButton(new ButtonKey(TEXT_STRIKETHROUGH, new Boolean(this.getTextStrikethrough(ep))));
        this.checkButton(new ButtonKey(TEXT_WRAP, new Boolean(this.getWrappingOn(ep))));
    }

    private void enableLabelAlignmentButtons() {
        boolean enableCorners = true;
        for (IGraphicalEditPart ep : this.getSelectedLabelEditParts()) {
            if (!(ep.getFigure() instanceof OriginalWrapLabel) && !(ep.getFigure() instanceof LabelEx)) continue;
            enableCorners = false;
            break;
        }
        Integer[] CORNERS = new Integer[]{new Integer(9), new Integer(12), new Integer(33), new Integer(36)};
        int i = 0;
        while (i < CORNERS.length) {
            Button button = (Button)this.buttons.get(new ButtonKey(LABEL_ALIGNMENT, CORNERS[i]));
            if (button != null && !button.isDisposed()) {
                button.setEnabled(enableCorners);
            }
            ++i;
        }
    }

    private void checkButton(ButtonKey buttonKey) {
        Button button = (Button)this.buttons.get(buttonKey);
        if (button != null && !button.isDisposed()) {
            button.setSelection(true);
        }
    }

    private Group createGroup(Composite parent, String label, int size) {
        Group group = this.getWidgetFactory().createGroup(parent, label);
        group.setLayout((Layout)new GridLayout(size, true));
        GridData data = new GridData(1808);
        group.setLayoutData((Object)data);
        return group;
    }

    private void createTextJustificationGroup(Composite parent) {
        String[] labels = new String[]{"LEFT", "RIGHT", "CENTER"};
        int[] values = new int[]{1, 4, 2};
        Group group = this.createGroup(parent, TEXT_JUSTIFICATION, labels.length);
        int i = 0;
        while (i < labels.length) {
            String label = labels[i];
            final int value = values[i];
            Button radioButton = this.getWidgetFactory().createButton((Composite)group, label, 16);
            this.buttons.put(new ButtonKey(TEXT_JUSTIFICATION, new Integer(value)), radioButton);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextLabelPropertySection.this.setTextJustification(value);
                }
            });
            ++i;
        }
    }

    private void setTextJustification(int alignment) {
        for (IGraphicalEditPart ep : this.getSelectedLabelEditParts()) {
            ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
            if (label == null) continue;
            label.setTextJustification(alignment);
        }
    }

    private int getTextJustification(IGraphicalEditPart ep) {
        ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
        if (label != null) {
            return label.getTextJustification();
        }
        return -1;
    }

    private void createTextAlignmentGroup(Composite parent) {
        String[] labels = new String[]{"LEFT", "RIGHT", "CENTER", "TOP", "BOTTOM"};
        int[] values = new int[]{1, 4, 2, 8, 32};
        Group group = this.createGroup(parent, TEXT_ALIGNMENT, labels.length);
        int i = 0;
        while (i < labels.length) {
            String label = labels[i];
            final int value = values[i];
            Button radioButton = this.getWidgetFactory().createButton((Composite)group, label, 16);
            this.buttons.put(new ButtonKey(TEXT_ALIGNMENT, new Integer(value)), radioButton);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextLabelPropertySection.this.setTextAlignment(value);
                }
            });
            ++i;
        }
    }

    private void setTextAlignment(int alignment) {
        for (IGraphicalEditPart ep : this.getSelectedLabelEditParts()) {
            ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
            if (label == null) continue;
            label.setTextAlignment(alignment);
        }
    }

    private int getTextAlignment(IGraphicalEditPart ep) {
        ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
        if (label != null) {
            return label.getTextAlignment();
        }
        return -1;
    }

    private void createIconAlignmentGroup(Composite parent) {
        String[] labels = new String[]{"LEFT", "RIGHT", "CENTER", "TOP", "BOTTOM"};
        int[] values = new int[]{1, 4, 2, 8, 32};
        Group group = this.createGroup(parent, ICON_ALIGNMENT, labels.length);
        int i = 0;
        while (i < labels.length) {
            String label = labels[i];
            final int value = values[i];
            Button radioButton = this.getWidgetFactory().createButton((Composite)group, label, 16);
            this.buttons.put(new ButtonKey(ICON_ALIGNMENT, new Integer(value)), radioButton);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextLabelPropertySection.this.setIconAlignment(value);
                }
            });
            ++i;
        }
    }

    private void setIconAlignment(int alignment) {
        for (IGraphicalEditPart ep : this.getSelectedLabelEditParts()) {
            ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
            if (label == null) continue;
            label.setIconAlignment(alignment);
        }
    }

    private int getIconAlignment(IGraphicalEditPart ep) {
        ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
        if (label != null) {
            return label.getIconAlignment();
        }
        return -1;
    }

    private void createLabelAlignmentGroup(Composite parent) {
        String[] labels = new String[]{"TOP | LEFT", "TOP", "TOP | RIGHT", "RIGHT", "BOTTOM | RIGHT", "BOTTOM", "BOTTOM | LEFT", "LEFT", "CENTER"};
        int[] values = new int[]{9, 8, 12, 4, 36, 32, 33, 1, 2};
        Group group = this.createGroup(parent, LABEL_ALIGNMENT, labels.length);
        int i = 0;
        while (i < labels.length) {
            String label = labels[i];
            final int value = values[i];
            Button radioButton = this.getWidgetFactory().createButton((Composite)group, label, 16);
            this.buttons.put(new ButtonKey(LABEL_ALIGNMENT, new Integer(value)), radioButton);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextLabelPropertySection.this.setLabelAlignment(value);
                }
            });
            ++i;
        }
    }

    private void setLabelAlignment(int alignment) {
        for (IGraphicalEditPart ep : this.getSelectedLabelEditParts()) {
            ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
            if (label == null) continue;
            label.setAlignment(alignment);
        }
    }

    private int getLabelAlignment(IGraphicalEditPart ep) {
        ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
        if (label != null) {
            return label.getAlignment();
        }
        return -1;
    }

    private void createIconGroup(Composite parent) {
        String[] labels = new String[]{"none", "big", "small", "two", "three"};
        Group group = this.createGroup(parent, ICON, labels.length);
        int i = 0;
        while (i < labels.length) {
            final String label = labels[i];
            Button radioButton = this.getWidgetFactory().createButton((Composite)group, label, 16);
            this.buttons.put(new ButtonKey(ICON, label), radioButton);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextLabelPropertySection.this.setIcon(label);
                }
            });
            ++i;
        }
    }

    private void setIcon(String iconDescription) {
        Image[] icons = new Image[3];
        if (iconDescription.equals("big")) {
            if (bigIcon == null) {
                URL url = FileLocator.find((Bundle)TestsPlugin.getDefault().getBundle(), (IPath)new Path(BIG_IMAGE_PATH), null);
                bigIcon = ImageDescriptor.createFromURL((URL)url).createImage();
            }
            icons[0] = bigIcon;
        } else if (iconDescription.equals("small")) {
            icons[0] = SharedImages.get((String)"icons/note.gif");
        } else if (iconDescription.equals("two")) {
            icons[0] = SharedImages.get((String)"icons/note.gif");
            icons[1] = SharedImages.get((String)"icons/note.gif");
        } else if (iconDescription.equals("three")) {
            icons[0] = SharedImages.get((String)"icons/note.gif");
            icons[1] = SharedImages.get((String)"icons/note.gif");
            icons[2] = SharedImages.get((String)"icons/note.gif");
        }
        for (IGraphicalEditPart ep : this.getSelectedLabelEditParts()) {
            ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
            if (label == null) continue;
            int i = 0;
            while (i < icons.length) {
                label.setIcon(icons[i], i);
                ++i;
            }
        }
    }

    private void createTextPlacementGroup(Composite parent) {
        String[] labels = new String[]{"EAST", "WEST", "NORTH", "SOUTH"};
        int[] values = new int[]{16, 8, 1, 4};
        Group group = this.createGroup(parent, TEXT_PLACEMENT, labels.length);
        int i = 0;
        while (i < labels.length) {
            String label = labels[i];
            final int value = values[i];
            Button radioButton = this.getWidgetFactory().createButton((Composite)group, label, 16);
            this.buttons.put(new ButtonKey(TEXT_PLACEMENT, new Integer(value)), radioButton);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextLabelPropertySection.this.setTextPlacement(value);
                }
            });
            ++i;
        }
    }

    private void setTextPlacement(int placement) {
        for (IGraphicalEditPart ep : this.getSelectedLabelEditParts()) {
            ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
            if (label == null) continue;
            label.setTextPlacement(placement);
        }
    }

    private int getTextPlacement(IGraphicalEditPart ep) {
        ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
        if (label != null) {
            return label.getTextPlacement();
        }
        return -1;
    }

    private void createTextUnderlineGroup(Composite parent) {
        String[] labels = new String[]{"on", "off"};
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] values = blArray;
        Group group = this.createGroup(parent, TEXT_UNDERLINE, labels.length);
        int i = 0;
        while (i < labels.length) {
            String label = labels[i];
            final boolean value = values[i];
            Button radioButton = this.getWidgetFactory().createButton((Composite)group, label, 16);
            this.buttons.put(new ButtonKey(TEXT_UNDERLINE, new Boolean(value)), radioButton);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextLabelPropertySection.this.setTextUnderline(value);
                }
            });
            ++i;
        }
    }

    private void setTextUnderline(boolean underline) {
        for (IGraphicalEditPart ep : this.getSelectedLabelEditParts()) {
            ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
            if (label == null) continue;
            label.setTextUnderline(underline);
        }
    }

    private boolean getTextUnderline(IGraphicalEditPart ep) {
        ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
        if (label != null) {
            return label.isTextUnderlined();
        }
        return false;
    }

    private void createTextStrikethroughGroup(Composite parent) {
        String[] labels = new String[]{"on", "off"};
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] values = blArray;
        Group group = this.createGroup(parent, TEXT_STRIKETHROUGH, labels.length);
        int i = 0;
        while (i < labels.length) {
            String label = labels[i];
            final boolean value = values[i];
            Button radioButton = this.getWidgetFactory().createButton((Composite)group, label, 16);
            this.buttons.put(new ButtonKey(TEXT_STRIKETHROUGH, new Boolean(value)), radioButton);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextLabelPropertySection.this.setTextStrikethrough(value);
                }
            });
            ++i;
        }
    }

    private void setTextStrikethrough(boolean strikethrough) {
        for (IGraphicalEditPart ep : this.getSelectedLabelEditParts()) {
            ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
            if (label == null) continue;
            label.setTextStrikeThrough(strikethrough);
        }
    }

    private boolean getTextStrikethrough(IGraphicalEditPart ep) {
        ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
        if (label != null) {
            return label.isTextStrikedThrough();
        }
        return false;
    }

    private void createTextWrappingGroup(Composite parent) {
        String[] labels = new String[]{"on", "off"};
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] values = blArray;
        Group group = this.createGroup(parent, TEXT_WRAP, labels.length);
        int i = 0;
        while (i < labels.length) {
            String label = labels[i];
            final boolean value = values[i];
            Button radioButton = this.getWidgetFactory().createButton((Composite)group, label, 16);
            this.buttons.put(new ButtonKey(TEXT_WRAP, new Boolean(value)), radioButton);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextLabelPropertySection.this.setWrappingOn(value);
                }
            });
            ++i;
        }
    }

    private void setWrappingOn(boolean wrappingOn) {
        for (IGraphicalEditPart ep : this.getSelectedLabelEditParts()) {
            ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
            if (label == null) continue;
            label.setTextWrapOn(wrappingOn);
        }
    }

    private boolean getWrappingOn(IGraphicalEditPart ep) {
        ILabelDelegate label = (ILabelDelegate)ep.getAdapter(ILabelDelegate.class);
        if (label != null) {
            return label.isTextWrapOn();
        }
        return false;
    }

    protected Object getPrimarySelection() {
        return this.getSelectedLabelEditParts() != null && !this.getSelectedLabelEditParts().isEmpty() ? this.getSelectedLabelEditParts().get(0) : null;
    }

    private List getSelectedLabelEditParts() {
        ArrayList textCompartmentEPs = new ArrayList();
        if (this.getSelection() != null && !this.getSelection().isEmpty()) {
            for (IGraphicalEditPart shapeEP : (IStructuredSelection)this.getSelection()) {
                textCompartmentEPs.addAll(this.getNestedTextCompartmentEditParts(shapeEP));
            }
        }
        return textCompartmentEPs;
    }

    private Collection getNestedTextCompartmentEditParts(IGraphicalEditPart containerEP) {
        HashSet<IGraphicalEditPart> textCompartmentEPs = new HashSet<IGraphicalEditPart>();
        for (IGraphicalEditPart childEP : containerEP.getChildren()) {
            if (childEP instanceof TextCompartmentEditPart) {
                textCompartmentEPs.add(childEP);
                continue;
            }
            textCompartmentEPs.addAll(this.getNestedTextCompartmentEditParts(childEP));
        }
        return textCompartmentEPs;
    }

    private TextFlowEx getTextFlow(WrappingLabel label) {
        return (TextFlowEx)((IFigure)label.getChildren().get(0)).getChildren().get(0);
    }

    private class ButtonKey {
        String label;
        Object value;

        public ButtonKey(String label, Object value) {
            this.label = label;
            this.value = value;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ButtonKey other = (ButtonKey)obj;
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

