/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.pages.DomainModelSource;

public class FileDomainModelSource
implements DomainModelSource {
    private IFile file;
    private IFile newFile;
    private EPackage contents;
    private IStatus errorStatus;

    public IFile getFile() {
        return this.newFile;
    }

    public void setFile(IFile file) {
        this.newFile = file;
    }

    public EPackage getContents() {
        return this.contents;
    }

    public IStatus getErrorStatus() {
        return this.errorStatus;
    }

    public boolean update() {
        if (this.newFile == null || this.newFile != this.file) {
            this.file = this.newFile;
            this.reload();
            return true;
        }
        return false;
    }

    protected void reload() {
        if (this.file == null) {
            this.contents = null;
            this.errorStatus = null;
        }
        try {
            URI uri = URI.createPlatformResourceURI((String)this.file.getFullPath().toString());
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource r = rs.getResource(uri, true);
            this.contents = (EPackage)r.getContents().get(0);
            this.errorStatus = null;
        }
        catch (Exception e) {
            this.contents = null;
            String namespace = Plugin.getDefault().getBundle().getSymbolicName();
            this.errorStatus = new Status(4, namespace, 0, e.getMessage(), (Throwable)e);
        }
    }
}

