/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.internal.common.codegen.GeneratorBase;
import org.eclipse.gmf.tests.CompileUtil;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.RuntimeWorkspaceSetup;

public class GenProjectBaseSetup {
    private final Set projectsToInit = new LinkedHashSet();
    private CompileUtil compileUtil;
    private GeneratorConfiguration myGeneratorFactory;

    public GenProjectBaseSetup(GeneratorConfiguration generatorFactory) {
        this.myGeneratorFactory = generatorFactory;
    }

    public void generateAndCompile(RuntimeWorkspaceSetup rtWorkspace, DiaGenSource diaGenSource) throws Exception {
        rtWorkspace.ensureJava14();
        this.projectsToInit.clear();
        this.compileUtil = new CompileUtil();
        GenDiagram d = diaGenSource.getGenDiagram();
        GenModel domainGenModel = d.getEditorGen().getDomainGenModel();
        domainGenModel.setCanGenerate(true);
        Generator gen = new Generator();
        gen.setInput((Object)domainGenModel);
        gen.generate((Object)domainGenModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)new BasicMonitor());
        this.projectsToInit.add(domainGenModel.getModelPluginID());
        gen.generate((Object)domainGenModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", (Monitor)new BasicMonitor());
        this.projectsToInit.add(domainGenModel.getEditPluginID());
        GeneratorBase generator = this.myGeneratorFactory.createGenerator(d);
        generator.run();
        this.hookGeneratorStatus(generator.getRunStatus());
        String gmfEditorId = d.getEditorGen().getPlugin().getID();
        rtWorkspace.updateClassPath(ResourcesPlugin.getWorkspace().getRoot().getProject(gmfEditorId));
        this.projectsToInit.add(gmfEditorId);
        Iterator it = this.projectsToInit.iterator();
        while (it.hasNext()) {
            String pluginID = (String)it.next();
            IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginID);
            this.hookProjectBuild(p);
        }
        this.compileUtil = null;
    }

    public List getGeneratedProjectNames() {
        return Collections.unmodifiableList(new LinkedList(this.projectsToInit));
    }

    protected void hookProjectBuild(IProject p) throws Exception {
        IStatus s = this.compileUtil.build(p);
        if (!s.isOK()) {
            Plugin.logError(s.getMessage());
            Assert.fail((String)s.getMessage());
        }
    }

    protected void hookGeneratorStatus(IStatus generatorStatus) {
        if (!generatorStatus.isOK()) {
            Plugin.getInstance().getLog().log(generatorStatus);
        }
        if (generatorStatus.getSeverity() == 4) {
            Assert.fail((String)("GMF editor generation produced errors:" + generatorStatus.toString()));
        }
    }
}

