/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.BorderLayout;
import org.eclipse.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FlowLayout;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.LayoutData;
import org.eclipse.gmf.gmfgraph.XYLayoutData;
import org.eclipse.gmf.tests.gen.GenericFigureCheck;

public class LayoutAwareCheck
extends GenericFigureCheck {
    public static AlignmentCheck FLOW_AND_TOOLBAR = new AlignmentCheck(1, 0, 2, 0);
    public static AlignmentCheck BORDER_VERTICAL = new AlignmentCheck(org.eclipse.draw2d.BorderLayout.TOP, org.eclipse.draw2d.BorderLayout.CENTER, org.eclipse.draw2d.BorderLayout.BOTTOM, org.eclipse.draw2d.BorderLayout.CENTER);
    public static AlignmentCheck BORDER_HORIZONTAL = new AlignmentCheck(org.eclipse.draw2d.BorderLayout.LEFT, org.eclipse.draw2d.BorderLayout.CENTER, org.eclipse.draw2d.BorderLayout.RIGHT, org.eclipse.draw2d.BorderLayout.CENTER);

    public LayoutAwareCheck(Figure eFigure) {
        super(eFigure);
    }

    protected void checkFigureItself(Figure gmfFigure, IFigure d2dFigure) {
        super.checkFigureItself(gmfFigure, d2dFigure);
        this.checkLayout(gmfFigure.getLayout(), d2dFigure.getLayoutManager());
        this.checkLayoutData(gmfFigure.getLayoutData(), d2dFigure);
    }

    protected void checkLayoutData(LayoutData gmf, IFigure d2dFigure) {
        if (gmf == null || d2dFigure.getParent() == null) {
            return;
        }
        LayoutManager layouter = d2dFigure.getParent().getLayoutManager();
        if (layouter == null) {
            return;
        }
        Object constraint = layouter.getConstraint(d2dFigure);
        LayoutAwareCheck.assertTrue((gmf instanceof BorderLayoutData || constraint != null ? 1 : 0) != 0);
        if (gmf instanceof BorderLayoutData) {
            if (d2dFigure.isVisible()) {
                LayoutAwareCheck.assertTrue((boolean)(layouter instanceof org.eclipse.draw2d.BorderLayout));
                org.eclipse.draw2d.BorderLayout borderLayout = (org.eclipse.draw2d.BorderLayout)layouter;
                d2dFigure.getParent().invalidate();
                Dimension on = borderLayout.getPreferredSize(d2dFigure, 1000000, 1000000);
                d2dFigure.setVisible(false);
                d2dFigure.getParent().invalidate();
                Dimension off = borderLayout.getPreferredSize(d2dFigure, 1000000, 1000000);
                LayoutAwareCheck.assertFalse((boolean)on.equals((Object)off));
                d2dFigure.setVisible(true);
                d2dFigure.getParent().invalidate();
            }
        } else if (gmf instanceof XYLayoutData) {
            LayoutAwareCheck.assertTrue((boolean)(constraint instanceof Rectangle));
            Rectangle d2dBounds = (Rectangle)constraint;
            XYLayoutData gmfData = (XYLayoutData)gmf;
            this.checkDimension(gmfData.getSize(), d2dBounds.getSize());
            this.checkPoint(gmfData.getTopLeft(), d2dBounds.getTopLeft());
        }
    }

    protected void checkLayout(Layout gmfLayout, LayoutManager d2dLayout) {
        if (gmfLayout == null) {
            return;
        }
        LayoutAwareCheck.assertNotNull((Object)d2dLayout);
        if (gmfLayout instanceof org.eclipse.gmf.gmfgraph.XYLayout) {
            LayoutAwareCheck.assertTrue((boolean)(d2dLayout instanceof XYLayout));
        } else if (gmfLayout instanceof org.eclipse.gmf.gmfgraph.StackLayout) {
            LayoutAwareCheck.assertTrue((boolean)(d2dLayout instanceof StackLayout));
        } else if (gmfLayout instanceof BorderLayout) {
            LayoutAwareCheck.assertTrue((boolean)(d2dLayout instanceof org.eclipse.draw2d.BorderLayout));
        } else if (gmfLayout instanceof FlowLayout) {
            FlowLayout gmfFlow = (FlowLayout)gmfLayout;
            if (gmfFlow.isForceSingleLine()) {
                LayoutAwareCheck.assertTrue((boolean)(d2dLayout instanceof ToolbarLayout));
                this.checkToolbarLayout(gmfFlow, (ToolbarLayout)d2dLayout);
            } else {
                LayoutAwareCheck.assertTrue((boolean)(d2dLayout instanceof org.eclipse.draw2d.FlowLayout));
                this.checkFlowLayout(gmfFlow, (org.eclipse.draw2d.FlowLayout)d2dLayout);
            }
        }
    }

    protected void checkToolbarLayout(FlowLayout gmfFlow, ToolbarLayout layout) {
        if (gmfFlow.eIsSet((EStructuralFeature)GMFGraphPackage.eINSTANCE.getFlowLayout_MajorSpacing())) {
            LayoutAwareCheck.assertEquals((int)gmfFlow.getMajorSpacing(), (int)layout.getSpacing());
        }
        LayoutAwareCheck.assertEquals((boolean)gmfFlow.isVertical(), (!layout.isHorizontal() ? 1 : 0) != 0);
        LayoutAwareCheck.assertEquals((boolean)gmfFlow.isMatchMinorSize(), (boolean)layout.getStretchMinorAxis());
        FLOW_AND_TOOLBAR.checkAlignment(gmfFlow.getMinorAlignment(), layout.getMinorAlignment());
    }

    protected void checkFlowLayout(FlowLayout gmfFlow, org.eclipse.draw2d.FlowLayout layout) {
        LayoutAwareCheck.assertEquals((int)gmfFlow.getMajorSpacing(), (int)layout.getMajorSpacing());
        LayoutAwareCheck.assertEquals((int)gmfFlow.getMinorSpacing(), (int)layout.getMinorSpacing());
        LayoutAwareCheck.assertEquals((boolean)gmfFlow.isVertical(), (!layout.isHorizontal() ? 1 : 0) != 0);
        FLOW_AND_TOOLBAR.checkAlignment(gmfFlow.getMinorAlignment(), layout.getMinorAlignment());
        FLOW_AND_TOOLBAR.checkAlignment(gmfFlow.getMajorAlignment(), layout.getMajorAlignment());
    }

    private static class AlignmentCheck {
        private final Integer[] myExpectedValues;

        public AlignmentCheck(int beginning, int center, int end, int fill) {
            this.myExpectedValues = new Integer[]{new Integer(beginning), new Integer(center), new Integer(end), new Integer(fill)};
        }

        public AlignmentCheck(Integer beginning, Integer center, Integer end, Integer fill) {
            this.myExpectedValues = new Integer[]{beginning, center, end, fill};
        }

        public void checkAlignment(Alignment gmf, int actual) {
            this.checkAlignment(gmf, new Integer(actual));
        }

        public void checkAlignment(Alignment gmf, Integer actual) {
            if (gmf != null) {
                LayoutAwareCheck.assertEquals((Object)this.myExpectedValues[gmf.getValue()], (Object)actual);
            }
        }
    }
}

