/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.polocies;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.gmfgraph.Point;
import org.eclipse.gmf.graphdef.editor.edit.polocies.AbstractDomainBasedXYLayoutEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class PointContainerXYLayoutEditPolicy
extends AbstractDomainBasedXYLayoutEditPolicy {
    private boolean myIsInsideFigure;

    public PointContainerXYLayoutEditPolicy(IMapMode mapMode, boolean isInsideFigure) {
        super(mapMode);
        this.myIsInsideFigure = isInsideFigure;
    }

    protected ICommand createSetBoundsCommand(TransactionalEditingDomain editingDomain, String label, Resource resource, CreateViewRequest.ViewDescriptor viewDescriptor, Rectangle rect) {
        return new SetBoundsCommand(editingDomain, label, resource, (IAdaptable)viewDescriptor, rect);
    }

    protected ICommand createSetBoundsCommand(TransactionalEditingDomain editingDomain, String label, Resource resource, Rectangle bounds, EObject element) {
        if (element instanceof Point) {
            Point point = (Point)element;
            return new SetBoundsCommand(editingDomain, label, resource, bounds, point);
        }
        return null;
    }

    private final class SetBoundsCommand
    extends AbstractTransactionalCommand {
        private Rectangle myBounds;
        private Point myPoint;
        private IAdaptable myAdaptable;

        protected SetBoundsCommand(TransactionalEditingDomain domain, String label, Resource resource, Rectangle bounds, Point point) {
            super(domain, label, Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)resource)));
            this.myBounds = bounds;
            this.myPoint = point;
        }

        protected SetBoundsCommand(TransactionalEditingDomain domain, String label, Resource resource, IAdaptable adaptable, Rectangle bounds) {
            super(domain, label, Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)resource)));
            this.myBounds = bounds;
            this.myAdaptable = adaptable;
        }

        private Point getPoint() {
            if (this.myPoint != null) {
                return this.myPoint;
            }
            View view = (View)this.myAdaptable.getAdapter(View.class);
            return (Point)view.getElement();
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            int x = PointContainerXYLayoutEditPolicy.this.getMapMode().LPtoDP(this.myBounds.x);
            int y = PointContainerXYLayoutEditPolicy.this.getMapMode().LPtoDP(this.myBounds.y);
            if (PointContainerXYLayoutEditPolicy.this.myIsInsideFigure) {
                Rectangle editPartBounds = ((GraphicalEditPart)PointContainerXYLayoutEditPolicy.this.getHost()).getFigure().getBounds();
                x += PointContainerXYLayoutEditPolicy.this.getMapMode().LPtoDP(editPartBounds.x);
                y += PointContainerXYLayoutEditPolicy.this.getMapMode().LPtoDP(editPartBounds.y);
            }
            Point point = this.getPoint();
            point.setX(x);
            point.setY(y);
            return CommandResult.newOKCommandResult();
        }
    }
}

