/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.svg;

import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.SVGFigure;
import org.eclipse.gmf.gmfgraph.SVGProperty;
import org.eclipse.gmf.gmfgraph.SVGPropertyType;
import org.eclipse.gmf.tests.lite.svg.AbstractSVGFigureTest;
import org.eclipse.gmf.tests.setup.figures.AbstractFigureGeneratorSetup;
import org.eclipse.gmf.tests.setup.figures.FigureGeneratorUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedSVGFigureTest
extends AbstractSVGFigureTest {
    public GeneratedSVGFigureTest(String name) {
        super(name);
    }

    private AbstractFigureGeneratorSetup getSessionSetup(final SVGFigure f) {
        return new AbstractFigureGeneratorSetup(){

            protected void addFigures(FigureGallery gallery) {
                gallery.setImplementationBundle("org.eclipse.gmf.runtime.lite.svg");
                gallery.getFigures().add((Object)f);
            }
        };
    }

    protected org.eclipse.gmf.runtime.lite.svg.SVGFigure createDraw2DFigure(Class<?> figureClass) {
        Object result = null;
        try {
            result = figureClass.newInstance();
        }
        catch (Exception e) {
            GeneratedSVGFigureTest.fail((String)(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getMessage()));
        }
        GeneratedSVGFigureTest.assertTrue((String)figureClass.getName(), (boolean)(result instanceof org.eclipse.gmf.runtime.lite.svg.SVGFigure));
        return result;
    }

    protected org.eclipse.gmf.runtime.lite.svg.SVGFigure createDraw2DFigure(SVGFigure f) {
        AbstractFigureGeneratorSetup ss = this.getSessionSetup(f);
        FigureGeneratorUtil.generateAndParse((RealFigure)f);
        Class fClass = ss.getFigureClass((Figure)f);
        return this.createDraw2DFigure(fClass);
    }

    public void testBasicGeneration() {
        SVGFigure f = GMFGraphFactory.eINSTANCE.createSVGFigure();
        f.setName("Crate");
        f.setDocumentURI("platform:/plugin/org.eclipse.gmf.tests.lite/images/box.svg");
        org.eclipse.gmf.runtime.lite.svg.SVGFigure f2d = this.createDraw2DFigure(f);
        GeneratedSVGFigureTest.assertEquals((String)"platform:/plugin/org.eclipse.gmf.tests.lite/images/box.svg", (String)f2d.getURI());
        GeneratedSVGFigureTest.assertNull((Object)f2d.getAreaOfInterest());
    }

    public void testAdvancedProperties() {
        SVGFigure f = GMFGraphFactory.eINSTANCE.createSVGFigure();
        f.setName("Crate");
        f.setDocumentURI("platform:/plugin/org.eclipse.gmf.tests.lite/images/box.svg");
        f.setAreaOfInterest(GMFGraphFactory.eINSTANCE.createRectangle2D());
        f.getAreaOfInterest().setX(10.0f);
        f.getAreaOfInterest().setY(0.5f);
        f.getAreaOfInterest().setWidth(555.0f);
        f.getAreaOfInterest().setHeight(44.4f);
        org.eclipse.gmf.runtime.lite.svg.SVGFigure f2d = this.createDraw2DFigure(f);
        GeneratedSVGFigureTest.assertEquals((String)"platform:/plugin/org.eclipse.gmf.tests.lite/images/box.svg", (String)f2d.getURI());
        Rectangle2D aoi = f2d.getAreaOfInterest();
        GeneratedSVGFigureTest.assertNotNull((Object)aoi);
        GeneratedSVGFigureTest.assertEquals((Object)Float.valueOf(10.0f), (Object)Float.valueOf((float)aoi.getX()));
        GeneratedSVGFigureTest.assertEquals((Object)Float.valueOf(0.5f), (Object)Float.valueOf((float)aoi.getY()));
        GeneratedSVGFigureTest.assertEquals((Object)Float.valueOf(555.0f), (Object)Float.valueOf((float)aoi.getWidth()));
        GeneratedSVGFigureTest.assertEquals((Object)Float.valueOf(44.4f), (Object)Float.valueOf((float)aoi.getHeight()));
    }

    public void testStringProperty() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        SVGFigure f = GMFGraphFactory.eINSTANCE.createSVGFigure();
        f.setName("Crate");
        f.setDocumentURI("platform:/plugin/org.eclipse.gmf.tests.lite/images/box.svg");
        SVGProperty p = GMFGraphFactory.eINSTANCE.createSVGProperty();
        p.setQuery("//:rect");
        p.setAttribute("width");
        p.setGetter("getA");
        p.setSetter("setA");
        f.getProperties().add((Object)p);
        org.eclipse.gmf.runtime.lite.svg.SVGFigure f2d = this.createDraw2DFigure(f);
        Method getter = f2d.getClass().getMethod("getA", new Class[0]);
        Method setter = f2d.getClass().getMethod("setA", String.class);
        String v = (String)getter.invoke((Object)f2d, new Object[0]);
        GeneratedSVGFigureTest.assertEquals((String)"49", (String)v);
        setter.invoke((Object)f2d, "23");
        v = (String)getter.invoke((Object)f2d, new Object[0]);
        GeneratedSVGFigureTest.assertEquals((String)"23", (String)v);
    }

    public void testColorProperty() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        SVGFigure f = GMFGraphFactory.eINSTANCE.createSVGFigure();
        f.setName("Crate");
        f.setDocumentURI("platform:/plugin/org.eclipse.gmf.tests.lite/images/box.svg");
        SVGProperty p = GMFGraphFactory.eINSTANCE.createSVGProperty();
        p.setQuery("//:rect");
        p.setAttribute("fill");
        p.setGetter("getBackgroundColorX");
        p.setSetter("setBackgroundColor");
        p.setCallSuper(true);
        p.setType(SVGPropertyType.COLOR);
        f.getProperties().add((Object)p);
        org.eclipse.gmf.runtime.lite.svg.SVGFigure f2d = this.createDraw2DFigure(f);
        Method getter = f2d.getClass().getMethod("getBackgroundColorX", new Class[0]);
        Color v = (Color)getter.invoke((Object)f2d, new Object[0]);
        GeneratedSVGFigureTest.assertEquals((Object)new RGB(102, 51, 0), (Object)v.getRGB());
        f2d.setBackgroundColor(new Color(null, 255, 85, 0));
        GeneratedSVGFigureTest.assertEquals((Object)new RGB(255, 85, 0), (Object)f2d.getBackgroundColor().getRGB());
        v = (Color)getter.invoke((Object)f2d, new Object[0]);
        GeneratedSVGFigureTest.assertEquals((Object)new RGB(255, 85, 0), (Object)v.getRGB());
    }

    public void testFloatProperty() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        SVGFigure f = GMFGraphFactory.eINSTANCE.createSVGFigure();
        f.setName("Crate");
        f.setDocumentURI("platform:/plugin/org.eclipse.gmf.tests.lite/images/box.svg");
        SVGProperty p = GMFGraphFactory.eINSTANCE.createSVGProperty();
        p.setQuery("//:line[5]");
        p.setAttribute("x1");
        p.setGetter("getX");
        p.setSetter("setX");
        p.setType(SVGPropertyType.FLOAT);
        f.getProperties().add((Object)p);
        org.eclipse.gmf.runtime.lite.svg.SVGFigure f2d = this.createDraw2DFigure(f);
        Method getter = f2d.getClass().getMethod("getX", new Class[0]);
        Method setter = f2d.getClass().getMethod("setX", Float.TYPE);
        float v = ((Float)getter.invoke((Object)f2d, new Object[0])).floatValue();
        GeneratedSVGFigureTest.assertEquals((Object)Float.valueOf(30.0f), (Object)Float.valueOf(v));
        setter.invoke((Object)f2d, Float.valueOf(23.0f));
        v = ((Float)getter.invoke((Object)f2d, new Object[0])).floatValue();
        GeneratedSVGFigureTest.assertEquals((Object)Float.valueOf(23.0f), (Object)Float.valueOf(v));
    }
}

