/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.diagram.edit.commands.EcoreCreateShortcutDecorationsCommand;
import org.eclipse.emf.ecoretools.diagram.edit.commands.RestoreRelatedLinksCommand;
import org.eclipse.emf.ecoretools.diagram.edit.commands.UpdateEditPartCommand;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageDiagramDragDropEditPolicy
extends DiagramDragDropEditPolicy {
    protected Command getDropCommand(ChangeBoundsRequest dropRequest) {
        ArrayList<CreateViewRequest.ViewDescriptor> shortcutViewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        ArrayList<CreateViewRequest.ViewDescriptor> normalViewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        for (Object nextPart : dropRequest.getEditParts()) {
            EObject nextObject;
            if (!(nextPart instanceof IGraphicalEditPart) || (nextObject = ((IGraphicalEditPart)nextPart).resolveSemanticElement()) == null || this.getView().getElement().equals(nextObject)) continue;
            if (!this.isElementInView(nextObject, (Request)dropRequest) && this.getView().getElement() == nextObject.eContainer()) {
                normalViewDescriptors.add(new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(nextObject), Node.class, null, this.getDiagramPreferencesHint()));
                continue;
            }
            shortcutViewDescriptors.add(new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(nextObject), Node.class, null, this.getDiagramPreferencesHint()));
        }
        Command shortcutCommand = null;
        if (!shortcutViewDescriptors.isEmpty()) {
            shortcutCommand = this.createShortcutsCommand(dropRequest, shortcutViewDescriptors);
        }
        Command normalCommand = null;
        if (!normalViewDescriptors.isEmpty()) {
            normalCommand = this.createNormalViewCommand(dropRequest, normalViewDescriptors);
        }
        if (shortcutCommand != null) {
            Command createBoth = shortcutCommand.chain(normalCommand);
            return createBoth;
        }
        return normalCommand;
    }

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        ArrayList<CreateViewRequest.ViewDescriptor> shortcutViewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        ArrayList<CreateViewRequest.ViewDescriptor> normalViewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        for (Object nextObject : dropRequest.getObjects()) {
            if (!(nextObject instanceof EObject) || this.getView().getElement().equals(nextObject)) continue;
            if (!this.isElementInView(nextObject, (Request)dropRequest) && this.getView().getElement() == ((EObject)nextObject).eContainer()) {
                normalViewDescriptors.add(new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)nextObject), Node.class, null, this.getDiagramPreferencesHint()));
                continue;
            }
            shortcutViewDescriptors.add(new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)nextObject), Node.class, null, this.getDiagramPreferencesHint()));
        }
        Command shortcutCommand = null;
        if (!shortcutViewDescriptors.isEmpty()) {
            shortcutCommand = this.createShortcutsCommand(dropRequest, shortcutViewDescriptors);
        }
        Command normalCommand = null;
        if (!normalViewDescriptors.isEmpty()) {
            normalCommand = this.createNormalViewCommand(dropRequest, normalViewDescriptors);
        }
        if (shortcutCommand != null) {
            Command createBoth = shortcutCommand.chain(normalCommand);
            return createBoth.chain((Command)new ICommandProxy((ICommand)new UpdateEditPartCommand(this.getEditingDomain(), this.getHost())));
        }
        if (normalCommand != null) {
            return normalCommand.chain((Command)new ICommandProxy((ICommand)new UpdateEditPartCommand(this.getEditingDomain(), this.getHost())));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean isElementInView(Object nextObject, Request request) {
        EList views = this.getView().getChildren();
        for (View nextView : views) {
            if (nextView.getEAnnotation("Shortcut") != null || nextView.getElement() == null || !nextView.getElement().equals(nextObject)) continue;
            return true;
        }
        return false;
    }

    private Command createShortcutsCommand(DropObjectsRequest dropRequest, List<? extends CreateViewRequest.ViewDescriptor> viewDescriptors) {
        Command command = this.createViews(dropRequest, viewDescriptors);
        if (command != null) {
            return command.chain((Command)new ICommandProxy((ICommand)new EcoreCreateShortcutDecorationsCommand(this.getEditingDomain(), this.getView(), viewDescriptors)));
        }
        return null;
    }

    private Command createShortcutsCommand(ChangeBoundsRequest dropRequest, List<? extends CreateViewRequest.ViewDescriptor> viewDescriptors) {
        Command command = this.createViews(dropRequest, viewDescriptors);
        if (command != null) {
            return command.chain((Command)new ICommandProxy((ICommand)new EcoreCreateShortcutDecorationsCommand(this.getEditingDomain(), this.getView(), viewDescriptors)));
        }
        return null;
    }

    private Command createNormalViewCommand(DropObjectsRequest dropRequest, List<? extends CreateViewRequest.ViewDescriptor> viewDescriptors) {
        return this.createViewsAndRestoreRelatedLinks(dropRequest, viewDescriptors);
    }

    private Command createNormalViewCommand(ChangeBoundsRequest dropRequest, List<? extends CreateViewRequest.ViewDescriptor> viewDescriptors) {
        return this.createViewsAndRestoreRelatedLinks(dropRequest, viewDescriptors);
    }

    protected Command createViews(DropObjectsRequest dropRequest, List<? extends CreateViewRequest.ViewDescriptor> viewDescriptors) {
        CreateViewRequest createViewRequest = new CreateViewRequest(viewDescriptors);
        createViewRequest.setLocation(dropRequest.getLocation());
        Command createCommand = this.getHost().getCommand((Request)createViewRequest);
        return createCommand;
    }

    protected Command createViewsAndRestoreRelatedLinks(DropObjectsRequest dropRequest, List<? extends CreateViewRequest.ViewDescriptor> viewDescriptors) {
        CreateViewRequest createViewRequest = new CreateViewRequest(viewDescriptors);
        createViewRequest.setLocation(dropRequest.getLocation());
        Command createCommand = this.getHost().getCommand((Request)createViewRequest);
        this.restoreRelatedLinks(createViewRequest, createCommand);
        return createCommand;
    }

    private void restoreRelatedLinks(CreateViewRequest createViewRequest, Command createCommand) {
        List viewAdapters = (List)createViewRequest.getNewObject();
        createCommand.chain((Command)new ICommandProxy((ICommand)new RestoreRelatedLinksCommand(this.getDiagramEditPart(), viewAdapters)));
    }

    private DiagramEditPart getDiagramEditPart() {
        if (this.getHost() instanceof DiagramEditPart) {
            return (DiagramEditPart)this.getHost();
        }
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editorPart instanceof DiagramEditor)) {
            return null;
        }
        return ((DiagramEditor)editorPart).getDiagramEditPart();
    }

    protected Command createViews(ChangeBoundsRequest dropRequest, List<? extends CreateViewRequest.ViewDescriptor> viewDescriptors) {
        CreateViewRequest createViewRequest = new CreateViewRequest(viewDescriptors);
        createViewRequest.setLocation(dropRequest.getLocation());
        Command createCommand = this.getHost().getCommand((Request)createViewRequest);
        return createCommand;
    }

    protected Command createViewsAndRestoreRelatedLinks(ChangeBoundsRequest dropRequest, List<? extends CreateViewRequest.ViewDescriptor> viewDescriptors) {
        CreateViewRequest createViewRequest = new CreateViewRequest(viewDescriptors);
        createViewRequest.setLocation(dropRequest.getLocation());
        Command createCommand = this.getHost().getCommand((Request)createViewRequest);
        this.restoreRelatedLinks(createViewRequest, createCommand);
        return createCommand;
    }

    private TransactionalEditingDomain getEditingDomain() {
        if (this.getHost() instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        }
        return null;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    protected PreferencesHint getDiagramPreferencesHint() {
        return EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
    }
}

