/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.protocol;

import org.eclipse.emf.cdo.client.AttributeInfo;
import org.eclipse.emf.cdo.client.ClassInfo;
import org.eclipse.emf.cdo.client.PackageInfo;
import org.eclipse.emf.cdo.client.protocol.AbstractPackageRequest;

public class DescribePackageRequest
extends AbstractPackageRequest {
    private PackageInfo packageInfo;

    public DescribePackageRequest(PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
    }

    public short getSignalId() {
        return 2;
    }

    public void request() {
        if (this.isDebugEnabled()) {
            this.debug("Describing package " + this.packageInfo.getFullName());
        }
        this.transmitString(this.packageInfo.getFullName());
        ClassInfo[] classes = this.packageInfo.getClasses();
        this.transmitInt(classes.length);
        int i = 0;
        while (i < classes.length) {
            ClassInfo classInfo = classes[i];
            if (this.isDebugEnabled()) {
                this.debug("Describing class " + classInfo.getFullName());
            }
            this.transmitString(classInfo.getFullName());
            this.transmitString(classInfo.getParent() == null ? null : classInfo.getParent().getFullName());
            this.transmitString(classInfo.getMapping().getTableName());
            this.transmitAttributes(classInfo);
            ++i;
        }
    }

    public Object confirm() {
        int count = this.receiveInt();
        if (count >= 0) {
            this.handlePackageResponse(count);
            return Boolean.TRUE;
        }
        if (this.isDebugEnabled()) {
            this.debug("Unknown package " + this.packageInfo.getFullName());
        }
        return Boolean.FALSE;
    }

    private void transmitAttributes(ClassInfo classInfo) {
        AttributeInfo[] attributes = classInfo.getAttributeInfos();
        this.transmitInt(attributes.length);
        int j = 0;
        while (j < attributes.length) {
            AttributeInfo attributeInfo = attributes[j];
            if (this.isDebugEnabled()) {
                this.debug("Describing attribute " + attributeInfo.getName());
            }
            this.transmitString(attributeInfo.getName());
            this.transmitInt(attributeInfo.getEAttribute().getFeatureID());
            this.transmitInt(attributeInfo.getDataType());
            this.transmitString(attributeInfo.getMapping().getColumnName());
            this.transmitInt(attributeInfo.getMapping().getColumnType());
            ++j;
        }
    }
}

