/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.services;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.core.services.AbstractExtensionManager;
import org.eclipse.emf.search.ui.Activator;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.emf.search.ui.services.ActionContributionDescriptor;

public class ActionContributionExtensionManager
extends AbstractExtensionManager {
    private static final String bundleId = Activator.getDefault().getBundle().getSymbolicName();
    public static final String MODEL_SEARCH_PAGE_ACTION_CONTRIBUTION_EXT_POINT_ID = String.valueOf(bundleId) + ".modelSearchPageActionContribution";
    private static ActionContributionExtensionManager manager;
    private SortedSet<ActionContributionDescriptor> actionContributions = new TreeSet<ActionContributionDescriptor>(new Comparator<ActionContributionDescriptor>(){

        @Override
        public int compare(ActionContributionDescriptor o1, ActionContributionDescriptor o2) {
            return o2.getID().compareTo(o1.getID());
        }
    });

    protected ActionContributionExtensionManager() {
        super(MODEL_SEARCH_PAGE_ACTION_CONTRIBUTION_EXT_POINT_ID);
        this.readRegistry();
    }

    public static ActionContributionExtensionManager getInstance() {
        return manager == null ? (manager = new ActionContributionExtensionManager()) : manager;
    }

    public ActionContributionDescriptor find(String id) {
        for (ActionContributionDescriptor desc : this.actionContributions) {
            if (!id.equals(desc.getID())) continue;
            return desc;
        }
        return null;
    }

    public ActionContributionDescriptor[] getActionContributions() {
        return this.actionContributions.toArray(new ActionContributionDescriptor[this.actionContributions.size()]);
    }

    protected void addExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            try {
                this.actionContributions.add(new ActionContributionDescriptor(confElt));
            }
            catch (CoreException ce) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, bundleId, 0, Messages.getString("ActionContributionDescriptorExtensionManager.addExtensionErrorMessage"), (Throwable)ce));
            }
            ++n2;
        }
    }

    protected void removeExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            String id = confElt.getAttribute("action");
            ActionContributionDescriptor descriptor = this.find(id);
            this.actionContributions.remove(descriptor);
            ++n2;
        }
    }
}

