/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.pages;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.results.AbstractModelSearchResultEntry;
import org.eclipse.emf.search.core.results.IModelResultEntry;
import org.eclipse.emf.search.core.results.IModelSearchResult;
import org.eclipse.emf.search.core.results.ModelSearchResult;
import org.eclipse.emf.search.core.results.ModelSearchResultEvent;
import org.eclipse.emf.search.ui.Activator;
import org.eclipse.emf.search.ui.actions.AbstractModelSearchPageAction;
import org.eclipse.emf.search.ui.actions.AbstractModelSearchPageActionGroup;
import org.eclipse.emf.search.ui.actions.OpenInDiagramEditorAction;
import org.eclipse.emf.search.ui.actions.OpenInLegacyEditorAction;
import org.eclipse.emf.search.ui.actions.ToggleOpenButtonAction;
import org.eclipse.emf.search.ui.handlers.IModelElementEditorSelectionHandler;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.emf.search.ui.pages.ModelEditorOpenEnum;
import org.eclipse.emf.search.ui.providers.DecoratingModelSearchResultLabelProvider;
import org.eclipse.emf.search.ui.services.ActionContributionDescriptor;
import org.eclipse.emf.search.ui.services.ActionContributionExtensionManager;
import org.eclipse.emf.search.ui.services.MenuContributionDescriptor;
import org.eclipse.emf.search.ui.services.MenuContributionExtensionManager;
import org.eclipse.emf.search.ui.services.ModelSearchParticipantTabExtensionManager;
import org.eclipse.emf.search.ui.services.ParticipantTabDescriptor;
import org.eclipse.emf.search.ui.utils.ModelSearchResultItemProvider;
import org.eclipse.emf.search.utils.ModelSearchImagesUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelSearchResultPage
extends AbstractTextSearchViewPage
implements ISearchResultListener {
    private ModelEditorOpenEnum openEditorMode;
    private String fId;
    private AbstractModelSearchPageActionGroup modelSearchActionGroup;
    private IModelSearchResult modelSearchResult;
    private ComposedAdapterFactory adapterFactory;
    private ModelSearchResultItemProvider searchResultItemProvider;
    private DecoratingModelSearchResultLabelProvider searchResultLabelProvider;
    private List<AdapterFactory> composeableAdapterFactories;
    private List<IModelElementEditorSelectionHandler> modelElementEditorSelectionHandlerList;
    private Map<String, String> menuManagerTargetMetaModelIDMap;
    private Map<String, MenuManager> menuManagerMap;
    private Map<String, MenuManager> contributedActionIDToMenuMapping;
    private ToggleOpenButtonAction toggleOpenEditorButtonAction;
    private OpenInDiagramEditorAction openInDiagramEditorAction;
    private OpenInLegacyEditorAction openInLegacyEditorAction;
    private ActionContributionExtensionManager actionContributionExtensionManager;
    private MenuContributionExtensionManager menuContributionExtensionManager;
    private static final String MODEL_RESULT_PAGE_ID = "modelResultPageID";
    private static final String OPEN_DIAGRAM_TOGGLE_SELECTION_ID = "openDiagramToggleSelectionID";
    private IDialogSettings settings = Activator.getDefault().getDialogSettings();
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;
    public static Object MODEL_SEARCH_FAMILY = new Object();

    public ModelSearchResultPage() {
        super(2);
        ModelSearchParticipantTabExtensionManager modelExtensibleSearchParticipantTabExtensionManager = ModelSearchParticipantTabExtensionManager.getInstance();
        ParticipantTabDescriptor[] participantTabDescriptors = modelExtensibleSearchParticipantTabExtensionManager.getModelSearchParticipantDescriptors();
        this.composeableAdapterFactories = new ArrayList<AdapterFactory>();
        this.modelElementEditorSelectionHandlerList = new ArrayList<IModelElementEditorSelectionHandler>();
        ParticipantTabDescriptor[] participantTabDescriptorArray = participantTabDescriptors;
        int n = participantTabDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ParticipantTabDescriptor participantTabDescriptor = participantTabDescriptorArray[n2];
            this.composeableAdapterFactories.add(participantTabDescriptor.getElementComposeableAdapterFactory());
            this.modelElementEditorSelectionHandlerList.add(participantTabDescriptor.getModelElementEditorSelectionHandler());
            ++n2;
        }
        this.composeableAdapterFactories.add((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(this.composeableAdapterFactories);
        this.searchResultItemProvider = new ModelSearchResultItemProvider();
        this.searchResultLabelProvider = new DecoratingModelSearchResultLabelProvider((AdapterFactory)this.adapterFactory, this.modelSearchResult);
        this.actionContributionExtensionManager = ActionContributionExtensionManager.getInstance();
        this.menuContributionExtensionManager = MenuContributionExtensionManager.getInstance();
        this.menuManagerTargetMetaModelIDMap = new HashMap<String, String>();
        this.menuManagerMap = new HashMap<String, MenuManager>();
        this.contributedActionIDToMenuMapping = new HashMap<String, MenuManager>();
        this.setElementLimit(new Integer(1000));
        this.initResultPageActions();
        this.loadDialogSettings();
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.modelSearchActionGroup = new AbstractModelSearchPageActionGroup((IViewPart)part);
    }

    private void initResultPageActions() {
        this.toggleOpenEditorButtonAction = new ToggleOpenButtonAction(this);
        this.openInDiagramEditorAction = new OpenInDiagramEditorAction(this);
        this.openInLegacyEditorAction = new OpenInLegacyEditorAction(this);
    }

    private boolean hasAValidTargetMetaModeID(String nsURI) {
        if (this.modelSearchResult.getQuery() instanceof IModelSearchQuery) {
            return ((IModelSearchQuery)this.modelSearchResult.getQuery()).isValidTargetMetaModel(nsURI);
        }
        return false;
    }

    private Collection<String> getTargetMetaModelIDs() {
        if (this.modelSearchResult.getQuery() instanceof IModelSearchQuery) {
            return ((IModelSearchQuery)this.modelSearchResult.getQuery()).getTargetMetaModelIDs();
        }
        return new ArrayList<String>();
    }

    private void addResultPageActions(IMenuManager mgr) {
        MenuManager openMenu = new MenuManager(Messages.getString("ModelSearchResultPage.editorActionsMenu"));
        openMenu.add((IAction)this.openInLegacyEditorAction);
        openMenu.add((IAction)this.openInDiagramEditorAction);
        Object[] objectArray = this.menuContributionExtensionManager.getMenuContributions();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuContributionDescriptor desc = objectArray[n2];
            if (!this.menuManagerMap.containsKey(desc.getID())) {
                this.menuManagerMap.put(desc.getID(), new MenuManager(desc.label, desc.getImageDescriptor(), desc.getID()));
                this.menuManagerTargetMetaModelIDMap.put(desc.getID(), desc.getTargetMetaModelID());
            }
            ++n2;
        }
        objectArray = this.actionContributionExtensionManager.getActionContributions();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Action contributedAction;
            Object actionContributionDescriptor = objectArray[n2];
            if (this.hasAValidTargetMetaModeID(((ActionContributionDescriptor)actionContributionDescriptor).getTargetMetaModelID()) && ((ActionContributionDescriptor)actionContributionDescriptor).getAction() != null && (contributedAction = ((ActionContributionDescriptor)actionContributionDescriptor).getAction()) instanceof AbstractModelSearchPageAction) {
                AbstractModelSearchPageAction modelSearchPageAction = (AbstractModelSearchPageAction)contributedAction;
                modelSearchPageAction.setSearchPage(this);
                modelSearchPageAction.setEnabled(modelSearchPageAction.isEnabled());
                MenuManager menuManager = this.menuManagerMap.get(((ActionContributionDescriptor)actionContributionDescriptor).getTargetMenuID());
                if (menuManager != null && !this.contributedActionIDToMenuMapping.containsKey(((ActionContributionDescriptor)actionContributionDescriptor).getID())) {
                    this.contributedActionIDToMenuMapping.put(((ActionContributionDescriptor)actionContributionDescriptor).getID(), menuManager);
                    menuManager.add((IAction)contributedAction);
                }
            }
            ++n2;
        }
        for (String key : this.menuManagerMap.keySet()) {
            MenuManager menuManager = this.menuManagerMap.get(key);
            if (!this.getTargetMetaModelIDs().contains(this.menuManagerTargetMetaModelIDMap.get(key))) continue;
            mgr.appendToGroup("group.viewerSetup", (IContributionItem)menuManager);
        }
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)openMenu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addResultPageActions(mgr);
        this.modelSearchActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.modelSearchActionGroup.fillContextMenu(mgr);
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        this.addGroupActions(tbm);
    }

    private void addGroupActions(IToolBarManager mgr) {
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)new Separator("OpenEditorGroup"));
        mgr.appendToGroup("OpenEditorGroup", (IAction)this.toggleOpenEditorButtonAction);
        this.updateGroupingActions();
    }

    private void updateGroupingActions() {
        this.toggleOpenEditorButtonAction.setChecked(this.openEditorMode == ModelEditorOpenEnum.DIAGRAM);
    }

    public void init(IPageSite site) {
        super.init(site);
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.insertBefore("group.properties", (IContributionItem)new Separator("dummySeparatorGroup"));
        this.modelSearchActionGroup.fillActionBars(site.getActionBars());
        PlatformUI.getWorkbench().getProgressService().registerIconForFamily(ModelSearchImagesUtil.getImageDescriptor((Bundle)Activator.getDefault().getBundle(), (String)"icons/full/esearch.gif"), MODEL_SEARCH_FAMILY);
    }

    public void dispose() {
        this.modelSearchActionGroup.dispose();
        super.dispose();
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void handleOpen(OpenEvent event) {
        ISelection s = event.getSelection();
        if (s instanceof IStructuredSelection) {
            this.openEditor(((StructuredSelection)s).getFirstElement());
        }
    }

    public static IFile getFile(Resource resource) {
        if (resource instanceof Resource) {
            ResourceSet rset = resource.getResourceSet();
            return ModelSearchResultPage.getFile(resource.getURI(), rset != null ? rset.getURIConverter() : null);
        }
        return null;
    }

    private static IFile getFile(URI uri, URIConverter converter) {
        URI normalized;
        if ("platform".equals(uri.scheme()) && uri.segmentCount() > 2) {
            if ("resource".equals(uri.segment(0))) {
                IPath path = new Path(URI.decode((String)uri.path())).removeFirstSegments(1);
                return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            }
        } else if (uri.isFile() && !uri.isRelative()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
        }
        if (converter instanceof URIConverter && !uri.equals((Object)(normalized = converter.normalize(uri)))) {
            return ModelSearchResultPage.getFile(normalized, converter);
        }
        return null;
    }

    public IEditorPart openEditor(EObject eObject) throws PartInitException {
        URI uri;
        Resource resource;
        if (eObject != null && (resource = eObject.eResource()) != null && (uri = resource.getURI()) != null) {
            URIEditorInput editorInput = null;
            if (uri.isPlatformResource()) {
                String path = uri.toPlatformString(true);
                IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                if (workspaceResource instanceof IFile) {
                    editorInput = new FileEditorInput((IFile)workspaceResource);
                }
            } else {
                editorInput = new URIEditorInput(uri);
            }
            if (editorInput != null) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IEditorDescriptor desc = null;
                try {
                    URL url = new URL(uri.toString());
                    desc = EditUIUtil.getDefaultEditor((InputStream)FileLocator.resolve((URL)url).openStream(), (String)url.getFile());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (desc == null) {
                    desc = workbench.getEditorRegistry().getDefaultEditor(uri.lastSegment());
                }
                if (desc != null) {
                    IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                    IEditorPart editorPart = page.openEditor((IEditorInput)editorInput, desc.getId());
                    return editorPart;
                }
                return null;
            }
        }
        return null;
    }

    protected void showMatch(Match match, int currentOffset, int currentLength) throws PartInitException {
        this.showMatch(match, currentOffset, currentLength, true);
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        this.getViewer().setSelection((ISelection)new StructuredSelection((Object)match));
        this.getViewer().reveal((Object)match);
        if (activate && match instanceof IModelResultEntry) {
            this.openEditor(((IModelResultEntry)match).getSource());
        }
    }

    public void openEditor(final Object destination) {
        new UIJob("Open EMF Editor"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchPage page;
                IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (dw != null && (page = dw.getActivePage()) != null) {
                    if (destination instanceof AbstractModelSearchResultEntry) {
                        ModelSearchResultPage.this.handleEObjectToOpenEditorFrom((EObject)((AbstractModelSearchResultEntry)destination).getSource());
                    } else if (destination instanceof Resource && !((Resource)destination).getContents().isEmpty()) {
                        ModelSearchResultPage.this.handleEObjectToOpenEditorFrom((EObject)((Resource)destination).getContents().get(0));
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void handleEObjectToOpenEditorFrom(EObject eobject) {
        try {
            IEditorPart editorPart = this.openEditor(eobject);
            if (editorPart instanceof IEditingDomainProvider) {
                EditingDomain editingDomain = ((IEditingDomainProvider)editorPart).getEditingDomain();
                EObject object = editingDomain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)eobject), true);
                for (IModelElementEditorSelectionHandler modelElementEditorSelectionHandler : this.modelElementEditorSelectionHandlerList) {
                    if (!modelElementEditorSelectionHandler.isCompatibleModelElementEditorSelectionHandler(editorPart)) continue;
                    modelElementEditorSelectionHandler.handleModelSearchElementSelection(editorPart, object, this.getOpenEditorMode());
                }
            }
        }
        catch (PartInitException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.search.ui", 0, "Editor model element Selection failed !", (Throwable)e));
        }
    }

    public void setInput(ISearchResult search, Object viewState) {
        super.setInput(search, viewState);
        if (search instanceof ModelSearchResult) {
            search.addListener((ISearchResultListener)this);
            this.modelSearchResult = (ModelSearchResult)search;
            this.refreshResultPage(this.modelSearchResult);
        }
    }

    public void setID(String id) {
        this.fId = id;
    }

    public String getID() {
        return this.fId;
    }

    public String getLabel() {
        return this.modelSearchResult == null ? "" : this.modelSearchResult.getLabel();
    }

    public void searchResultChanged(SearchResultEvent e) {
        if (e instanceof ModelSearchResultEvent) {
            ModelSearchResultEvent ssre = (ModelSearchResultEvent)e;
            this.modelSearchResult = (IModelSearchResult)ssre.getSearchResult();
            this.refreshResultPage(this.modelSearchResult);
        }
    }

    private void refreshResultPage(Object modelSearchResult) {
        if (modelSearchResult instanceof ModelSearchResult && ((ModelSearchResult)modelSearchResult).getMatchCount() % 50 == 0) {
            new RefreshResultsUIJob(modelSearchResult).schedule();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)this.searchResultLabelProvider);
        viewer.setContentProvider((IContentProvider)this.searchResultItemProvider);
    }

    protected void elementsChanged(Object[] objects) {
    }

    public ModelEditorOpenEnum getOpenEditorMode() {
        return this.openEditorMode == null ? ModelEditorOpenEnum.TREE : this.openEditorMode;
    }

    public void setOpenEditorMode(ModelEditorOpenEnum openEditorMode) {
        this.openEditorMode = openEditorMode;
        this.storeDialogSettings();
    }

    private void storeDialogSettings() {
        IDialogSettings openDiagramDialogSettings = this.settings.getSection(MODEL_RESULT_PAGE_ID);
        if (openDiagramDialogSettings == null) {
            openDiagramDialogSettings = this.settings.addNewSection(MODEL_RESULT_PAGE_ID);
        }
        boolean openEditorButtonToggleMode = this.openEditorMode == ModelEditorOpenEnum.DIAGRAM;
        openDiagramDialogSettings.put(OPEN_DIAGRAM_TOGGLE_SELECTION_ID, openEditorButtonToggleMode);
    }

    private void loadDialogSettings() {
        boolean openEditorButtonToggleMode = false;
        IDialogSettings openDiagramDialogSettings = this.settings.getSection(MODEL_RESULT_PAGE_ID);
        if (openDiagramDialogSettings != null) {
            openEditorButtonToggleMode = openDiagramDialogSettings.getBoolean(OPEN_DIAGRAM_TOGGLE_SELECTION_ID);
        }
        this.toggleOpenEditorButtonAction.setChecked(openEditorButtonToggleMode);
    }

    protected void clear() {
        this.getViewer().setInput(null);
    }

    protected void configureTableViewer(TableViewer viewer) {
    }

    public ToggleOpenButtonAction getToggleOpenEditorButtonAction() {
        return this.toggleOpenEditorButtonAction;
    }

    public OpenInDiagramEditorAction getOpenInDiagramEditorAction() {
        return this.openInDiagramEditorAction;
    }

    public OpenInLegacyEditorAction getOpenInLegacyEditorAction() {
        return this.openInLegacyEditorAction;
    }

    private class RefreshResultsUIJob
    extends UIJob {
        Object input;

        public RefreshResultsUIJob(Object modelSearchResult) {
            super("Refresh Model Search Results");
            this.setPriority(10);
            this.input = modelSearchResult;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                Job.getJobManager().sleep(InternalSearchUI.FAMILY_SEARCH);
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (ModelSearchResultPage.this.getViewer().getControl().isDisposed()) {
                            return;
                        }
                        if (ModelSearchResultPage.this.getViewer().getContentProvider() == null) {
                            return;
                        }
                        DecoratingModelSearchResultLabelProvider labelProvider = (DecoratingModelSearchResultLabelProvider)ModelSearchResultPage.this.getViewer().getLabelProvider();
                        labelProvider.setModelSearchResult(ModelSearchResultPage.this.modelSearchResult);
                        ModelSearchResultPage.this.getViewer().refresh(true);
                    }
                });
                Job.getJobManager().wakeUp(InternalSearchUI.FAMILY_SEARCH);
            }
            catch (Exception exception) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return MODEL_SEARCH_FAMILY.equals(family);
        }
    }
}

