/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.henshin.editor.commands.QuantUtil;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;

public class CreateMappingCommand
extends CompoundCommand {
    protected EditingDomain domain;
    protected Node origin;
    protected Node image;
    protected Mapping mapping;
    protected Collection<?> affectedObjects;
    protected EObject owner;
    protected EStructuralFeature feature;

    public CreateMappingCommand(EditingDomain domain, Node source, Node target) {
        this.domain = domain;
        this.origin = source;
        this.image = target;
    }

    protected boolean prepare() {
        if (QuantUtil.anyNull(this.origin, this.image, this.origin.getGraph(), this.image.getGraph(), this.origin.getGraph().eContainer(), this.image.getGraph().eContainer()) || QuantUtil.allIdentical(this.origin.getGraph(), this.image.getGraph())) {
            return false;
        }
        if (this.isUnmappedLhsRhsPairFromSameRule(this.origin, this.image)) {
            this.feature = HenshinPackage.eINSTANCE.getRule_Mappings();
            this.owner = this.origin.getGraph().getRule();
        } else if (this.isMappableSourceAndNestedTargetNode(this.origin, this.image)) {
            this.feature = HenshinPackage.eINSTANCE.getNestedCondition_Mappings();
            this.owner = this.image.getGraph().eContainer();
        } else if (this.isMappableSourceAndMultiRuleTargetNode(this.origin, this.image)) {
            this.feature = HenshinPackage.eINSTANCE.getRule_MultiMappings();
            this.owner = this.image.getGraph().getRule();
        } else {
            return false;
        }
        this.mapping = HenshinFactory.eINSTANCE.createMapping(this.origin, this.image);
        this.affectedObjects = Collections.singleton(this.mapping);
        this.append(this.domain.createCommand(AddCommand.class, new CommandParameter((Object)this.owner, (Object)this.feature, Collections.singleton(this.mapping), -1)));
        return super.prepare();
    }

    private boolean isMappableSourceAndMultiRuleTargetNode(Node origin, Node image) {
        boolean result = false;
        result |= origin.getGraph().isLhs() && image.getGraph().isLhs();
        result |= origin.getGraph().isRhs() && image.getGraph().isRhs();
        return result &= origin.getGraph().getRule().getMultiRules().contains((Object)image.getGraph().getRule());
    }

    protected boolean isUnmappedLhsRhsPairFromSameRule(Node source, Node target) {
        return source.getGraph().isLhs() && target.getGraph().isRhs() && source.getGraph().getRule() == target.getGraph().getRule() && this.isUnmapped(source, target, (Collection<Mapping>)source.getGraph().getRule().getMappings());
    }

    protected boolean isUnmapped(Node sourceNode, Node targetNode, Collection<Mapping> mappings) {
        for (Mapping mapping : mappings) {
            if (mapping.getOrigin() != sourceNode && mapping.getImage() != targetNode) continue;
            return false;
        }
        return true;
    }

    private boolean isMappableSourceAndNestedTargetNode(Node sourceNode, Node targetNode) {
        if (targetNode.getGraph().eContainer() instanceof NestedCondition) {
            NestedCondition nc = (NestedCondition)targetNode.getGraph().eContainer();
            return this.isUnmapped(sourceNode, targetNode, (Collection<Mapping>)nc.getMappings());
        }
        return false;
    }
}

