/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class RadioGroup
extends Composite {
    private Map<Integer, Button> buttons = new HashMap<Integer, Button>();
    private EEFWidgetFactory widgetFactory;
    private SelectionListener selectionListener;

    public RadioGroup(Composite parent, EEFWidgetFactory widgetFactory, int numberOfColumns) {
        super(parent, 16);
        this.widgetFactory = widgetFactory;
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        if (numberOfColumns <= 0) {
            this.setLayout((Layout)new RowLayout(256));
        } else {
            this.setLayout((Layout)new GridLayout(numberOfColumns, true));
        }
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                RadioGroup.this.handleDispose(event);
            }
        });
    }

    private void handleDispose(Event event) {
        this.removeAll();
    }

    public void setItem(int index, String string) {
        this.add(string, index);
        Button button = this.buttons.get(index);
        button.setText(string);
    }

    public void add(String string, int index) {
        if (this.buttons.get(index) == null) {
            Button button = this.widgetFactory.createButton((Composite)this, string, 16);
            button.setBackground(this.getBackground());
            button.setForeground(this.getForeground());
            this.buttons.put(index, button);
            if (this.selectionListener != null) {
                button.addSelectionListener(this.selectionListener);
            }
        }
    }

    public int getItemCount() {
        return this.buttons.size();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListener = listener;
        for (Button button : this.buttons.values()) {
            Listener[] listeners = button.getListeners(13);
            if (Arrays.asList(listeners).contains(listener)) continue;
            button.addSelectionListener(this.selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        for (Button button : this.buttons.values()) {
            button.removeSelectionListener(listener);
        }
    }

    public int[] getSelectionIndex() {
        for (Map.Entry<Integer, Button> entry : this.buttons.entrySet()) {
            Button button = entry.getValue();
            if (!button.getSelection()) continue;
            return new int[]{entry.getKey()};
        }
        return new int[]{-1};
    }

    public void setItem(String[] items) {
        int i = 0;
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.setItem(i, item);
            ++i;
            ++n2;
        }
    }

    public void removeAll() {
        int size = this.buttons.size();
        int i = 0;
        while (i < size) {
            this.remove(i);
            ++i;
        }
    }

    public void remove(int index) {
        Button button = this.buttons.get(index);
        if (button != null && !button.isDisposed()) {
            button.dispose();
            this.buttons.remove(index);
        }
    }

    public void select(int index) {
        this.buttons.get(index).setSelection(true);
    }

    public void deselectAll() {
        for (Button button : this.buttons.values()) {
            button.setSelection(false);
        }
    }

    public void dispose() {
        for (Button button : this.buttons.values()) {
            button.dispose();
        }
        super.dispose();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Button button : this.buttons.values()) {
            button.setEnabled(enabled);
        }
    }
}

