/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.eef.EEFControlDescription;
import org.eclipse.eef.EEFGroupConditionalStyle;
import org.eclipse.eef.EEFGroupDescription;
import org.eclipse.eef.EEFGroupStyle;
import org.eclipse.eef.EEF_TITLE_BAR_STYLE;
import org.eclipse.eef.EEF_TOGGLE_STYLE;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFController;
import org.eclipse.eef.core.api.controllers.IEEFGroupController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFControlSwitch;
import org.eclipse.eef.ide.ui.internal.widgets.styles.EEFColor;
import org.eclipse.eef.ide.ui.internal.widgets.styles.EEFFont;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;

public class EEFGroupLifecycleManager
extends AbstractEEFLifecycleManager {
    private IVariableManager variableManager;
    private IInterpreter interpreter;
    private EditingContextAdapter contextAdapter;
    private EEFGroupDescription description;
    private List<IEEFLifecycleManager> lifecycleManagers = new ArrayList<IEEFLifecycleManager>();
    private IEEFGroupController controller;
    private Section section;

    public EEFGroupLifecycleManager(EEFGroupDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        this.description = description;
        this.variableManager = variableManager;
        this.interpreter = interpreter;
        this.contextAdapter = contextAdapter;
    }

    @Override
    public void createControl(Composite parent, IEEFFormContainer formContainer) {
        super.createControl(parent, formContainer);
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        Composite groupComposite = widgetFactory.createComposite(parent);
        groupComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 1, true, false);
        groupComposite.setLayoutData((Object)gridData);
        EEFGroupStyle styleDescription = this.description.getStyle();
        EList conditionalStyles = this.description.getConditionalStyles();
        if (conditionalStyles != null) {
            for (EEFGroupConditionalStyle eefGroupConditionalStyle : conditionalStyles) {
                String preconditionExpression = eefGroupConditionalStyle.getPreconditionExpression();
                Boolean preconditionValid = (Boolean)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(Boolean.class).evaluate(preconditionExpression);
                if (preconditionValid == null || !preconditionValid.booleanValue()) continue;
                styleDescription = eefGroupConditionalStyle.getStyle();
                break;
            }
        }
        int style = 322;
        if (styleDescription != null) {
            style = this.getBarStyle(styleDescription.getBarStyle()) | this.getToggleStyle(styleDescription.getToggleStyle());
            boolean isExpandedByDefault = styleDescription.isExpandedByDefault();
            if (isExpandedByDefault) {
                style |= 0x40;
            }
        }
        this.section = widgetFactory.createSection(groupComposite, style);
        this.section.setText("");
        String labelExpression = this.description.getLabelExpression();
        EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(String.class).call(labelExpression, (IConsumer)new IConsumer<String>(){

            public void apply(String value) {
                EEFGroupLifecycleManager.this.section.setText((String)Objects.firstNonNull((Object)value, (Object)""));
            }
        });
        this.section.setLayout((Layout)new GridLayout(1, false));
        GridData sectionLayoutData = new GridData(4, 1, true, false);
        this.section.setLayoutData((Object)sectionLayoutData);
        Composite group = widgetFactory.createComposite((Composite)this.section);
        GridData groupLayoutData = new GridData(4, 1, true, false);
        group.setLayoutData((Object)groupLayoutData);
        GridLayout groupLayout = new GridLayout(3, false);
        group.setLayout((Layout)groupLayout);
        if (styleDescription != null) {
            String foregroundValue;
            String backgroundValue = (String)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(String.class).evaluate(styleDescription.getBackgroundColorExpression());
            if (backgroundValue != null) {
                Color backgroundColor = new EEFColor(backgroundValue).getColor();
                this.section.setBackground(backgroundColor);
                group.setBackground(backgroundColor);
            }
            if ((foregroundValue = (String)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(String.class).evaluate(styleDescription.getForegroundColorExpression())) != null) {
                Color foregroundColor = new EEFColor(foregroundValue).getColor();
                groupComposite.setForeground(foregroundColor);
                this.section.setTitleBarForeground(foregroundColor);
                this.section.setToggleColor(foregroundColor);
                this.section.setForeground(foregroundColor);
                group.setForeground(foregroundColor);
            }
            String fontName = (String)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(String.class).evaluate(styleDescription.getFontNameExpression());
            Integer fontSize = (Integer)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(Integer.class).evaluate(styleDescription.getFontSizeExpression());
            if (fontSize == null) {
                fontSize = 0;
            }
            Font font = new EEFFont(fontName, fontSize, 1).getFont();
            this.section.setFont(font);
            group.setFont(font);
        }
        this.section.setClient((Control)group);
        this.controller = new EEFControllersFactory().createGroupController(this.description, this.variableManager, this.interpreter, this.contextAdapter);
        EEFControlSwitch eefControlSwitch = new EEFControlSwitch(this.interpreter, this.contextAdapter);
        EList controls = this.description.getControls();
        for (EEFControlDescription eefControlDescription : controls) {
            this.lifecycleManagers.addAll(eefControlSwitch.doCreate(group, formContainer, eefControlDescription, this.variableManager));
        }
    }

    private int getBarStyle(EEF_TITLE_BAR_STYLE barStyleEnum) {
        int barStyle = 0;
        switch (barStyleEnum) {
            case SHORT_TITLE_BAR: {
                barStyle = 512;
                break;
            }
            case NO_TITLE: {
                barStyle = 4096;
                break;
            }
            default: {
                barStyle = 256;
            }
        }
        return barStyle;
    }

    private int getToggleStyle(EEF_TOGGLE_STYLE toggleStyleEnum) {
        int toggleStyle = 2;
        switch (toggleStyleEnum) {
            case TREE_NODE: {
                toggleStyle = 4;
                break;
            }
            case NONE: {
                toggleStyle = 0;
                break;
            }
            default: {
                toggleStyle = 2;
            }
        }
        return toggleStyle;
    }

    @Override
    protected IEEFController getController() {
        return this.controller;
    }

    @Override
    protected Control getValidationControl() {
        return this.section;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.controller.onNewLabel((IConsumer)new IConsumer<String>(){

            public void apply(String value) {
                EEFGroupLifecycleManager.this.section.setText(value);
            }
        });
        for (IEEFLifecycleManager lifecycleManager : this.lifecycleManagers) {
            lifecycleManager.aboutToBeShown();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        for (IEEFLifecycleManager lifecycleManager : this.lifecycleManagers) {
            lifecycleManager.refresh();
        }
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        this.controller.removeNewLabelConsumer();
        for (IEEFLifecycleManager lifecycleManager : this.lifecycleManagers) {
            lifecycleManager.aboutToBeHidden();
        }
    }

    @Override
    public void dispose() {
        for (IEEFLifecycleManager lifecycleManager : this.lifecycleManagers) {
            lifecycleManager.dispose();
        }
    }
}

