/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassProxy;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOModelElement;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IStoreWriter;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.db.IClassMapping;
import org.eclipse.emf.cdo.server.db.IDBStoreWriter;
import org.eclipse.emf.cdo.server.db.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.ClassServerInfo;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStoreReader;
import org.eclipse.emf.cdo.server.internal.db.FeatureServerInfo;
import org.eclipse.emf.cdo.server.internal.db.PackageServerInfo;
import org.eclipse.emf.cdo.server.internal.db.ServerInfo;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.common.InternalCDOClass;
import org.eclipse.emf.cdo.spi.common.InternalCDOFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class DBStoreWriter
extends DBStoreReader
implements IDBStoreWriter {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DBStoreWriter.class);

    public DBStoreWriter(DBStore store, IView view) throws DBException {
        super(store, view);
    }

    public void commit(IStoreWriter.CommitContext context) {
        super.commit(context);
        try {
            this.getConnection().commit();
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    public void rollback(IStoreWriter.CommitContext context) {
        super.rollback(context);
        try {
            this.getConnection().rollback();
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected void writePackages(CDOPackage ... cdoPackages) {
        super.writePackages(cdoPackages);
        Set<IDBTable> affectedTables = this.mapPackages(cdoPackages);
        this.getStore().getDBAdapter().createTables(affectedTables, this.getConnection());
    }

    protected void writePackage(CDOPackage cdoPackage) {
        int id = this.getStore().getNextPackageID();
        PackageServerInfo.setDBID(cdoPackage, id);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing package: {0} --> {1}", new Object[]{cdoPackage, id});
        }
        String packageURI = cdoPackage.getPackageURI();
        String name = cdoPackage.getName();
        String ecore = cdoPackage.getEcore();
        boolean dynamic = cdoPackage.isDynamic();
        CDOIDMetaRange metaIDRange = cdoPackage.getMetaIDRange();
        long lowerBound = metaIDRange == null ? 0L : ((CDOIDMeta)metaIDRange.getLowerBound()).getLongValue();
        long upperBound = metaIDRange == null ? 0L : ((CDOIDMeta)metaIDRange.getUpperBound()).getLongValue();
        String parentURI = cdoPackage.getParentURI();
        String sql = "INSERT INTO " + CDODBSchema.PACKAGES + " VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        DBUtil.trace((String)sql);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = this.getConnection().prepareStatement(sql);
                pstmt.setInt(1, id);
                pstmt.setString(2, packageURI);
                pstmt.setString(3, name);
                pstmt.setString(4, ecore);
                pstmt.setBoolean(5, dynamic);
                pstmt.setLong(6, lowerBound);
                pstmt.setLong(7, upperBound);
                pstmt.setString(8, parentURI);
                if (pstmt.execute()) {
                    throw new DBException("No result set expected");
                }
                if (pstmt.getUpdateCount() == 0) {
                    throw new DBException("No row inserted into table " + CDODBSchema.PACKAGES);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(pstmt);
            throw throwable;
        }
        DBUtil.close((Statement)pstmt);
        super.writePackage(cdoPackage);
    }

    protected void writeClass(InternalCDOClass cdoClass) {
        int id = this.getStore().getNextClassID();
        ClassServerInfo.setDBID((CDOClass)cdoClass, id);
        CDOPackage cdoPackage = cdoClass.getContainingPackage();
        int packageID = ServerInfo.getDBID((CDOModelElement)cdoPackage);
        int classifierID = cdoClass.getClassifierID();
        String name = cdoClass.getName();
        boolean isAbstract = cdoClass.isAbstract();
        DBUtil.insertRow((Connection)this.getConnection(), (IDBAdapter)this.getStore().getDBAdapter(), (IDBTable)CDODBSchema.CLASSES, (Object[])new Object[]{id, packageID, classifierID, name, isAbstract});
        super.writeClass(cdoClass);
    }

    protected void writeSuperType(InternalCDOClass type, CDOClassProxy superType) {
        int id = ClassServerInfo.getDBID((CDOModelElement)type);
        String packageURI = superType.getPackageURI();
        int classifierID = superType.getClassifierID();
        DBUtil.insertRow((Connection)this.getConnection(), (IDBAdapter)this.getStore().getDBAdapter(), (IDBTable)CDODBSchema.SUPERTYPES, (Object[])new Object[]{id, packageURI, classifierID});
    }

    protected void writeFeature(CDOFeature feature) {
        int id = this.getStore().getNextFeatureID();
        FeatureServerInfo.setDBID(feature, id);
        int classID = ServerInfo.getDBID((CDOModelElement)feature.getContainingClass());
        String name = feature.getName();
        int featureID = feature.getFeatureID();
        int type = feature.getType().getTypeID();
        CDOClassProxy reference = ((InternalCDOFeature)feature).getReferenceTypeProxy();
        String packageURI = reference == null ? null : reference.getPackageURI();
        int classifierID = reference == null ? 0 : reference.getClassifierID();
        boolean many = feature.isMany();
        boolean containment = feature.isContainment();
        int idx = feature.getFeatureIndex();
        DBUtil.insertRow((Connection)this.getConnection(), (IDBAdapter)this.getStore().getDBAdapter(), (IDBTable)CDODBSchema.FEATURES, (Object[])new Object[]{id, classID, featureID, name, type, packageURI, classifierID, many, containment, idx});
    }

    protected void writeRevision(CDORevision revision) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing revision: {0}", new Object[]{revision});
        }
        CDOClass cdoClass = revision.getCDOClass();
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        IClassMapping mapping = mappingStrategy.getClassMapping(cdoClass);
        mapping.writeRevision(this, revision);
    }
}

