/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.protocol.CDOProtocol;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.server.IPermissionManager;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerIndicationWithMonitoring;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.ExtendedIOUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class CommitTransactionIndication
extends CDOServerIndicationWithMonitoring {
    protected InternalCommitContext commitContext;

    public CommitTransactionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)11);
    }

    protected CommitTransactionIndication(CDOServerProtocol protocol, short signalID) {
        super(protocol, signalID);
    }

    @Override
    protected InternalCDOPackageRegistry getPackageRegistry() {
        return this.commitContext.getPackageRegistry();
    }

    protected void initializeCommitContext(CDODataInput in) throws Exception {
        int viewID = in.readXInt();
        this.commitContext = this.getTransaction(viewID).createCommitContext();
    }

    @Override
    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        try {
            try {
                monitor.begin(10.0);
                this.indicatingRead(in, monitor.fork(1.0));
                this.indicatingCommit(in, monitor.fork(9.0));
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void indicatingRead(CDODataInput in, OMMonitor monitor) throws Exception {
        this.initializeCommitContext(in);
        this.commitContext.preWrite();
        long lastUpdateTime = in.readXLong();
        int commitNumber = in.readXInt();
        String commitComment = in.readString();
        Map commitProperties = ExtendedIOUtil.readProperties((DataInput)in);
        CDOBranchPoint commitMergeSource = CDOBranchUtil.readBranchPointOrNull((CDODataInput)in);
        long optimisticLockingTimeout = in.readXLong();
        CDOLockState[] locksOnNewObjects = new CDOLockState[in.readXInt()];
        CDOID[] idsToUnlock = new CDOID[in.readXInt()];
        InternalCDOPackageUnit[] newPackageUnits = new InternalCDOPackageUnit[in.readXInt()];
        InternalCDORevision[] newObjects = new InternalCDORevision[in.readXInt()];
        InternalCDORevisionDelta[] dirtyObjectDeltas = new InternalCDORevisionDelta[in.readXInt()];
        CDOID[] detachedObjects = new CDOID[in.readXInt()];
        monitor.begin((double)(locksOnNewObjects.length + idsToUnlock.length + newPackageUnits.length + newObjects.length + dirtyObjectDeltas.length + detachedObjects.length));
        try {
            int i;
            int i2 = 0;
            while (i2 < locksOnNewObjects.length) {
                locksOnNewObjects[i2] = in.readCDOLockState();
                monitor.worked();
                ++i2;
            }
            i2 = 0;
            while (i2 < idsToUnlock.length) {
                idsToUnlock[i2] = in.readCDOID();
                monitor.worked();
                ++i2;
            }
            if (newPackageUnits.length != 0) {
                InternalCDOPackageRegistry packageRegistry = this.commitContext.getPackageRegistry();
                ResourceSet resourceSet = this.createResourceSet(packageRegistry);
                i = 0;
                while (i < newPackageUnits.length) {
                    newPackageUnits[i] = (InternalCDOPackageUnit)in.readCDOPackageUnit(resourceSet);
                    packageRegistry.putPackageUnit(newPackageUnits[i]);
                    monitor.worked();
                    ++i;
                }
                EMFUtil.safeResolveAll((ResourceSet)resourceSet);
            }
            boolean usingEcore = false;
            boolean usingEtypes = false;
            i = 0;
            while (i < newObjects.length) {
                newObjects[i] = (InternalCDORevision)in.readCDORevision();
                EPackage ePackage = newObjects[i].getEClass().getEPackage();
                if (ePackage == EcorePackage.eINSTANCE) {
                    usingEcore = true;
                } else if (ePackage == EtypesPackage.eINSTANCE) {
                    usingEtypes = true;
                }
                monitor.worked();
                ++i;
            }
            Arrays.sort(newObjects, new Comparator<InternalCDORevision>(){

                @Override
                public int compare(InternalCDORevision r1, InternalCDORevision r2) {
                    return r1.getID().compareTo((Object)r2.getID());
                }
            });
            i = 0;
            while (i < dirtyObjectDeltas.length) {
                dirtyObjectDeltas[i] = (InternalCDORevisionDelta)in.readCDORevisionDelta();
                monitor.worked();
                ++i;
            }
            boolean clearResourcePathCache = in.readBoolean();
            boolean auditing = this.getRepository().isSupportingAudits();
            boolean ensuringReferentialIntegrity = this.getRepository().isEnsuringReferentialIntegrity();
            Map detachedObjectTypes = null;
            if (auditing || ensuringReferentialIntegrity) {
                detachedObjectTypes = CDOIDUtil.createMap();
            }
            CDOBranchVersion[] detachedObjectVersions = null;
            if (auditing && detachedObjects.length != 0) {
                detachedObjectVersions = new CDOBranchVersion[detachedObjects.length];
            }
            CDOBranch transactionBranch = this.commitContext.getBranchPoint().getBranch();
            int i3 = 0;
            while (i3 < detachedObjects.length) {
                CDOID id;
                detachedObjects[i3] = id = in.readCDOID();
                if (detachedObjectTypes != null) {
                    EClass eClass = (EClass)in.readCDOClassifierRefAndResolve();
                    detachedObjectTypes.put(id, eClass);
                }
                if (detachedObjectVersions != null) {
                    CDOBranch branch;
                    int version = in.readXInt();
                    if (version < 0) {
                        version = -version;
                        branch = in.readCDOBranch();
                    } else {
                        branch = transactionBranch;
                    }
                    detachedObjectVersions[i3] = branch.getVersion(version);
                }
                monitor.worked();
                ++i3;
            }
            if (detachedObjectTypes != null && detachedObjectTypes.isEmpty()) {
                detachedObjectTypes = null;
            }
            this.commitContext.setCommitNumber(commitNumber);
            this.commitContext.setLastUpdateTime(lastUpdateTime);
            this.commitContext.setOptimisticLockingTimeout(optimisticLockingTimeout);
            this.commitContext.setClearResourcePathCache(clearResourcePathCache);
            this.commitContext.setUsingEcore(usingEcore);
            this.commitContext.setUsingEtypes(usingEtypes);
            this.commitContext.setNewPackageUnits(newPackageUnits);
            this.commitContext.setLocksOnNewObjects(locksOnNewObjects);
            this.commitContext.setNewObjects(newObjects);
            this.commitContext.setDirtyObjectDeltas(dirtyObjectDeltas);
            this.commitContext.setDetachedObjects(detachedObjects);
            this.commitContext.setDetachedObjectTypes(detachedObjectTypes);
            this.commitContext.setDetachedObjectVersions(detachedObjectVersions);
            this.commitContext.setCommitComment(commitComment);
            this.commitContext.setCommitProperties(commitProperties);
            this.commitContext.setCommitMergeSource(commitMergeSource);
            this.commitContext.setLobs(this.getIndicationStream());
            this.commitContext.setLocksOnNewObjects(locksOnNewObjects);
            this.commitContext.setIDsToUnlock(idsToUnlock);
        }
        finally {
            monitor.done();
        }
    }

    protected void indicatingCommit(CDODataInput in, OMMonitor monitor) {
        this.getRepository().commit(this.commitContext, monitor);
    }

    @Override
    protected void indicatingFailed() {
        if (this.commitContext != null) {
            this.commitContext.postCommit(false);
            this.commitContext = null;
        }
    }

    @Override
    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        boolean success = false;
        try {
            byte rollbackReason = this.commitContext.getRollbackReason();
            String rollbackMessage = this.commitContext.getRollbackMessage();
            List xRefs = this.commitContext.getXRefs();
            success = this.respondingException(out, rollbackReason, rollbackMessage, xRefs);
            if (success) {
                this.respondingResult(out);
                this.respondingMappingNewObjects(out);
                this.respondingLocks(out);
                this.respondingNewPermissions(out);
                this.respondingNewCommitData(out);
            }
        }
        finally {
            this.commitContext.postCommit(success);
        }
    }

    protected boolean respondingException(CDODataOutput out, byte rollbackReason, String rollbackMessage, List<CDOIDReference> xRefs) throws Exception {
        boolean success = rollbackMessage == null;
        out.writeBoolean(success);
        if (!success) {
            out.writeByte((int)rollbackReason);
            out.writeString(rollbackMessage);
            out.writeCDOBranchPoint(this.commitContext.getBranchPoint());
            out.writeXLong(this.commitContext.getPreviousTimeStamp());
            if (xRefs != null) {
                out.writeXInt(xRefs.size());
                for (CDOIDReference xRef : xRefs) {
                    out.writeCDOIDReference(xRef);
                }
            } else {
                out.writeXInt(0);
            }
        }
        return success;
    }

    protected void respondingResult(CDODataOutput out) throws Exception {
        out.writeCDOBranchPoint(this.commitContext.getBranchPoint());
        out.writeXLong(this.commitContext.getPreviousTimeStamp());
        out.writeByte((int)this.commitContext.getSecurityImpact());
    }

    protected void respondingMappingNewObjects(CDODataOutput out) throws Exception {
        Map idMappings = this.commitContext.getIDMappings();
        for (Map.Entry entry : idMappings.entrySet()) {
            CDOID oldID = (CDOID)entry.getKey();
            CDOID newID = (CDOID)entry.getValue();
            out.writeCDOID(oldID);
            out.writeCDOID(newID);
        }
        out.writeCDOID(CDOID.NULL);
    }

    protected void respondingLocks(CDODataOutput out) throws Exception {
        List lockDeltas = this.commitContext.getLockDeltas();
        out.writeCDOLockDeltas(lockDeltas, null);
        List lockStates = this.commitContext.getLockStates();
        out.writeCDOLockStates(lockStates, null);
    }

    protected void respondingNewPermissions(CDODataOutput out) throws Exception {
        InternalSession session = this.getSession();
        IPermissionManager permissionManager = session.getManager().getPermissionManager();
        if (permissionManager != null && this.commitContext.getSecurityImpact() != 2) {
            out.writeBoolean(true);
            InternalCDORevision[] newObjects = this.commitContext.getNewObjects();
            InternalCDORevision[] dirtyObjects = this.commitContext.getDirtyObjects();
            out.writeXInt(newObjects.length + dirtyObjects.length);
            this.respondingNewPermissions(out, permissionManager, session, newObjects);
            this.respondingNewPermissions(out, permissionManager, session, dirtyObjects);
            return;
        }
        out.writeBoolean(false);
    }

    protected void respondingNewPermissions(CDODataOutput out, IPermissionManager permissionManager, InternalSession session, InternalCDORevision[] revisions) throws Exception {
        int size = revisions.length;
        if (size != 0) {
            CDOBranchPoint securityContext = this.commitContext.getBranchPoint();
            if (!session.getManager().getRepository().isSupportingAudits()) {
                securityContext = securityContext.getBranch().getHead();
            }
            int i = 0;
            while (i < size) {
                InternalCDORevision revision = revisions[i];
                CDOPermission permission = permissionManager.getPermission((CDORevision)revision, securityContext, (ISession)session);
                out.writeCDOID(revision.getID());
                out.writeEnum((Enum)permission);
                ++i;
            }
        }
    }

    protected void respondingNewCommitData(CDODataOutput out) throws Exception {
        CDOProtocol.CommitData originalCommmitData = this.commitContext.getOriginalCommmitData();
        if (originalCommmitData != null) {
            out.writeBoolean(true);
            new CDOProtocol.CommitData(this.commitContext.getNewObjects(), this.commitContext.getDirtyObjectDeltas(), this.commitContext.getDetachedObjects()).write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    protected InternalTransaction getTransaction(int viewID) {
        InternalView view = this.getView(viewID);
        if (view instanceof InternalTransaction) {
            return (InternalTransaction)view;
        }
        throw new IllegalStateException("Illegal transaction: " + view);
    }

    private ResourceSet createResourceSet(InternalCDOPackageRegistry packageRegistry) {
        EcoreResourceFactoryImpl resourceFactory = new EcoreResourceFactoryImpl();
        EMFUtil.ExtResourceSet resourceSet = new EMFUtil.ExtResourceSet(true, false);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", resourceFactory);
        resourceSet.setPackageRegistry((EPackage.Registry)packageRegistry);
        return resourceSet;
    }
}

