/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.server.protocol;

import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.IBuddyProvider;
import org.eclipse.net4j.buddies.common.ICollaborationProvider;
import org.eclipse.net4j.buddies.common.IMembership;
import org.eclipse.net4j.buddies.internal.common.Buddy;
import org.eclipse.net4j.buddies.internal.common.Collaboration;
import org.eclipse.net4j.buddies.internal.common.protocol.CollaborationLeftIndication;
import org.eclipse.net4j.buddies.internal.common.protocol.CollaborationLeftNotification;
import org.eclipse.net4j.buddies.internal.server.BuddyAdmin;
import org.eclipse.net4j.buddies.internal.server.protocol.BuddiesServerProtocol;
import org.eclipse.net4j.buddies.server.IBuddyAdmin;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.WrappedException;

public class ServerCollaborationLeftIndication
extends CollaborationLeftIndication {
    public ServerCollaborationLeftIndication(BuddiesServerProtocol protocol) {
        super((SignalProtocol)protocol, (IBuddyProvider)IBuddyAdmin.INSTANCE, (ICollaborationProvider)IBuddyAdmin.INSTANCE);
    }

    protected void collaborationLeft(Buddy buddy, Collaboration collaboration) {
        IMembership[] iMembershipArray = collaboration.getMemberships();
        int n = iMembershipArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMembership membership = iMembershipArray[n2];
            IBuddy member = membership.getBuddy();
            if (member != buddy) {
                try {
                    BuddiesServerProtocol protocol = (BuddiesServerProtocol)buddy.getSession().getProtocol();
                    new CollaborationLeftNotification((SignalProtocol)protocol, collaboration.getID(), buddy.getUserID()).sendAsync();
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
            ++n2;
        }
        super.collaborationLeft(buddy, collaboration);
        if (collaboration.getBuddies().length == 0 && !collaboration.isPublic()) {
            BuddyAdmin.INSTANCE.removeCollaboration(collaboration.getID());
        }
    }
}

