/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SubCheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class SYSCHECKSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSCHECKS";
    private static final int SYSCHECKS_COLUMN_COUNT = 3;
    private static final int SYSCHECKS_CONSTRAINTID = 1;
    private static final int SYSCHECKS_CHECKDEFINITION = 2;
    private static final int SYSCHECKS_REFERENCEDCOLUMNS = 3;
    static final int SYSCHECKS_INDEX1_ID = 0;
    private static final boolean[] uniqueness = null;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final String[] uuids = new String[]{"80000056-00d0-fd77-3ed8-000a0a0b1900", "80000059-00d0-fd77-3ed8-000a0a0b1900", "80000058-00d0-fd77-3ed8-000a0a0b1900"};

    SYSCHECKSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(3, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        ReferencedColumns rcd = null;
        String checkDefinition = null;
        String constraintID = null;
        if (td != null) {
            CheckConstraintDescriptor cd = (CheckConstraintDescriptor)td;
            constraintID = cd.getUUID().toString();
            checkDefinition = cd.getConstraintText();
            rcd = cd.getReferencedColumnsDescriptor();
        }
        ExecIndexRow row = this.getExecutionFactory().getIndexableRow(3);
        row.setColumn(1, new SQLChar(constraintID));
        row.setColumn(2, this.dvf.getLongvarcharDataValue(checkDefinition));
        row.setColumn(3, new UserType(rcd));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        SubCheckConstraintDescriptor checkDesc = null;
        SanityManager.ASSERT(row.nColumns() == 3, "Wrong number of columns for a SYSCHECKS row");
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        DataValueDescriptor col = row.getColumn(1);
        String constraintUUIDString = col.getString();
        UUID constraintUUID = this.getUUIDFactory().recreateUUID(constraintUUIDString);
        col = row.getColumn(2);
        String constraintText = col.getString();
        col = row.getColumn(3);
        ReferencedColumns referencedColumns = (ReferencedColumns)col.getObject();
        checkDesc = new SubCheckConstraintDescriptor(constraintUUID, constraintText, referencedColumns);
        return checkDesc;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("CONSTRAINTID", false), SystemColumnImpl.getColumn("CHECKDEFINITION", -1, false), SystemColumnImpl.getJavaColumn("REFERENCEDCOLUMNS", "org.apache.derby.catalog.ReferencedColumns", false)};
    }
}

