/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.impl.services.locks.Control;

class LockTableVTI
implements Enumeration {
    private final Iterator outerControl;
    private Control control;
    private ListIterator grantedList;
    private ListIterator waitingList;
    private Latch nextLock;

    LockTableVTI(Map clonedLockTable) {
        this.outerControl = clonedLockTable.values().iterator();
    }

    @Override
    public boolean hasMoreElements() {
        if (this.nextLock != null) {
            return true;
        }
        while (true) {
            if (this.control == null) {
                List waiting;
                if (!this.outerControl.hasNext()) {
                    return false;
                }
                this.control = (Control)this.outerControl.next();
                List granted = this.control.getGranted();
                if (granted != null) {
                    this.grantedList = granted.listIterator();
                }
                if ((waiting = this.control.getWaiting()) != null) {
                    this.waitingList = waiting.listIterator();
                }
                this.nextLock = this.control.getFirstGrant();
                if (this.nextLock == null) {
                    this.nextLock = this.getNextLock(this.control);
                }
            } else {
                this.nextLock = this.getNextLock(this.control);
            }
            if (this.nextLock != null) {
                return true;
            }
            this.control = null;
        }
    }

    private Latch getNextLock(Control control) {
        Latch lock = null;
        if (this.grantedList != null) {
            if (this.grantedList.hasNext()) {
                lock = (Latch)this.grantedList.next();
            } else {
                this.grantedList = null;
            }
        }
        if (lock == null && this.waitingList != null) {
            if (this.waitingList.hasNext()) {
                lock = (Latch)this.waitingList.next();
            } else {
                this.waitingList = null;
            }
        }
        return lock;
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        Latch ret = this.nextLock;
        this.nextLock = null;
        return ret;
    }
}

