/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jms.util;

import java.io.IOException;
import javax.jms.MessageFormatException;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public final class TypeUtil {
    private TypeUtil() {
    }

    public static boolean getBoolean(Object value) throws MessageFormatException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        throw new MessageFormatException(TypeUtil.conversionProblem(Boolean.TYPE, value));
    }

    public static byte getByte(Object value) throws MessageFormatException {
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        throw new MessageFormatException(TypeUtil.conversionProblem(Byte.TYPE, value));
    }

    public static short getShort(Object value) throws MessageFormatException {
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        throw new MessageFormatException(TypeUtil.conversionProblem(Short.TYPE, value));
    }

    public static char getChar(Object value) throws MessageFormatException {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        throw new MessageFormatException(TypeUtil.conversionProblem(Character.TYPE, value));
    }

    public static int getInt(Object value) throws MessageFormatException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        throw new MessageFormatException(TypeUtil.conversionProblem(Integer.TYPE, value));
    }

    public static long getLong(Object value) throws MessageFormatException {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        throw new MessageFormatException(TypeUtil.conversionProblem(Long.TYPE, value));
    }

    public static float getFloat(Object value) throws MessageFormatException {
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        throw new MessageFormatException(TypeUtil.conversionProblem(Float.TYPE, value));
    }

    public static double getDouble(Object value) throws MessageFormatException {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        throw new MessageFormatException(TypeUtil.conversionProblem(Double.TYPE, value));
    }

    public static String getString(Object value) throws MessageFormatException {
        if (value instanceof byte[]) {
            throw new MessageFormatException(TypeUtil.conversionProblem(String.class, value));
        }
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        return String.valueOf(value);
    }

    public static byte[] getBytes(Object value) throws MessageFormatException {
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            byte[] result = new byte[bytes.length];
            System.arraycopy(bytes, 0, result, 0, bytes.length);
        } else if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        throw new MessageFormatException(TypeUtil.conversionProblem(byte[].class, value));
    }

    public static void write(ExtendedDataOutputStream out, Object value) throws IOException {
        if (value instanceof Boolean) {
            out.writeByte(1);
            out.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Byte) {
            out.writeByte(2);
            out.writeByte((int)((Byte)value).byteValue());
        } else if (value instanceof Character) {
            out.writeByte(3);
            out.writeChar((int)((Character)value).charValue());
        } else if (value instanceof Double) {
            out.writeByte(4);
            out.writeDouble(((Double)value).doubleValue());
        } else if (value instanceof Float) {
            out.writeByte(5);
            out.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Long) {
            out.writeByte(6);
            out.writeLong(((Long)value).longValue());
        } else if (value instanceof Short) {
            out.writeByte(7);
            out.writeShort((int)((Short)value).shortValue());
        } else if (value instanceof String) {
            out.writeByte(8);
            out.writeString((String)value);
        }
        throw new IllegalArgumentException("value: " + String.valueOf(value));
    }

    public static Object read(ExtendedDataInputStream in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 1: {
                return in.readBoolean();
            }
            case 2: {
                return in.readByte();
            }
            case 3: {
                return Character.valueOf(in.readChar());
            }
            case 4: {
                return in.readDouble();
            }
            case 5: {
                return Float.valueOf(in.readFloat());
            }
            case 6: {
                return in.readLong();
            }
            case 7: {
                return in.readShort();
            }
            case 8: {
                return in.readString();
            }
        }
        throw new IOException("Invalid type: " + type);
    }

    private static String conversionProblem(Class<?> type, Object value) {
        return "Cannot convert values of type " + value.getClass().getName() + " to " + type.getName();
    }
}

