/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.server.protocol;

import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.ICollaboration;
import org.eclipse.net4j.buddies.common.IFacility;
import org.eclipse.net4j.buddies.common.ISession;
import org.eclipse.net4j.buddies.internal.common.Collaboration;
import org.eclipse.net4j.buddies.internal.server.BuddyAdmin;
import org.eclipse.net4j.buddies.internal.server.bundle.OM;
import org.eclipse.net4j.buddies.internal.server.protocol.BuddiesServerProtocol;
import org.eclipse.net4j.buddies.internal.server.protocol.FacilityInstalledNotification;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class InstallFacilityIndication
extends IndicationWithResponse {
    private static final String FACILITY_GROUP = "org.eclipse.net4j.buddies.serverFacilities";
    private boolean success;

    public InstallFacilityIndication(BuddiesServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)11);
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        block6: {
            long collaborationID = in.readLong();
            String facilityType = in.readString();
            try {
                String description = String.valueOf(collaborationID);
                IFacility facility = (IFacility)IPluginContainer.INSTANCE.getElement(FACILITY_GROUP, facilityType, description);
                Collaboration collaboration = (Collaboration)BuddyAdmin.INSTANCE.getCollaboration(collaborationID);
                if (collaboration == null) break block6;
                facility.setCollaboration((ICollaboration)collaboration);
                collaboration.addFacility(facility, true);
                ISession session = (ISession)this.getProtocol().getInfraStructure();
                IBuddy initiator = session.getSelf();
                IBuddy[] iBuddyArray = collaboration.getBuddies();
                int n = iBuddyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuddy buddy = iBuddyArray[n2];
                    if (buddy != initiator) {
                        try {
                            BuddiesServerProtocol protocol = (BuddiesServerProtocol)buddy.getSession().getProtocol();
                            new FacilityInstalledNotification(protocol, collaborationID, facilityType).sendAsync();
                        }
                        catch (Exception ex) {
                            OM.LOG.error((Throwable)ex);
                        }
                    }
                    ++n2;
                }
                this.success = true;
            }
            catch (RuntimeException ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
    }

    protected void responding(ExtendedDataOutputStream out) throws Exception {
        out.writeBoolean(this.success);
    }
}

