/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.PrintWriter;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.net.CodePointNameTable;
import org.apache.derby.client.net.NetConnection;

public class NetLogWriter
extends LogWriter {
    static final int TYPE_TRACE_RECEIVE = 2;
    static final int TYPE_TRACE_SEND = 1;
    private static final char[] asciiChar__ = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    private static final String colPosHeader__ = "       0 1 2 3 4 5 6 7   8 9 A B C D E F   0123456789ABCDEF  0123456789ABCDEF";
    private static final char[] ebcdicChar__ = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '<', '(', '+', '|', '&', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '$', '*', ')', ';', '.', '-', '/', '.', '.', '.', '.', '.', '.', '.', '.', '|', ',', '%', '_', '>', '?', '.', '.', '.', '.', '.', '.', '.', '.', '.', '`', ':', '#', '@', '\'', '=', '\"', '.', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '.', '.', '.', '.', '.', '.', '.', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '.', '.', '.', '.', '.', '.', '.', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '.', '.', '.', '.', '.', '.', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '.', '.', '.', '.', '.', '.', '\\', '.', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '.', '.', '.', '.', '.', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', '.', '.', '.', '.', '.'};
    private static final char[] hexDigit__ = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String receiveHeader__ = "       RECEIVE BUFFER:                     (ASCII)           (EBCDIC)";
    private static final String sendHeader__ = "       SEND BUFFER:                        (ASCII)           (EBCDIC)";
    private static final char spaceChar__ = ' ';
    private static final char zeroChar__ = '0';
    private static CodePointNameTable codePointNameTable__ = null;

    public NetLogWriter(PrintWriter printWriter, int traceLevel) {
        super(printWriter, traceLevel);
        if (codePointNameTable__ == null) {
            this.initCodePointTable();
        }
    }

    private synchronized void initCodePointTable() {
        if (codePointNameTable__ == null) {
            codePointNameTable__ = new CodePointNameTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void traceConnectsExit(ClientConnection connection) {
        NetConnection c = (NetConnection)connection;
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            super.traceConnectsExit(c);
            this.dncnetprint("  PROTOCOL manager levels: { ");
            this.printWriter_.print("SQLAM=" + c.getSQLAM() + ", ");
            this.printWriter_.print("AGENT=" + c.getAGENT() + ", ");
            this.printWriter_.print("CMNTCPIP=" + c.getCMNTCPIP() + ", ");
            this.printWriter_.print("RDB=" + c.getRDB() + ", ");
            this.printWriter_.print("SECMGR=" + c.getSECMGR() + ", ");
            this.printWriter_.print("XAMGR=" + c.getXAMGR() + ", ");
            this.printWriter_.print("SYNCPTMGR=" + c.getSYNCPTMGR() + ", ");
            this.printWriter_.print("RSYNCMGR=" + c.getRSYNCMGR());
            this.printWriter_.println(" }");
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void traceConnectsResetExit(ClientConnection connection) {
        NetConnection c = (NetConnection)connection;
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            super.traceConnectsResetExit(c);
            this.dncnetprint("  PROTOCOL manager levels: { ");
            this.printWriter_.print("SQLAM=" + c.getSQLAM() + ", ");
            this.printWriter_.print("AGENT=" + c.getAGENT() + ", ");
            this.printWriter_.print("CMNTCPIP=" + c.getCMNTCPIP() + ", ");
            this.printWriter_.print("RDB=" + c.getRDB() + ", ");
            this.printWriter_.print("SECMGR=" + c.getSECMGR() + ", ");
            this.printWriter_.print("XAMGR=" + c.getXAMGR() + ", ");
            this.printWriter_.print("SYNCPTMGR=" + c.getSYNCPTMGR() + ", ");
            this.printWriter_.print("RSYNCMGR=" + c.getRSYNCMGR());
            this.printWriter_.println(" }");
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void traceProtocolFlow(byte[] buff, int offset, int len, int type, String className, String methodName, int tracepoint) {
        if (!this.loggingEnabled(64)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.tracepoint("[net]", tracepoint, className, methodName);
            int fullLen = len;
            boolean printColPos = true;
            while (fullLen >= 2) {
                int codePoint;
                len = ((buff[offset] & 0xFF) << 8) + (buff[offset + 1] & 0xFF);
                if (len < 10 || len > fullLen) {
                    len = fullLen;
                }
                fullLen -= len;
                if (len == 0) continue;
                String codePointName = null;
                if (len >= 10 && (codePointName = codePointNameTable__.lookup(codePoint = NetLogWriter.getCodePoint(buff, offset + 8))) == null) {
                    len += fullLen;
                    fullLen = 0;
                }
                if (!printColPos) {
                    this.dncnetprintln("");
                }
                if (codePointName == null) {
                    this.dncnetprintln(NetLogWriter.getHeader(type));
                } else {
                    this.printHeaderWithCodePointName(codePointName, type);
                }
                if (printColPos) {
                    this.dncnetprintln(colPosHeader__);
                    printColPos = false;
                }
                char[] trcDump = new char[77];
                int bCounter = 7;
                int aCounter = 43;
                int eCounter = 61;
                trcDump[0] = 48;
                trcDump[1] = 48;
                trcDump[2] = 48;
                trcDump[3] = 48;
                int lineCounter = 16;
                for (int j = 4; j < 77; ++j) {
                    trcDump[j] = 32;
                }
                int i = 0;
                do {
                    int num = buff[offset] < 0 ? buff[offset] + 256 : buff[offset];
                    ++offset;
                    ++i;
                    int n = bCounter;
                    bCounter = (short)(bCounter + 1);
                    trcDump[n] = hexDigit__[num >>> 4 & 0xF];
                    int n2 = bCounter;
                    bCounter = (short)(bCounter + 1);
                    trcDump[n2] = hexDigit__[num & 0xF];
                    int n3 = aCounter;
                    aCounter = (short)(aCounter + 1);
                    trcDump[n3] = asciiChar__[num];
                    int n4 = eCounter;
                    eCounter = (short)(eCounter + 1);
                    trcDump[n4] = ebcdicChar__[num];
                    if (i % 8 != 0) continue;
                    if (i % 16 == 0) {
                        this.dncnetprintln(trcDump);
                        if (i == len) continue;
                        if (len - i < 16) {
                            for (int j = 0; j < trcDump.length; ++j) {
                                trcDump[j] = 32;
                            }
                        }
                        bCounter = 0;
                        aCounter = 43;
                        eCounter = 61;
                        if (lineCounter == 0x100000) {
                            lineCounter = 0;
                        }
                        int n5 = bCounter;
                        bCounter = (short)(bCounter + 1);
                        trcDump[n5] = hexDigit__[lineCounter >>> 12 & 0xF];
                        int n6 = bCounter;
                        bCounter = (short)(bCounter + 1);
                        trcDump[n6] = hexDigit__[lineCounter >>> 8 & 0xF];
                        int n7 = bCounter;
                        bCounter = (short)(bCounter + 1);
                        trcDump[n7] = hexDigit__[lineCounter >>> 4 & 0xF];
                        int n8 = bCounter;
                        bCounter = (short)(bCounter + 1);
                        trcDump[n8] = hexDigit__[lineCounter & 0xF];
                        bCounter = (short)(bCounter + 3);
                        lineCounter += 16;
                        continue;
                    }
                    bCounter = (short)(bCounter + 2);
                } while (i < len);
                if (len % 16 == 0) continue;
                this.dncnetprintln(trcDump);
            }
            this.dncnetprintln("");
        }
    }

    private static int getCodePoint(byte[] buff, int offset) {
        return ((buff[offset++] & 0xFF) << 8) + (buff[offset] & 0xFF);
    }

    private static String getHeader(int type) {
        switch (type) {
            case 1: {
                return sendHeader__;
            }
            case 2: {
                return receiveHeader__;
            }
        }
        return null;
    }

    private static int getStartPosition(int type) {
        switch (type) {
            case 1: {
                return 20;
            }
            case 2: {
                return 23;
            }
        }
        return 0;
    }

    private void printHeaderWithCodePointName(String codePointName, int type) {
        char[] headerArray = NetLogWriter.getHeader(type).toCharArray();
        int replaceLen = codePointName.length() < 17 ? codePointName.length() : 16;
        int offset = NetLogWriter.getStartPosition(type);
        for (int i = 0; i < replaceLen; ++i) {
            headerArray[offset++] = codePointName.charAt(i);
        }
        this.dncnetprintln(headerArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncnetprint(String s) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby] " + s);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncnetprintln(String s) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.println("[derby] " + s);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncnetprintln(char[] s) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby] ");
            this.printWriter_.println(s);
            this.printWriter_.flush();
        }
    }
}

