/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui;

import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.CDOEditorInput2;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.ui.IPersistableElement;

public abstract class AbstractCDOEditorInput
extends PlatformObject
implements CDOEditorInput2 {
    private String resourcePath;
    private CDOID objectID;

    public AbstractCDOEditorInput(String resourcePath, CDOID objectID) {
        this.resourcePath = resourcePath;
        this.objectID = objectID;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public CDOID getObjectID() {
        return this.objectID;
    }

    @Override
    public void setObjectID(CDOID objectID) {
        this.objectID = objectID;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        CDOView view = this.getView();
        return CDOItemProvider.getViewImageDescriptor(view);
    }

    public String getName() {
        if (this.resourcePath != null) {
            return new Path(this.resourcePath).lastSegment();
        }
        return this.getView().getSession().getRepositoryInfo().getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        CDOView view = this.getView();
        String resourcePath = this.getResourcePath();
        return AbstractCDOEditorInput.formatToolTipText(view, resourcePath);
    }

    public int hashCode() {
        return ObjectUtil.hashCode((Object)this.getView()) ^ ObjectUtil.hashCode((Object)this.resourcePath) ^ ObjectUtil.hashCode((Object)this.objectID);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractCDOEditorInput) {
            AbstractCDOEditorInput that = (AbstractCDOEditorInput)obj;
            return ObjectUtil.equals((Object)this.getView(), (Object)that.getView()) && ObjectUtil.equals((Object)this.resourcePath, (Object)that.resourcePath) && ObjectUtil.equals((Object)this.objectID, (Object)that.objectID);
        }
        return false;
    }

    public static String formatToolTipText(CDOView view, String resourcePath) {
        long timeStamp;
        if (view == null) {
            return Messages.getString("CDOEditorInputImpl.1");
        }
        if (view.isClosed()) {
            return Messages.getString("CDOEditorInputImpl.0");
        }
        CDOSession session = view.getSession();
        String repositoryName = session.getRepositoryInfo().getName();
        int sessionID = session.getSessionID();
        int viewID = view.getViewID();
        StringBuilder builder = new StringBuilder();
        builder.append(repositoryName);
        if (resourcePath != null) {
            builder.append(resourcePath);
        }
        builder.append(" [");
        builder.append(sessionID);
        builder.append(":");
        builder.append(viewID);
        builder.append("]");
        if (view.isReadOnly()) {
            builder.append(" readonly");
        }
        if ((timeStamp = view.getTimeStamp()) != 0L) {
            builder.append(CDOCommonUtil.formatTimeStamp((long)timeStamp));
        }
        return builder.toString();
    }
}

