/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryLogicalOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class TestConstraintNode
extends UnaryLogicalOperatorNode {
    private final String sqlState;
    private final String tableName;
    private final UUID cid;
    private final boolean deferrable;
    private final String constraintName;

    TestConstraintNode(ValueNode booleanValue, String sqlState, String tableName, ConstraintDescriptor cd, ContextManager cm) throws StandardException {
        super(booleanValue, cd.deferrable() ? "throwExceptionIfImmediateAndFalse" : "throwExceptionIfFalse", cm);
        this.sqlState = sqlState;
        this.tableName = tableName;
        this.cid = cd.getUUID();
        this.deferrable = cd.deferrable();
        this.constraintName = cd.getConstraintName();
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregates);
        if (!this.operand.getTypeServices().getTypeId().isBooleanTypeId()) {
            this.operand = new CastNode(this.operand, new DataTypeDescriptor(TypeId.BOOLEAN_ID, true), this.getContextManager());
            ((CastNode)this.operand).bindCastNodeOnly();
        }
        this.setFullTypeInfo();
        return this;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.operand.generateExpression(acb, mb);
        mb.push(this.sqlState);
        mb.push(this.tableName);
        mb.push(this.constraintName);
        if (this.deferrable) {
            acb.pushThisAsActivation(mb);
            mb.push(acb.addItem(this.cid));
            mb.callMethod((short)185, "org.apache.derby.iapi.types.BooleanDataValue", "throwExceptionIfImmediateAndFalse", "org.apache.derby.iapi.types.BooleanDataValue", 5);
        } else {
            mb.callMethod((short)185, "org.apache.derby.iapi.types.BooleanDataValue", "throwExceptionIfFalse", "org.apache.derby.iapi.types.BooleanDataValue", 3);
        }
    }
}

