/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IBranchDeletionSupport;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping4;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractBasicListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.MappingNames;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.Batch;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.IDBSchemaTransaction;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class BranchingListTableMappingWithRanges
extends AbstractBasicListTableMapping
implements IListMappingDeltaSupport,
IListMapping4,
IBranchDeletionSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, BranchingListTableMappingWithRanges.class);
    private static final int FINAL_VERSION = Integer.MAX_VALUE;
    private IDBTable table;
    private IDBField sourceField;
    private IDBField branchField;
    private IDBField indexField;
    private IDBField versionAddedField;
    private IDBField versionRemovedField;
    private IDBField valueField;
    private ITypeMapping typeMapping;
    private String sqlSelectChunksPrefix;
    private String sqlOrderByIndex;
    private String sqlInsertEntry;
    private String sqlDeleteEntry;
    private String sqlRemoveEntry;
    private String sqlUpdateIndex;
    private String sqlGetValue;
    private String sqlClearList;

    public BranchingListTableMappingWithRanges(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        IDBStoreAccessor accessor = null;
        if (AbstractHorizontalMappingStrategy.isEagerTableCreation(mappingStrategy)) {
            accessor = (IDBStoreAccessor)StoreThreadLocal.getAccessor();
        }
        this.initTable(accessor);
    }

    private void initTable(IDBStoreAccessor accessor) {
        String tableName = this.getMappingStrategy().getTableName(this.getContainingClass(), this.getFeature());
        this.typeMapping = this.getMappingStrategy().createValueMapping(this.getFeature());
        IDBStore store = this.getMappingStrategy().getStore();
        DBType idType = store.getIDHandler().getDBType();
        int idLength = store.getIDColumnLength();
        IDBDatabase database = this.getMappingStrategy().getStore().getDatabase();
        this.table = database.getSchema().getTable(tableName);
        if (this.table == null) {
            if (accessor != null) {
                try (IDBSchemaTransaction schemaTransaction = accessor.openSchemaTransaction();){
                    IDBSchema workingCopy = schemaTransaction.getWorkingCopy();
                    IDBTable table = workingCopy.addTable(tableName);
                    this.sourceField = table.addField(MappingNames.LIST_REVISION_ID, idType, idLength, true);
                    this.branchField = table.addField(MappingNames.LIST_REVISION_BRANCH, DBType.INTEGER, true);
                    this.versionAddedField = table.addField(MappingNames.LIST_REVISION_VERSION_ADDED, DBType.INTEGER);
                    this.versionRemovedField = table.addField(MappingNames.LIST_REVISION_VERSION_REMOVED, DBType.INTEGER);
                    this.indexField = table.addField(MappingNames.LIST_IDX, DBType.INTEGER, true);
                    table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{this.sourceField, this.branchField, this.versionAddedField, this.versionRemovedField, this.indexField});
                    this.typeMapping.createDBField(table, MappingNames.LIST_VALUE);
                    schemaTransaction.commit();
                }
                this.initTable(null);
                accessor.tableCreated(this.table);
            }
        } else {
            this.sourceField = this.table.getField(MappingNames.LIST_REVISION_ID);
            this.branchField = this.table.getField(MappingNames.LIST_REVISION_BRANCH);
            this.versionAddedField = this.table.getField(MappingNames.LIST_REVISION_VERSION_ADDED);
            this.versionRemovedField = this.table.getField(MappingNames.LIST_REVISION_VERSION_REMOVED);
            this.indexField = this.table.getField(MappingNames.LIST_IDX);
            this.typeMapping.setDBField(this.table, MappingNames.LIST_VALUE);
            this.valueField = this.table.getField(MappingNames.LIST_VALUE);
            this.initSQLStrings();
        }
    }

    private void initSQLStrings() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.indexField);
        builder.append(", ");
        builder.append(this.valueField);
        builder.append(" FROM ");
        builder.append(this.table);
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.branchField);
        builder.append("=? AND ");
        builder.append(this.versionAddedField);
        builder.append("<=? AND (");
        builder.append(this.versionRemovedField);
        builder.append(" IS NULL OR ");
        builder.append(this.versionRemovedField);
        builder.append(">?)");
        this.sqlSelectChunksPrefix = builder.toString();
        this.sqlOrderByIndex = " ORDER BY " + this.indexField;
        builder = new StringBuilder("INSERT INTO ");
        builder.append(this.table);
        builder.append("(");
        builder.append(this.sourceField);
        builder.append(",");
        builder.append(this.branchField);
        builder.append(",");
        builder.append(this.versionAddedField);
        builder.append(",");
        builder.append(this.versionRemovedField);
        builder.append(",");
        builder.append(this.indexField);
        builder.append(",");
        builder.append(this.valueField);
        builder.append(") VALUES (?, ?, ?, ?, ?, ?)");
        this.sqlInsertEntry = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append(this.versionRemovedField);
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.branchField);
        builder.append("=? AND ");
        builder.append(this.indexField);
        builder.append("=? AND ");
        builder.append(this.versionRemovedField);
        builder.append(" IS NULL");
        this.sqlRemoveEntry = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.branchField);
        builder.append("=? AND ");
        builder.append(this.indexField);
        builder.append("=? AND ");
        builder.append(this.versionAddedField);
        builder.append("=?");
        this.sqlDeleteEntry = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append(this.indexField);
        builder.append("=? WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.branchField);
        builder.append("=? AND ");
        builder.append(this.versionAddedField);
        builder.append("=? AND ");
        builder.append(this.indexField);
        builder.append("=?");
        this.sqlUpdateIndex = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append(this.valueField);
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.branchField);
        builder.append("=? AND ");
        builder.append(this.indexField);
        builder.append("=? AND ");
        builder.append(this.versionRemovedField);
        builder.append(" IS NULL");
        this.sqlGetValue = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append(this.versionRemovedField);
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.branchField);
        builder.append("=? AND ");
        builder.append(this.versionRemovedField);
        builder.append(" IS NULL");
        this.sqlClearList = builder.toString();
    }

    @Override
    public Collection<IDBTable> getDBTables() {
        return Collections.singleton(this.table);
    }

    @Override
    protected final IDBField index() {
        return this.indexField;
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    protected final ITypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    @Override
    public void readValues(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        if (this.table == null) {
            return;
        }
        CDOList list = revision.getListOrNull(this.getFeature());
        if (list == null) {
            return;
        }
        int valuesToRead = list.size();
        if (listChunk != -1 && listChunk < valuesToRead) {
            valuesToRead = listChunk;
        }
        if (valuesToRead == 0) {
            return;
        }
        CDOID id = revision.getID();
        int branchID = revision.getBranch().getID();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision});
        }
        String sql = String.valueOf(this.sqlSelectChunksPrefix) + this.sqlOrderByIndex;
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBResultSet resultSet = null;
        ArrayList<Pair> toReadFromBase = null;
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, id);
                stmt.setInt(2, branchID);
                stmt.setInt(3, revision.getVersion());
                stmt.setInt(4, revision.getVersion());
                stmt.setMaxRows(valuesToRead);
                resultSet = stmt.executeQuery();
                int currentIndex = 0;
                while (valuesToRead > 0 && resultSet.next()) {
                    int index = resultSet.getInt(1);
                    if (index > currentIndex) {
                        if (toReadFromBase == null) {
                            toReadFromBase = new ArrayList();
                        }
                        toReadFromBase.add(Pair.create((Object)currentIndex, (Object)index));
                        if (TRACER.isEnabled()) {
                            TRACER.format("Scheduling range {0}-{1} to be read from base revision", new Object[]{currentIndex, index});
                        }
                        valuesToRead -= index - currentIndex;
                        currentIndex = index;
                    }
                    Iterator value = this.typeMapping.readValue((ResultSet)resultSet);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for index {0} from result set: {1}", new Object[]{currentIndex, value});
                    }
                    list.set(currentIndex++, value);
                    --valuesToRead;
                }
                if (valuesToRead > 0) {
                    if (toReadFromBase == null) {
                        toReadFromBase = new ArrayList<Pair>();
                    }
                    toReadFromBase.add(Pair.create((Object)currentIndex, (Object)(currentIndex + valuesToRead)));
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        if (toReadFromBase != null) {
            IStoreChunkReader baseReader = this.createBaseChunkReader(accessor, id, branchID);
            if (TRACER.isEnabled()) {
                TRACER.format("Reading base revision chunks for feature {0}.{1} of {2} from base revision {3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision, baseReader.getRevision()});
            }
            for (Pair range : toReadFromBase) {
                baseReader.addRangedChunk(((Integer)range.getElement1()).intValue(), ((Integer)range.getElement2()).intValue());
            }
            List baseChunks = baseReader.executeRead();
            for (IStoreChunkReader.Chunk chunk : baseChunks) {
                int startIndex = chunk.getStartIndex();
                int i = 0;
                while (i < chunk.size()) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Copying value {0} at chunk index {1}+{2} to index {3}", new Object[]{chunk.get(i), startIndex, i, startIndex + i});
                    }
                    list.set(startIndex + i, chunk.get(i));
                    ++i;
                }
            }
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {3} list values done for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision, list.size()});
        }
    }

    @Override
    public final void readChunks(IDBStoreChunkReader chunkReader, List<IStoreChunkReader.Chunk> chunks, String where) {
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), chunkReader.getRevision()});
        }
        CDORevision revision = chunkReader.getRevision();
        CDOID id = revision.getID();
        int branchID = revision.getBranch().getID();
        StringBuilder builder = new StringBuilder(this.sqlSelectChunksPrefix);
        if (where != null) {
            builder.append(" AND ");
            builder.append(where);
        }
        builder.append(this.sqlOrderByIndex);
        String sql = builder.toString();
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = chunkReader.getAccessor().getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        IStoreChunkReader baseReader = null;
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, id);
                stmt.setInt(2, branchID);
                stmt.setInt(3, revision.getVersion());
                stmt.setInt(4, revision.getVersion());
                if (TRACER.isEnabled()) {
                    TRACER.format("Readung Chunks: {0}", new Object[]{stmt});
                }
                resultSet = stmt.executeQuery();
                int nextDBIndex = Integer.MAX_VALUE;
                if (resultSet.next()) {
                    nextDBIndex = resultSet.getInt(1);
                }
                for (IStoreChunkReader.Chunk chunk : chunks) {
                    int startIndex = chunk.getStartIndex();
                    int missingValueStartIndex = -1;
                    int i = 0;
                    while (i < chunk.size()) {
                        int nextListIndex = startIndex + i;
                        if (nextDBIndex == nextListIndex) {
                            if (missingValueStartIndex != -1) {
                                if (baseReader == null) {
                                    baseReader = this.createBaseChunkReader(chunkReader.getAccessor(), id, branchID);
                                }
                                if (TRACER.isEnabled()) {
                                    TRACER.format("Scheduling range {0}-{1} to be read from base revision", new Object[]{missingValueStartIndex, nextListIndex});
                                }
                                baseReader.addRangedChunk(missingValueStartIndex, nextListIndex);
                                missingValueStartIndex = -1;
                            }
                            Object value = this.typeMapping.readValue((ResultSet)resultSet);
                            if (TRACER.isEnabled()) {
                                TRACER.format("ChunkReader read value for index {0} from result set: {1}", new Object[]{nextDBIndex, value});
                            }
                            chunk.add(i, value);
                            nextDBIndex = resultSet.next() ? resultSet.getInt(1) : Integer.MAX_VALUE;
                        } else if (missingValueStartIndex == -1) {
                            missingValueStartIndex = nextListIndex;
                        }
                        ++i;
                    }
                    if (missingValueStartIndex == -1) continue;
                    if (baseReader == null) {
                        baseReader = this.createBaseChunkReader(chunkReader.getAccessor(), id, branchID);
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format("Scheduling range {0}-{1} to be read from base revision", new Object[]{missingValueStartIndex, chunk.getStartIndex() + chunk.size()});
                    }
                    baseReader.addRangedChunk(missingValueStartIndex, chunk.getStartIndex() + chunk.size());
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        if (baseReader != null) {
            List baseChunks = baseReader.executeRead();
            Iterator<IStoreChunkReader.Chunk> thisIterator = chunks.iterator();
            IStoreChunkReader.Chunk thisChunk = thisIterator.next();
            for (IStoreChunkReader.Chunk baseChunk : baseChunks) {
                int baseStartIndex = baseChunk.getStartIndex();
                while (baseStartIndex > thisChunk.getStartIndex() + thisChunk.size()) {
                    thisChunk = thisIterator.next();
                }
                int offset = baseStartIndex - thisChunk.getStartIndex();
                int i = 0;
                while (i < baseChunk.size()) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Copying base chunk reader value {0} at index {1} to current chunk reader at index {2}.", new Object[]{baseChunk.get(i), baseChunk.getStartIndex() + i, thisChunk.getStartIndex() + i + offset});
                    }
                    thisChunk.add(i + offset, baseChunk.get(i));
                    ++i;
                }
            }
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values done for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision});
        }
    }

    @Override
    public void writeValues(IDBStoreAccessor accessor, CDORevision revision, boolean firstRevision, boolean raw) {
        if (firstRevision || !raw) {
            this.writeValues(accessor, (InternalCDORevision)revision);
        } else {
            EStructuralFeature feature;
            InternalCDORevisionManager revisionManager = (InternalCDORevisionManager)this.getMappingStrategy().getStore().getRepository().getRevisionManager();
            InternalCDORevision baseRevision = revisionManager.getBaseRevision(revision, -1, true);
            CDOListFeatureDelta delta = CDORevisionUtil.compareLists((CDORevision)baseRevision, (CDORevision)revision, (EStructuralFeature)(feature = this.getFeature()));
            if (delta != null && !delta.getListChanges().isEmpty()) {
                int branchID = revision.getBranch().getID();
                int oldVersion = baseRevision.getVersion();
                int newVersion = revision.getVersion();
                this.processDelta(accessor, baseRevision, branchID, oldVersion, newVersion, delta.getListChanges());
            }
        }
    }

    @Override
    public void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        CDOList values = revision.getListOrNull(this.getFeature());
        if (values != null && !values.isEmpty()) {
            if (this.table == null) {
                this.initTable(accessor);
            }
            int idx = 0;
            for (Object element : values) {
                this.writeValue(accessor, (CDORevision)revision, idx++, element);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Writing done", new Object[0]);
            }
        }
    }

    protected final void writeValue(IDBStoreAccessor accessor, CDORevision revision, int index, Object value) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing value for feature {0}.{1} index {2} of {3} : {4}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, revision, value});
        }
        this.addEntry(accessor, revision.getID(), revision.getBranch().getID(), revision.getVersion(), index, value);
    }

    @Override
    public void deleteBranches(IDBStoreAccessor accessor, Batch batch, String idList) {
        if (this.table == null) {
            return;
        }
        batch.add("DELETE FROM " + this.table + " WHERE " + this.branchField + " IN (" + idList + ")");
    }

    public void clearList(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, int lastIndex) {
        int i = 0;
        while (i <= lastIndex) {
            if (this.getValue(accessor, id, branchId, i, false) == null) {
                this.addHistoricEntry(accessor, id, branchId, 0, newVersion, i, this.getValueFromBase(accessor, id, branchId, i));
            }
            ++i;
        }
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlClearList, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                stmt.setInt(1, newVersion);
                this.getMappingStrategy().getStore().getIDHandler().setCDOID((PreparedStatement)stmt, 2, id);
                stmt.setInt(3, branchId);
                int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                if (TRACER.isEnabled()) {
                    TRACER.format("ClearList result: {0}", new Object[]{result});
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    public void objectDetached(IDBStoreAccessor accessor, CDOID id, long revised) {
        ITransaction transaction = accessor.getTransaction();
        InternalCDORevision revision = (InternalCDORevision)transaction.getRevision(id);
        if (revision == null) {
            return;
        }
        if (this.table == null) {
            this.initTable(accessor);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("objectDetached {1}", new Object[]{revision});
        }
        int branchID = transaction.getBranch().getID();
        int version = revision.getVersion();
        int lastIndex = revision.size(this.getFeature()) - 1;
        this.clearList(accessor, id, branchID, version, Integer.MAX_VALUE, lastIndex);
    }

    @Override
    public void rawDeleted(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, int version) {
        throw new UnsupportedOperationException("Raw deletion does not work in range-based mappings");
    }

    @Override
    public void processDelta(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, long created, CDOListFeatureDelta delta) {
        List listChanges = delta.getListChanges();
        if (listChanges.size() == 0) {
            return;
        }
        InternalCDORevision originalRevision = (InternalCDORevision)accessor.getTransaction().getRevision(id);
        this.processDelta(accessor, originalRevision, branchId, oldVersion, newVersion, listChanges);
    }

    private void processDelta(IDBStoreAccessor accessor, InternalCDORevision originalRevision, int branchId, int oldVersion, int newVersion, List<CDOFeatureDelta> listChanges) {
        if (TRACER.isEnabled()) {
            int oldListSize = originalRevision.size(this.getFeature());
            TRACER.format("ListTableMapping.processDelta for revision {0} - previous list size: {1}", new Object[]{originalRevision, oldListSize});
        }
        if (this.table == null) {
            this.initTable(accessor);
        }
        ListDeltaVisitor visitor = new ListDeltaVisitor(accessor, originalRevision, branchId, oldVersion, newVersion);
        if (TRACER.isEnabled()) {
            TRACER.format("Processing deltas...", new Object[0]);
        }
        int index = listChanges.size() - 1;
        while (index > 0) {
            CDOFeatureDelta listDelta = listChanges.get(index);
            if (listDelta instanceof CDOClearFeatureDelta || listDelta instanceof CDOUnsetFeatureDelta) break;
            --index;
        }
        while (index < listChanges.size()) {
            listChanges.get(index++).accept((CDOFeatureDeltaVisitor)visitor);
        }
        visitor.finishPendingRemove();
    }

    private void addEntry(IDBStoreAccessor accessor, CDOID id, int branchId, int version, int index, Object value) {
        if (TRACER.isEnabled()) {
            TRACER.format("Adding value for feature {0}.{1} index {2} of {3}:{4}v{5} : {6}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, branchId, version, value});
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsertEntry, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, branchId);
                stmt.setInt(column++, version);
                stmt.setNull(column++, DBType.INTEGER.getCode());
                stmt.setInt(column++, index);
                this.typeMapping.setValue((PreparedStatement)stmt, column++, value);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private void addHistoricEntry(IDBStoreAccessor accessor, CDOID id, int branchId, int versionAdded, int versionRemoved, int index, Object value) {
        if (TRACER.isEnabled()) {
            TRACER.format("Adding historic value for feature {0}.{1} index {2} of {3}:{4}v{5}-v{6} : {7}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, branchId, versionAdded, versionRemoved, value});
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsertEntry, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, branchId);
                stmt.setInt(column++, versionAdded);
                stmt.setInt(column++, versionRemoved);
                stmt.setInt(column++, index);
                this.typeMapping.setValue((PreparedStatement)stmt, column++, value);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private void removeEntry(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, int index) {
        if (TRACER.isEnabled()) {
            TRACER.format("Removing value for feature {0}.{1} index {2} of {3}:{4}v{5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, branchId, newVersion});
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlDeleteEntry, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, branchId);
                stmt.setInt(column++, index);
                stmt.setInt(column++, newVersion);
                int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                if (result == 1) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("removeEntry deleted: {0}", new Object[]{index});
                    }
                } else {
                    if (result > 1) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("removeEntry Too many results: {0}: {1}", new Object[]{index, result});
                        }
                        throw new DBException("Too many results");
                    }
                    DBUtil.close((Statement)stmt);
                    stmt = accessor.getDBConnection().prepareStatement(this.sqlRemoveEntry, IDBPreparedStatement.ReuseProbability.HIGH);
                    column = 1;
                    stmt.setInt(column++, newVersion);
                    idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                    stmt.setInt(column++, branchId);
                    stmt.setInt(column++, index);
                    result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                    if (result == 0) {
                        Object value = this.getValueFromBase(accessor, id, branchId, index);
                        this.addHistoricEntry(accessor, id, branchId, 0, newVersion, index, value);
                    }
                }
            }
            catch (SQLException e) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Removing value for feature {0}.{1} index {2} of {3}:{4}v{5} FAILED {6}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, branchId, newVersion, e.getMessage()});
                }
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Removing value for feature {0}.{1} index {2} of {3}:{4}v{5} FAILED {6}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, branchId, newVersion, e.getMessage()});
                }
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private Object getValue(IDBStoreAccessor accessor, CDOID id, int branchId, int index, boolean getFromBase) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlGetValue, IDBPreparedStatement.ReuseProbability.HIGH);
        Object result = null;
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, branchId);
                stmt.setInt(column++, index);
                IDBResultSet resultSet = stmt.executeQuery();
                if (resultSet.next()) {
                    result = this.typeMapping.readValue((ResultSet)resultSet);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value (index {0}) from result set: {1}", new Object[]{index, result});
                    }
                } else if (getFromBase) {
                    result = this.getValueFromBase(accessor, id, branchId, index);
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
        return result;
    }

    private Object getValueFromBase(IDBStoreAccessor accessor, CDOID id, int branchID, int index) {
        IStoreChunkReader chunkReader = this.createBaseChunkReader(accessor, id, branchID);
        chunkReader.addSimpleChunk(index);
        List chunks = chunkReader.executeRead();
        return ((IStoreChunkReader.Chunk)chunks.get(0)).get(0);
    }

    private IStoreChunkReader createBaseChunkReader(IDBStoreAccessor accessor, CDOID id, int branchID) {
        InternalRepository repository = (InternalRepository)accessor.getStore().getRepository();
        InternalCDOBranchManager branchManager = repository.getBranchManager();
        CDOBranch branch = branchManager.getBranch(branchID);
        CDOBranchPoint base = branch.getBase();
        if (base.getBranch() == null) {
            throw new IllegalArgumentException("Base branch is null: " + branch);
        }
        InternalCDORevisionManager revisionManager = repository.getRevisionManager();
        InternalCDORevision baseRevision = revisionManager.getRevision(id, base, 0, 0, true);
        return accessor.createChunkReader(baseRevision, this.getFeature());
    }

    @Override
    public final boolean queryXRefs(IDBStoreAccessor accessor, String mainTableName, String mainTableWhere, IStoreAccessor.QueryXRefsContext context, String idString) {
        if (this.table == null) {
            return true;
        }
        String listJoin = this.getMappingStrategy().getListJoin("a_t", "l_t");
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT l_t.");
        builder.append(this.sourceField);
        builder.append(", l_t.");
        builder.append(this.valueField);
        builder.append(", l_t.");
        builder.append(this.indexField);
        builder.append(" FROM ");
        builder.append(this.table);
        builder.append(" l_t, ");
        builder.append(mainTableName);
        builder.append(" a_t WHERE ");
        builder.append("a_t." + mainTableWhere);
        builder.append(listJoin);
        builder.append(" AND ");
        builder.append(this.valueField);
        builder.append(" IN ");
        builder.append(idString);
        String sql = builder.toString();
        if (TRACER.isEnabled()) {
            TRACER.format("Query XRefs (list): {0}", new Object[]{sql});
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBResultSet resultSet = null;
        try {
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                CDOID sourceID = idHandler.getCDOID((ResultSet)resultSet, 1);
                CDOID targetID = idHandler.getCDOID((ResultSet)resultSet, 2);
                int idx = resultSet.getInt(3);
                boolean more = context.addXRef(targetID, sourceID, (EReference)this.getFeature(), idx);
                if (TRACER.isEnabled()) {
                    TRACER.format("  add XRef to context: src={0}, tgt={1}, idx={2}", new Object[]{sourceID, targetID, idx});
                }
                if (more) continue;
                if (TRACER.isEnabled()) {
                    TRACER.format("  result limit reached. Ignoring further results.", new Object[0]);
                }
                return false;
            }
            return true;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    private class ListDeltaVisitor
    implements CDOFeatureDeltaVisitor {
        private IDBStoreAccessor accessor;
        private CDOID id;
        private int branchID;
        private int oldVersion;
        private int newVersion;
        private int lastIndex;
        private int lastRemovedIndex;

        public ListDeltaVisitor(IDBStoreAccessor accessor, InternalCDORevision originalRevision, int targetBranchID, int oldVersion, int newVersion) {
            this.accessor = accessor;
            this.id = originalRevision.getID();
            this.branchID = targetBranchID;
            this.oldVersion = oldVersion;
            this.newVersion = newVersion;
            this.lastIndex = originalRevision.size(BranchingListTableMappingWithRanges.this.getFeature()) - 1;
            this.lastRemovedIndex = -1;
        }

        public void visit(CDOAddFeatureDelta delta) {
            this.finishPendingRemove();
            int startIndex = delta.getIndex();
            int endIndex = this.lastIndex;
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Adding at: {0}", new Object[]{startIndex});
            }
            if (startIndex <= endIndex) {
                this.moveOneDown(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, startIndex, endIndex);
            }
            BranchingListTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.branchID, this.newVersion, startIndex, delta.getValue());
            ++this.lastIndex;
        }

        public void visit(CDORemoveFeatureDelta delta) {
            this.finishPendingRemove();
            this.lastRemovedIndex = delta.getIndex();
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Removing at: {0}", new Object[]{this.lastRemovedIndex});
            }
            BranchingListTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, this.lastRemovedIndex);
        }

        public void visit(CDOSetFeatureDelta delta) {
            this.finishPendingRemove();
            int index = delta.getIndex();
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Setting at: {0}", new Object[]{index});
            }
            BranchingListTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, index);
            BranchingListTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.branchID, this.newVersion, index, delta.getValue());
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Unsetting", new Object[0]);
            }
            BranchingListTableMappingWithRanges.this.clearList(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, this.lastIndex);
            this.lastIndex = -1;
            this.lastRemovedIndex = -1;
        }

        public void visit(CDOClearFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Clearing", new Object[0]);
            }
            BranchingListTableMappingWithRanges.this.clearList(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, this.lastIndex);
            this.lastIndex = -1;
            this.lastRemovedIndex = -1;
        }

        public void visit(CDOMoveFeatureDelta delta) {
            boolean optimizeMove;
            int fromIdx = delta.getOldPosition();
            int toIdx = delta.getNewPosition();
            boolean bl = optimizeMove = this.lastRemovedIndex != -1 && fromIdx == this.lastIndex - 1 && toIdx == this.lastRemovedIndex;
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Moving: {0} to {1}", new Object[]{fromIdx, toIdx});
            }
            if (optimizeMove) {
                ++fromIdx;
            } else {
                this.finishPendingRemove();
            }
            Object value = BranchingListTableMappingWithRanges.this.getValue(this.accessor, this.id, this.branchID, fromIdx, true);
            BranchingListTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, fromIdx);
            if (!optimizeMove) {
                if (fromIdx < toIdx) {
                    this.moveOneUp(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, fromIdx + 1, toIdx);
                } else {
                    this.moveOneDown(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, toIdx, fromIdx - 1);
                }
            } else {
                this.lastRemovedIndex = -1;
                --this.lastIndex;
            }
            BranchingListTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.branchID, this.newVersion, toIdx, value);
        }

        public void visit(CDOListFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOContainerFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void finishPendingRemove() {
            if (this.lastRemovedIndex != -1) {
                int startIndex = this.lastRemovedIndex;
                int endIndex = this.lastIndex--;
                this.moveOneUp(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, startIndex + 1, endIndex);
                this.lastRemovedIndex = -1;
            }
        }

        private void moveOneUp(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, int startIndex, int endIndex) {
            IIDHandler idHandler = BranchingListTableMappingWithRanges.this.getMappingStrategy().getStore().getIDHandler();
            IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(BranchingListTableMappingWithRanges.this.sqlUpdateIndex, IDBPreparedStatement.ReuseProbability.HIGH);
            try {
                try {
                    int index = startIndex;
                    while (index <= endIndex) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("moveOneUp moving: {0} -> {1}", new Object[]{index, index - 1});
                        }
                        int column = 1;
                        stmt.setInt(column++, index - 1);
                        idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                        stmt.setInt(column++, branchId);
                        stmt.setInt(column++, newVersion);
                        stmt.setInt(column++, index);
                        int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                        switch (result) {
                            case 1: {
                                if (!TRACER.isEnabled()) break;
                                TRACER.format("moveOneUp updated: {0} -> {1}", new Object[]{index, index - 1});
                                break;
                            }
                            case 0: {
                                Object value = BranchingListTableMappingWithRanges.this.getValue(accessor, id, branchId, index, false);
                                if (value != null) {
                                    if (TRACER.isEnabled()) {
                                        TRACER.format("moveOneUp remove: {0}", new Object[]{index});
                                    }
                                    BranchingListTableMappingWithRanges.this.removeEntry(accessor, id, branchId, oldVersion, newVersion, index);
                                } else {
                                    value = BranchingListTableMappingWithRanges.this.getValueFromBase(accessor, id, branchId, index);
                                    if (TRACER.isEnabled()) {
                                        TRACER.format("moveOneUp add historic entry at: {0}", new Object[]{index});
                                    }
                                    BranchingListTableMappingWithRanges.this.addHistoricEntry(accessor, id, branchId, 0, newVersion, index, value);
                                }
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp add: {0}", new Object[]{index - 1});
                                }
                                BranchingListTableMappingWithRanges.this.addEntry(accessor, id, branchId, newVersion, index - 1, value);
                                break;
                            }
                            default: {
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp Too many results: {0} -> {1}: {2}", new Object[]{index, index + 1, result});
                                }
                                throw new DBException("Too many results");
                            }
                        }
                        ++index;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
            }
        }

        private void moveOneDown(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, int startIndex, int endIndex) {
            IIDHandler idHandler = BranchingListTableMappingWithRanges.this.getMappingStrategy().getStore().getIDHandler();
            IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(BranchingListTableMappingWithRanges.this.sqlUpdateIndex, IDBPreparedStatement.ReuseProbability.HIGH);
            try {
                try {
                    int index = endIndex;
                    while (index >= startIndex) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("moveOneDown moving: {0} -> {1}", new Object[]{index, index + 1});
                        }
                        int column = 1;
                        stmt.setInt(column++, index + 1);
                        idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                        stmt.setInt(column++, branchId);
                        stmt.setInt(column++, newVersion);
                        stmt.setInt(column++, index);
                        int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                        switch (result) {
                            case 1: {
                                if (!TRACER.isEnabled()) break;
                                TRACER.format("moveOneDown updated: {0} -> {1}", new Object[]{index, index + 1});
                                break;
                            }
                            case 0: {
                                Object value = BranchingListTableMappingWithRanges.this.getValue(accessor, id, branchId, index, false);
                                if (value != null) {
                                    if (TRACER.isEnabled()) {
                                        TRACER.format("moveOneDown remove: {0}", new Object[]{index});
                                    }
                                    BranchingListTableMappingWithRanges.this.removeEntry(accessor, id, branchId, oldVersion, newVersion, index);
                                } else {
                                    value = BranchingListTableMappingWithRanges.this.getValueFromBase(accessor, id, branchId, index);
                                    if (TRACER.isEnabled()) {
                                        TRACER.format("moveOneDown add historic entry at: {0}", new Object[]{index});
                                    }
                                    BranchingListTableMappingWithRanges.this.addHistoricEntry(accessor, id, branchId, 0, newVersion, index, value);
                                }
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown add: {0}", new Object[]{index + 1});
                                }
                                BranchingListTableMappingWithRanges.this.addEntry(accessor, id, branchId, newVersion, index + 1, value);
                                break;
                            }
                            default: {
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown Too many results: {0} -> {1}: {2}", new Object[]{index, index + 1, result});
                                }
                                throw new DBException("Too many results");
                            }
                        }
                        --index;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
            }
        }
    }
}

