/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.BufferInputStream;
import org.eclipse.net4j.buffer.BufferOutputStream;
import org.eclipse.net4j.signal.MonitorCanceledRequest;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.RunnableWithName;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public abstract class RequestWithMonitoring<RESULT>
extends RequestWithConfirmation<RESULT> {
    private static final String MAIN_MONITOR_NAME = String.valueOf(RequestWithMonitoring.class.getSimpleName()) + "-MainMonitor";
    public static final long DEFAULT_CANCELATION_POLL_INTERVAL = 100L;
    public static final int DEFAULT_MONITOR_PROGRESS_SECONDS = 1;
    public static final int DEFAULT_MONITOR_TIMEOUT_SECONDS = 10;
    private volatile OMMonitor mainMonitor;
    private OMMonitor remoteMonitor;
    private Object monitorLock = new Object();
    private boolean isMonitoring;

    public RequestWithMonitoring(SignalProtocol<?> protocol, short id, String name) {
        super(protocol, id, name);
    }

    public RequestWithMonitoring(SignalProtocol<?> protocol, short signalID) {
        super(protocol, signalID);
    }

    public RequestWithMonitoring(SignalProtocol<?> protocol, Enum<?> literal) {
        super(protocol, literal);
    }

    @Override
    public Future<RESULT> sendAsync() {
        this.initMainMonitor(null);
        return super.sendAsync();
    }

    public Future<RESULT> sendAsync(OMMonitor monitor) {
        this.initMainMonitor(monitor);
        return super.sendAsync();
    }

    @Override
    public RESULT send() throws Exception, RemoteException {
        this.initMainMonitor(null);
        return super.send();
    }

    @Override
    public RESULT send(long timeout) throws Exception, RemoteException {
        this.initMainMonitor(null);
        return super.send(timeout);
    }

    public RESULT send(OMMonitor monitor) throws Exception, RemoteException {
        this.initMainMonitor(monitor);
        return super.send();
    }

    public RESULT send(long timeout, OMMonitor monitor) throws Exception, RemoteException {
        this.initMainMonitor(monitor);
        return super.send(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void requesting(ExtendedDataOutputStream out) throws Exception {
        double remoteWorkPercent = 100.0 - (double)this.getRequestingWorkPercent() - (double)this.getConfirmingWorkPercent();
        if (remoteWorkPercent < 0.0) {
            throw new ImplementationError("Remote work must not be negative: " + remoteWorkPercent);
        }
        this.mainMonitor.begin(100.0);
        OMMonitor subMonitor = this.mainMonitor.fork(remoteWorkPercent);
        Object object = this.monitorLock;
        synchronized (object) {
            this.remoteMonitor = subMonitor;
        }
        ExecutorService executorService = this.getCancelationExecutorService();
        if (executorService != null) {
            executorService.execute((Runnable)new RunnableWithName(){

                public String getName() {
                    return MAIN_MONITOR_NAME;
                }

                protected void doRun() {
                    SignalProtocol<?> protocol = RequestWithMonitoring.this.getProtocol();
                    int correlationID = RequestWithMonitoring.this.getCorrelationID();
                    long cancelationPollInterval = RequestWithMonitoring.this.getCancelationPollInterval();
                    while (RequestWithMonitoring.this.mainMonitor != null) {
                        ConcurrencyUtil.sleep((long)cancelationPollInterval);
                        if (RequestWithMonitoring.this.mainMonitor == null || !RequestWithMonitoring.this.mainMonitor.isCanceled()) continue;
                        try {
                            new MonitorCanceledRequest(protocol, correlationID).sendAsync();
                        }
                        catch (Exception ex) {
                            OM.LOG.error((Throwable)ex);
                        }
                        return;
                    }
                }
            });
        }
        int monitorTimeoutSeconds = this.getMonitorTimeoutSeconds();
        int monitorProgressSeconds = this.getMonitorProgressSeconds();
        if (!this.isMonitoring) {
            monitorProgressSeconds = Math.max(monitorProgressSeconds, (int)Math.floor((double)monitorTimeoutSeconds * 0.8));
        }
        out.writeInt(monitorProgressSeconds);
        out.writeInt(monitorTimeoutSeconds);
        this.requesting(out, this.mainMonitor.fork((double)this.getRequestingWorkPercent()));
    }

    @Override
    protected final RESULT confirming(ExtendedDataInputStream in) throws Exception {
        return this.confirming(in, this.mainMonitor.fork((double)this.getConfirmingWorkPercent()));
    }

    protected abstract void requesting(ExtendedDataOutputStream var1, OMMonitor var2) throws Exception;

    protected abstract RESULT confirming(ExtendedDataInputStream var1, OMMonitor var2) throws Exception;

    protected ExecutorService getCancelationExecutorService() {
        return this.getProtocol().getExecutorService();
    }

    protected long getCancelationPollInterval() {
        return 100L;
    }

    protected int getMonitorProgressSeconds() {
        return 1;
    }

    protected int getMonitorTimeoutSeconds() {
        return 10;
    }

    protected int getRequestingWorkPercent() {
        return 2;
    }

    protected int getConfirmingWorkPercent() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doExecute(BufferInputStream in, BufferOutputStream out) throws Exception {
        try {
            super.doExecute(in, out);
        }
        catch (Throwable throwable) {
            Object object = this.monitorLock;
            synchronized (object) {
                block27: {
                    try {
                        try {
                            if (this.remoteMonitor != null) {
                                this.remoteMonitor.done();
                            }
                        }
                        catch (Exception ex) {
                            OM.LOG.error((Throwable)ex);
                            this.remoteMonitor = null;
                            break block27;
                        }
                    }
                    catch (Throwable throwable2) {
                        this.remoteMonitor = null;
                        throw throwable2;
                    }
                    this.remoteMonitor = null;
                }
            }
            try {
                if (this.mainMonitor != null) {
                    this.mainMonitor.done();
                }
            }
            finally {
                this.mainMonitor = null;
            }
            throw throwable;
        }
        Object object = this.monitorLock;
        synchronized (object) {
            block30: {
                try {
                    try {
                        if (this.remoteMonitor != null) {
                            this.remoteMonitor.done();
                        }
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                        this.remoteMonitor = null;
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    this.remoteMonitor = null;
                    throw throwable;
                }
                this.remoteMonitor = null;
            }
        }
        try {
            if (this.mainMonitor != null) {
                this.mainMonitor.done();
            }
        }
        finally {
            this.mainMonitor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setMonitorProgress(double totalWork, double work) {
        super.setMonitorProgress(totalWork, work);
        Object object = this.monitorLock;
        synchronized (object) {
            if (this.remoteMonitor != null) {
                if (!this.remoteMonitor.hasBegun()) {
                    this.remoteMonitor.begin(totalWork);
                    this.remoteMonitor.worked(work);
                } else {
                    double oldRatio = this.remoteMonitor.getWork() / this.remoteMonitor.getTotalWork();
                    double newRatio = work / totalWork;
                    double newWork = newRatio - oldRatio;
                    if ((newWork *= this.remoteMonitor.getTotalWork()) >= 0.0) {
                        this.remoteMonitor.worked(newWork);
                    }
                }
            }
        }
    }

    private void initMainMonitor(OMMonitor monitor) {
        this.isMonitoring = monitor != null;
        this.mainMonitor = this.isMonitoring ? monitor : new Monitor();
    }
}

