/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import java.util.Objects;
import java.util.function.BiPredicate;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.factory.AnnotationFactory;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.security.AdministrationPredicate;

public interface IRepositoryProtector
extends IContainer<UserInfo>,
IManagedContainerProvider {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.repositoryProtectors";
    public static final String DEFAULT_TYPE = "default";

    public boolean isFirstTime();

    public IRepository getRepository();

    public void setRepository(IRepository var1);

    public IRepository[] getSecondaryRepositories();

    public void addSecondaryRepository(IRepository var1);

    public void removeSecondaryRepository(IRepository var1);

    public UserAuthenticator getUserAuthenticator();

    public void setUserAuthenticator(UserAuthenticator var1);

    public AuthorizationStrategy getAuthorizationStrategy();

    public void setAuthorizationStrategy(AuthorizationStrategy var1);

    public RevisionAuthorizer[] getRevisionAuthorizers();

    public void addRevisionAuthorizer(RevisionAuthorizer var1);

    public void removeRevisionAuthorizer(RevisionAuthorizer var1);

    public CommitHandler[] getCommitHandlers();

    public void addCommitHandler(CommitHandler var1);

    public void removeCommitHandler(CommitHandler var1);

    public UserInfo getUserInfo(String var1);

    public static abstract class AuthorizationStrategy
    extends Element
    implements BiPredicate<CDOPermission, CDOPermission> {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.repositoryProtectorAuthorizationStrategies";
        public static final String DEFAULT_TYPE = "additive";
        public static final AuthorizationStrategy DEFAULT = new Additive();
        private CDOPermission initialPermission;
        private CDOPermission terminalPermission;
        private boolean authorizeAttach = true;
        private boolean authorizeModify = true;
        private boolean authorizeDetach = true;

        public final CDOPermission getInitialPermission() {
            return this.initialPermission;
        }

        @AnnotationFactory.InjectAttribute(name="initialPermission")
        public final void setInitialPermission(CDOPermission initialPermission) {
            this.checkInactive();
            this.initialPermission = initialPermission;
        }

        public final CDOPermission getTerminalPermission() {
            return this.terminalPermission;
        }

        @AnnotationFactory.InjectAttribute(name="terminalPermission")
        public final void setTerminalPermission(CDOPermission terminalPermission) {
            this.checkInactive();
            this.terminalPermission = terminalPermission;
        }

        public final boolean isAuthorizeAttach() {
            return this.authorizeAttach;
        }

        @AnnotationFactory.InjectAttribute(name="authorizeAttach")
        public final void setAuthorizeAttach(boolean authorizeAttach) {
            this.checkInactive();
            this.authorizeAttach = authorizeAttach;
        }

        public final boolean isAuthorizeModify() {
            return this.authorizeModify;
        }

        @AnnotationFactory.InjectAttribute(name="authorizeModify")
        public final void setAuthorizeModify(boolean authorizeModify) {
            this.checkInactive();
            this.authorizeModify = authorizeModify;
        }

        public final boolean isAuthorizeDetach() {
            return this.authorizeDetach;
        }

        @AnnotationFactory.InjectAttribute(name="authorizeDetach")
        public final void setAuthorizeDetach(boolean authorizeDetach) {
            this.checkInactive();
            this.authorizeDetach = authorizeDetach;
        }

        public final CDOPermission getCombinedPermission(CDOPermission currentPermission, CDOPermission newPermission) {
            return this.test(currentPermission, newPermission) ? newPermission : currentPermission;
        }

        @Override
        public abstract boolean test(CDOPermission var1, CDOPermission var2);

        @Override
        protected void doBeforeActivate() throws Exception {
            this.checkState(this.initialPermission, "initialPermission");
            this.checkState(this.terminalPermission, "terminalPermission");
        }

        public static class Additive
        extends AuthorizationStrategy {
            public static final CDOPermission DEFAULT_INITIAL_PERMISSION = CDOPermission.NONE;
            public static final CDOPermission DEFAULT_TERMINAL_PERMISSION = CDOPermission.WRITE;

            public Additive() {
                this.setInitialPermission(DEFAULT_INITIAL_PERMISSION);
                this.setTerminalPermission(DEFAULT_TERMINAL_PERMISSION);
            }

            @Override
            public boolean test(CDOPermission currentPermission, CDOPermission newPermission) {
                return currentPermission.compareTo((Enum)newPermission) < 0;
            }
        }

        public static class Subtractive
        extends AuthorizationStrategy {
            public static final CDOPermission DEFAULT_INITIAL_PERMISSION = CDOPermission.WRITE;
            public static final CDOPermission DEFAULT_TERMINAL_PERMISSION = CDOPermission.NONE;

            public Subtractive() {
                this.setInitialPermission(DEFAULT_INITIAL_PERMISSION);
                this.setTerminalPermission(DEFAULT_TERMINAL_PERMISSION);
            }

            @Override
            public boolean test(CDOPermission currentPermission, CDOPermission newPermission) {
                return currentPermission.compareTo((Enum)newPermission) > 0;
            }
        }
    }

    public static abstract class CommitHandler
    extends Element {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.repositoryProtectorCommitHandlers";

        public abstract void beforeCommit(IStoreAccessor.CommitContext var1, UserInfo var2);

        public abstract void afterCommit(IStoreAccessor.CommitContext var1, UserInfo var2);
    }

    public static class Element
    extends Lifecycle
    implements IManagedContainerProvider {
        private IRepositoryProtector repositoryProtector;

        private Element() {
        }

        public final IManagedContainer getContainer() {
            return this.repositoryProtector == null ? null : this.repositoryProtector.getContainer();
        }

        public final IRepositoryProtector getRepositoryProtector() {
            return this.repositoryProtector;
        }

        public final void setRepositoryProtector(IRepositoryProtector repositoryProtector) {
            this.checkInactive();
            this.repositoryProtector = repositoryProtector;
        }

        protected void doBeforeActivate() throws Exception {
            if (this.checkRepositoryProtector()) {
                this.checkState(this.repositoryProtector, "repositoryProtector");
            }
        }

        protected boolean checkRepositoryProtector() {
            return true;
        }
    }

    public static abstract class RevisionAuthorizer
    extends Element {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.repositoryProtectorRevisionAuthorizers";
        private Operation operation = Operation.COMBINE;
        private boolean disabled;

        public final Operation getOperation() {
            return this.operation;
        }

        @AnnotationFactory.InjectAttribute(name="operation")
        public final void setOperation(Operation operation) {
            this.checkInactive();
            this.operation = operation;
        }

        public final boolean isDisabled() {
            return this.disabled;
        }

        @AnnotationFactory.InjectAttribute(name="disabled")
        public final void setDisabled(boolean disabled) {
            this.checkInactive();
            this.disabled = disabled;
        }

        public abstract CDOPermission authorizeRevision(ISession var1, UserInfo var2, CDOBranchPoint var3, CDORevisionProvider var4, CDORevision var5);

        @Override
        protected void doBeforeActivate() throws Exception {
            super.doBeforeActivate();
            this.checkState((Object)this.operation, "operation");
        }

        public static enum Operation {
            COMBINE,
            OVERRIDE,
            VETO;

        }
    }

    public static abstract class UserAuthenticator
    extends Element
    implements AdministrationPredicate {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.repositoryProtectorUserAuthenticators";

        public Class<? extends UserInfo> getUserInfoClass() {
            return UserInfo.class;
        }

        public abstract UserInfo authenticateUser(String var1, char[] var2);

        public boolean isAdministrator(String userID) {
            return false;
        }

        public static interface PasswordChangeSupport {
            public void updatePassword(String var1, char[] var2, char[] var3) throws SecurityException;

            public void resetPassword(String var1, char[] var2, String var3, char[] var4) throws SecurityException;

            public void resetPassword(String var1, char[] var2) throws SecurityException;
        }
    }

    public static class UserInfo
    implements Comparable<UserInfo> {
        private final String userID;

        public UserInfo(String userID) {
            this.userID = userID;
        }

        public final String userID() {
            return this.userID;
        }

        public final int hashCode() {
            return Objects.hash(this.userID);
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UserInfo)) {
                return false;
            }
            UserInfo other = (UserInfo)obj;
            return Objects.equals(this.userID, other.userID);
        }

        public final boolean equalsStructurally(Object obj) {
            return this.equals(obj) && this.isStructurallyEqual((UserInfo)obj);
        }

        @Override
        public final int compareTo(UserInfo o) {
            return StringUtil.compare((String)this.userID, (String)o.userID);
        }

        public String toString() {
            return "UserInfo[" + this.userID + "]";
        }

        protected boolean isStructurallyEqual(UserInfo userInfo) {
            return true;
        }
    }

    public static final class UserInfoChangedEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private final UserInfo oldUserInfo;
        private final UserInfo newUserInfo;

        public UserInfoChangedEvent(IRepositoryProtector notifier, UserInfo oldUserInfo, UserInfo newUserInfo) {
            super((INotifier)notifier);
            this.oldUserInfo = oldUserInfo;
            this.newUserInfo = newUserInfo;
        }

        public IRepositoryProtector getSource() {
            return (IRepositoryProtector)super.getSource();
        }

        public UserInfo getOldUserInfo() {
            return this.oldUserInfo;
        }

        public UserInfo getNewUserInfo() {
            return this.newUserInfo;
        }
    }
}

