/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.views;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionManager;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.views.ContainerView;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class CDORemoteSessionsView
extends ContainerView.Default<CDORemoteSessionManager> {
    public static final String ID = "org.eclipse.emf.cdo.ui.CDORemoteSessionsView";
    private static final String TYPE_TEXT_MESSAGE = "org.eclipse.emf.cdo.ui.TextMessage";
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Object object;
            CDOSession session;
            if (part != CDORemoteSessionsView.this && (session = CDOUtil.getSession((Object)(object = UIUtil.getElementIfOne((ISelection)selection)))) != null) {
                CDORemoteSessionsView.this.setContainer((IContainer)session.getRemoteSessionManager());
            }
        }
    };
    private IListener containerListener = new CDORemoteSessionManager.EventAdapter(){

        protected void onLocalSubscriptionChanged(boolean subscribed) {
            CDORemoteSessionsView.this.getViewer().getControl().setEnabled(subscribed);
        }

        protected void onSubscribed(CDORemoteSession remoteSession) {
            CDORemoteSessionsView.this.refreshElement(remoteSession, true);
        }

        protected void onUnsubscribed(CDORemoteSession remoteSession) {
            CDORemoteSessionsView.this.refreshElement(remoteSession, true);
        }

        protected void onMessageReceived(final CDORemoteSession remoteSession, final CDORemoteSessionMessage message) {
            if (CDORemoteSessionsView.TYPE_TEXT_MESSAGE.equals(message.getType())) {
                try {
                    CDORemoteSessionsView.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                MessageDialog.openInformation((Shell)CDORemoteSessionsView.this.getShell(), (String)MessageFormat.format(Messages.getString("CDORemoteSessionsView_0"), remoteSession), (String)new String(message.getData()));
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }

        protected void onDeactivated(ILifecycle lifecycle) {
            CDORemoteSessionsView.this.setContainer(null);
        }
    };

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.selectionListener);
        super.dispose();
    }

    protected Control createUI(Composite parent) {
        Control control = super.createUI(parent);
        this.getViewer().getControl().setEnabled(false);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.selectionListener);
        return control;
    }

    protected IListener getContainerListener() {
        return this.containerListener;
    }

    protected Color getElementForeground(Object element) {
        CDORemoteSession remoteSession;
        if (element instanceof CDORemoteSession && !(remoteSession = (CDORemoteSession)element).isSubscribed()) {
            return this.getDisplay().getSystemColor(15);
        }
        return null;
    }

    protected void doubleClicked(Object element) {
        CDORemoteSession remoteSession;
        if (element instanceof CDORemoteSession && (remoteSession = (CDORemoteSession)element).isSubscribed()) {
            InputDialog dlg = new InputDialog(this.getShell(), MessageFormat.format(Messages.getString("CDORemoteSessionsView_1"), remoteSession), Messages.getString("CDORemoteSessionsView_2"), "", null);
            if (dlg.open() == 0) {
                String message = dlg.getValue();
                remoteSession.sendMessage(new CDORemoteSessionMessage(TYPE_TEXT_MESSAGE, message.getBytes()));
            }
            return;
        }
        super.doubleClicked(element);
    }
}

