/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class UTFTest
extends AbstractOMTest {
    private static final int UNSIGNED_SHORT_MAX = 65535;

    public void testUTF8_OneOctet() throws Exception {
        int MAX = 6554;
        String part = "0123456789";
        UTFTest.assertEquals((int)10, (int)part.length());
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < 6554) {
            builder.append(part);
            ++i;
        }
        String str = builder.toString();
        UTFTest.assertEquals((boolean)true, (str.length() > 65535 ? 1 : 0) != 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(str);
        String received = baos.toString("UTF-8");
        UTFTest.assertEquals((String)str, (String)received);
    }

    public void testUTF8_ThreeOctets() throws Exception {
        int MAX = Short.MAX_VALUE;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < Short.MAX_VALUE) {
            builder.append("\u6771");
            ++i;
        }
        String str = builder.toString();
        UTFTest.assertEquals((int)Short.MAX_VALUE, (int)str.length());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(str);
        String received = baos.toString("UTF-8");
        UTFTest.assertEquals((String)str, (String)received);
    }
}

