/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class CaseInsensitiveStringSet
extends HashSet<String> {
    private static final long serialVersionUID = 1L;

    public CaseInsensitiveStringSet() {
    }

    public CaseInsensitiveStringSet(Collection<? extends String> c) {
        super(c);
    }

    public CaseInsensitiveStringSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CaseInsensitiveStringSet(int initialCapacity) {
        super(initialCapacity);
    }

    public boolean isLowerCase() {
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(this.convert(o));
    }

    @Override
    public boolean add(String e) {
        return super.add(this.convert(e));
    }

    @Override
    public boolean remove(Object o) {
        return super.remove(this.convert(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(this.convert(c));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return super.containsAll(this.convert(c));
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        boolean modified = false;
        Iterator<? extends String> e = c.iterator();
        while (e.hasNext()) {
            if (!this.add(this.convert(e.next()))) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(this.convert(c));
    }

    protected String convert(Object o) {
        if (o instanceof String) {
            if (this.isLowerCase()) {
                return ((String)o).toLowerCase();
            }
            return ((String)o).toUpperCase();
        }
        return null;
    }

    protected Collection<?> convert(Collection<?> c) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : c) {
            list.add(this.convert(o));
        }
        return list;
    }
}

