/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.internal.server.protocol;

import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.internal.jms.util.MessageUtil;
import org.eclipse.net4j.jms.internal.server.Server;
import org.eclipse.net4j.jms.internal.server.ServerConnection;
import org.eclipse.net4j.jms.internal.server.protocol.JMSServerProtocol;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class JMSClientMessageIndication
extends IndicationWithResponse {
    private String messageID;

    public JMSClientMessageIndication(JMSServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)8);
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        MessageImpl[] messages = new MessageImpl[]{MessageUtil.read((ExtendedDataInputStream)in)};
        JMSServerProtocol protocol = (JMSServerProtocol)this.getProtocol();
        ServerConnection connection = (ServerConnection)protocol.getInfraStructure();
        Server server = connection.getServer();
        String[] ids = server.handleClientMessages(messages);
        if (ids != null && ids.length != 0) {
            this.messageID = ids[0];
        }
    }

    protected void responding(ExtendedDataOutputStream out) throws Exception {
        out.writeString(this.messageID);
    }
}

