/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IUnit;
import org.eclipse.emf.cdo.server.IUnitManager;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalUnitManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class UnitManager
extends Container<IUnit>
implements InternalUnitManager {
    private final InternalRepository repository;
    private final Map<CDOID, IUnit> units = CDOIDUtil.createMap();
    private final Map<CDOID, UnitInitializer> unitInitializers = CDOIDUtil.createMap();
    private final Set<ObjectAttacher> objectAttachers = new HashSet<ObjectAttacher>();
    private final ReentrantReadWriteLock managerLock = new ReentrantReadWriteLock();

    public UnitManager(InternalRepository repository) {
        this.repository = repository;
    }

    @Override
    public final InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public boolean isUnit(CDOID rootID) {
        this.checkActive();
        ReentrantReadWriteLock.ReadLock readLock = this.managerLock.readLock();
        readLock.lock();
        try {
            boolean bl = this.units.containsKey(rootID);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IUnit createUnit(CDOID rootID, IView view, CDORevisionHandler revisionHandler, OMMonitor monitor) {
        UnitInitializer unitInitializer;
        boolean hook;
        ReentrantReadWriteLock.WriteLock writeLock;
        block25: {
            this.checkActive();
            writeLock = this.managerLock.writeLock();
            hook = false;
            writeLock.lock();
            try {
                this.createUnitHook1();
                if (this.units.containsKey(rootID)) {
                    return null;
                }
                unitInitializer = this.unitInitializers.get(rootID);
                if (unitInitializer != null) {
                    hook = true;
                    break block25;
                }
                this.checkNotNested(rootID, view, this.units.keySet());
                this.checkNotNested(rootID, view, this.unitInitializers.keySet());
                unitInitializer = this.createUnitInitializer(rootID, view, revisionHandler);
                this.unitInitializers.put(rootID, unitInitializer);
                Set<ObjectAttacher> set = this.objectAttachers;
                synchronized (set) {
                    for (ObjectAttacher objectAttacher : this.objectAttachers) {
                        List<CDOID> ids = objectAttacher.removeUnmappedRevisionsFor(unitInitializer);
                        if (ids.isEmpty()) continue;
                        unitInitializer.addObjectAttacher(objectAttacher, ids);
                    }
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        if (hook) {
            return unitInitializer.hook(rootID, view, revisionHandler, monitor);
        }
        IUnit unit = null;
        try {
            unit = unitInitializer.initialize(monitor);
        }
        finally {
            try {
                writeLock.lock();
                try {
                    this.unitInitializers.remove(rootID);
                    if (unit != null) {
                        this.units.put(rootID, unit);
                    }
                }
                finally {
                    writeLock.unlock();
                }
            }
            finally {
                unitInitializer.notifyHookedInitializers();
            }
        }
        this.fireElementAddedEvent(unit);
        return unit;
    }

    private void checkNotNested(CDOID rootID, IView view, Set<CDOID> unitIDs) {
        InternalCDORevision rootRevision = (InternalCDORevision)view.getRevision(rootID);
        CDOID unitID = UnitManager.getUnitOf(rootRevision, (CDORevisionProvider)view, unitIDs);
        if (unitID != null) {
            throw new CDOException("Attempt to nest the new unit " + rootID + " in the existing unit " + unitID);
        }
        Set<CDOID> set = Collections.singleton(rootID);
        for (CDOID id : unitIDs) {
            InternalCDORevision revision = (InternalCDORevision)view.getRevision(id);
            if (UnitManager.getUnitOf(revision, (CDORevisionProvider)view, set) == null) continue;
            throw new CDOException("Attempt to nest the existing unit " + id + " in the new unit " + rootID);
        }
    }

    @Override
    public IUnit getUnit(CDOID rootID) {
        this.checkActive();
        ReentrantReadWriteLock.ReadLock readLock = this.managerLock.readLock();
        readLock.lock();
        try {
            IUnit iUnit = this.units.get(rootID);
            return iUnit;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public IUnit[] getUnits() {
        this.checkActive();
        return this.getElements();
    }

    public IUnit[] getElements() {
        ReentrantReadWriteLock.ReadLock readLock = this.managerLock.readLock();
        readLock.lock();
        try {
            IUnit[] iUnitArray = this.units.values().toArray(new IUnit[this.units.size()]);
            return iUnitArray;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Map<CDOID, CDOID> getUnitsOf(Set<CDOID> ids, CDORevisionProvider revisionProvider) {
        ReentrantReadWriteLock.ReadLock readLock = this.managerLock.readLock();
        readLock.lock();
        try {
            HashMap<CDOID, CDOID> units = new HashMap<CDOID, CDOID>();
            Set<CDOID> rootIDs = this.getRootIDs();
            if (!rootIDs.isEmpty()) {
                for (CDOID id : ids) {
                    InternalCDORevision revision = (InternalCDORevision)revisionProvider.getRevision(id);
                    CDOID rootID = UnitManager.getUnitOf(revision, revisionProvider, rootIDs);
                    if (rootID == null) continue;
                    units.put(id, rootID);
                }
            }
            HashMap<CDOID, CDOID> hashMap = units;
            return hashMap;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public List<InternalCDORevisionDelta> getUnitMoves(InternalCDORevisionDelta[] deltas, CDORevisionProvider before, CDORevisionProvider after) {
        ReentrantReadWriteLock.ReadLock readLock = this.managerLock.readLock();
        readLock.lock();
        try {
            ArrayList<InternalCDORevisionDelta> unitMoves = new ArrayList<InternalCDORevisionDelta>();
            Set<CDOID> rootIDs = this.getRootIDs();
            if (!rootIDs.isEmpty()) {
                InternalCDORevisionDelta[] internalCDORevisionDeltaArray = deltas;
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalCDORevisionDelta delta = internalCDORevisionDeltaArray[n2];
                    CDOID id = delta.getID();
                    for (CDOFeatureDelta featureDelta : delta.getFeatureDeltas()) {
                        InternalCDORevision afterRevision;
                        CDOID afterUnit;
                        InternalCDORevision beforeRevision;
                        CDOID beforeUnit;
                        EStructuralFeature feature = featureDelta.getFeature();
                        if (feature != CDOContainerFeatureDelta.CONTAINER_FEATURE || (beforeUnit = UnitManager.getUnitOf(beforeRevision = (InternalCDORevision)before.getRevision(id), before, rootIDs)) == null || (afterUnit = UnitManager.getUnitOf(afterRevision = (InternalCDORevision)after.getRevision(id), after, rootIDs)) == beforeUnit) continue;
                        unitMoves.add(delta);
                    }
                    ++n2;
                }
            }
            ArrayList<InternalCDORevisionDelta> arrayList = unitMoves;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalUnitManager.InternalObjectAttacher attachObjects(InternalCommitContext commitContext) {
        Map unitMappings;
        ObjectAttacher objectAttacher;
        long timeStamp;
        block10: {
            this.checkActive();
            timeStamp = commitContext.getTimeStamp();
            objectAttacher = null;
            unitMappings = CDOIDUtil.createMap();
            ReentrantReadWriteLock.ReadLock readLock = this.managerLock.readLock();
            readLock.lock();
            try {
                this.attachObjectsHook1();
                Set<CDOID> rootIDs = this.getRootIDs();
                boolean checkUnits = !rootIDs.isEmpty();
                ArrayList<InternalCDORevision> unmappedRevisions = new ArrayList<InternalCDORevision>();
                InternalCDORevision[] internalCDORevisionArray = commitContext.getNewObjects();
                int n = internalCDORevisionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOID rootID;
                    InternalCDORevision revision = internalCDORevisionArray[n2];
                    if (checkUnits && (rootID = UnitManager.getUnitOf(revision, commitContext, rootIDs)) != null) {
                        unitMappings.put(revision.getID(), rootID);
                    } else {
                        unmappedRevisions.add(revision);
                    }
                    ++n2;
                }
                if (unmappedRevisions.isEmpty()) break block10;
                objectAttacher = this.createObjectAttacher(commitContext, unmappedRevisions);
                Set<ObjectAttacher> set = this.objectAttachers;
                synchronized (set) {
                    this.objectAttachers.add(objectAttacher);
                }
            }
            finally {
                readLock.unlock();
            }
        }
        if (!unitMappings.isEmpty()) {
            this.mapAttachedObjectsToUnits(commitContext, timeStamp, unitMappings);
        }
        return objectAttacher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectAttacherFinishedCommit(ObjectAttacher objectAttacher) {
        this.checkActive();
        Set<ObjectAttacher> set = this.objectAttachers;
        synchronized (set) {
            this.objectAttachers.remove(objectAttacher);
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        IStoreAccessor.UnitSupport storeAccessor = (IStoreAccessor.UnitSupport)this.repository.getStore().getReader(null);
        try {
            List<CDOID> roots = storeAccessor.readUnitRoots();
            for (CDOID root : roots) {
                Unit unit = this.createUnit(root);
                this.units.put(root, unit);
            }
        }
        finally {
            storeAccessor.release();
        }
    }

    protected void doDeactivate() throws Exception {
        this.units.clear();
        super.doDeactivate();
    }

    protected Unit createUnit(CDOID root) {
        return new Unit(root);
    }

    protected UnitInitializer createUnitInitializer(CDOID rootID, IView view, CDORevisionHandler revisionHandler) {
        return new UnitInitializer(rootID, view, revisionHandler);
    }

    protected ObjectAttacher createObjectAttacher(InternalCommitContext commitContext, List<InternalCDORevision> unmappedRevisions) {
        return new ObjectAttacher(commitContext, unmappedRevisions);
    }

    protected void mapAttachedObjectsToUnits(InternalCommitContext commitContext, long timeStamp, Map<CDOID, CDOID> unitMappings) {
        IStoreAccessor.UnitSupport storeAccessor = (IStoreAccessor.UnitSupport)commitContext.getAccessor();
        storeAccessor.writeUnits(unitMappings, timeStamp);
    }

    protected void createUnitHook1() {
    }

    protected void attachObjectsHook1() {
    }

    private Set<CDOID> getRootIDs() {
        HashSet<CDOID> rootIDs = new HashSet<CDOID>();
        rootIDs.addAll(this.units.keySet());
        rootIDs.addAll(this.unitInitializers.keySet());
        return rootIDs;
    }

    private static CDOID getUnitOf(InternalCDORevision revision, CDORevisionProvider revisionProvider, Set<CDOID> rootIDs) {
        if (rootIDs.isEmpty()) {
            return null;
        }
        CDOID id = revision.getID();
        if (rootIDs.contains(id)) {
            return id;
        }
        CDORevision parentRevision = CDORevisionUtil.getParentRevision((CDORevision)revision, (CDORevisionProvider)revisionProvider);
        if (parentRevision != null) {
            return UnitManager.getUnitOf((InternalCDORevision)parentRevision, revisionProvider, rootIDs);
        }
        return null;
    }

    protected class ObjectAttacher
    implements InternalUnitManager.InternalObjectAttacher {
        private final InternalCommitContext commitContext;
        private final List<InternalCDORevision> unmappedRevisions;
        private final CountDownLatch commitFinished = new CountDownLatch(1);
        private boolean commitSucceeded;

        public ObjectAttacher(InternalCommitContext commitContext, List<InternalCDORevision> unmappedRevisions) {
            this.commitContext = commitContext;
            this.unmappedRevisions = unmappedRevisions;
        }

        @Override
        public void finishedCommit(boolean success) {
            UnitManager.this.objectAttacherFinishedCommit(this);
            this.commitSucceeded = success;
            this.commitFinished.countDown();
        }

        public List<CDOID> removeUnmappedRevisionsFor(UnitInitializer unitInitializer) {
            ArrayList<CDOID> ids = new ArrayList<CDOID>();
            Set<CDOID> rootIDs = Collections.singleton(unitInitializer.getRootID());
            Iterator<InternalCDORevision> it = this.unmappedRevisions.iterator();
            while (it.hasNext()) {
                InternalCDORevision revision = it.next();
                if (UnitManager.getUnitOf(revision, this.commitContext, rootIDs) == null) continue;
                ids.add(revision.getID());
                it.remove();
            }
            return ids;
        }

        public boolean awaitFinishedCommit() {
            try {
                this.commitFinished.await();
            }
            catch (InterruptedException ex) {
                return false;
            }
            return this.commitSucceeded;
        }
    }

    protected class Unit
    implements IUnit {
        private final CDOID rootID;
        private final Set<IView> views = new HashSet<IView>();

        public Unit(CDOID rootID) {
            this.rootID = rootID;
        }

        @Override
        public IUnitManager getManager() {
            return UnitManager.this;
        }

        @Override
        public CDOID getRootID() {
            return this.rootID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isOpen() {
            Set<IView> set = this.views;
            synchronized (set) {
                return !this.views.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void open(IView view, CDORevisionHandler revisionHandler, OMMonitor monitor) {
            Set<IView> set = this.views;
            synchronized (set) {
                this.views.add(view);
            }
            IStoreAccessor.UnitSupport storeAccessor = (IStoreAccessor.UnitSupport)UnitManager.this.repository.getStore().getReader(null);
            try {
                storeAccessor.readUnit(view, this.rootID, revisionHandler, monitor);
            }
            finally {
                storeAccessor.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(IView view) {
            Set<IView> set = this.views;
            synchronized (set) {
                this.views.remove(view);
            }
            ((InternalView)view).closeUnit(this.rootID);
        }

        public String toString() {
            return "Unit[" + this.rootID + "]";
        }

        public void initialize(IView view, long timeStamp, CDORevisionHandler revisionHandler, Map<ObjectAttacher, List<CDOID>> objectAttachers, OMMonitor monitor) {
            IStoreAccessor.UnitSupport storeAccessor = (IStoreAccessor.UnitSupport)UnitManager.this.repository.getStore().getWriter(null);
            try {
                HashSet<CDOID> initializedIDs = new HashSet<CDOID>();
                Object initResult = storeAccessor.initUnit(view, this.rootID, revisionHandler, initializedIDs, timeStamp, monitor);
                ArrayList<CDOID> ids = new ArrayList<CDOID>();
                for (Map.Entry<ObjectAttacher, List<CDOID>> entry : objectAttachers.entrySet()) {
                    ObjectAttacher objectAttacher = entry.getKey();
                    if (!objectAttacher.awaitFinishedCommit()) continue;
                    for (CDOID id : entry.getValue()) {
                        if (initializedIDs.contains(id)) continue;
                        ids.add(id);
                    }
                }
                storeAccessor.finishUnit(view, this.rootID, revisionHandler, timeStamp, initResult, ids);
            }
            finally {
                storeAccessor.release();
            }
        }
    }

    protected class UnitInitializer
    implements CDORevisionHandler {
        private final long timeStamp;
        private final Map<ObjectAttacher, List<CDOID>> concurrentObjectAttachers;
        private final CountDownLatch unitInitialized;
        private final CDOID rootID;
        private final IView view;
        private final CDORevisionHandler revisionHandler;
        private final List<CDORevisionHandler> hookedRevisionHandlers;
        private volatile boolean hasHookedRevisionHandlers;
        private Unit unit;

        public UnitInitializer(CDOID rootID, IView view, CDORevisionHandler revisionHandler) {
            this.timeStamp = UnitManager.this.repository.getTimeStamp();
            this.concurrentObjectAttachers = new HashMap<ObjectAttacher, List<CDOID>>();
            this.unitInitialized = new CountDownLatch(1);
            this.hookedRevisionHandlers = new CopyOnWriteArrayList<CDORevisionHandler>();
            this.rootID = rootID;
            this.view = view;
            this.revisionHandler = revisionHandler;
        }

        public CDOID getRootID() {
            return this.rootID;
        }

        public IUnit initialize(OMMonitor monitor) {
            this.unit = new Unit(this.rootID);
            this.unit.initialize(this.view, this.timeStamp, this.revisionHandler, this.concurrentObjectAttachers, monitor);
            return this.unit;
        }

        public IUnit hook(CDOID rootID, IView view, final CDORevisionHandler revisionHandler, OMMonitor monitor) {
            HashSet ids;
            block11: {
                ids = new HashSet();
                this.hookedRevisionHandlers.add(new CDORevisionHandler(){

                    public boolean handleRevision(CDORevision revision) {
                        ids.add(revision.getID());
                        return revisionHandler.handleRevision(revision);
                    }
                });
                this.hasHookedRevisionHandlers = true;
                monitor.begin(2.0);
                OMMonitor.Async async = null;
                try {
                    try {
                        async = monitor.forkAsync();
                        while (!this.unitInitialized.await(100L, TimeUnit.MILLISECONDS)) {
                            monitor.checkCanceled();
                        }
                    }
                    catch (InterruptedException ex) {
                        if (async != null) {
                            async.stop();
                        }
                        monitor.done();
                        return null;
                    }
                }
                finally {
                    if (async == null) break block11;
                }
                async.stop();
            }
            this.unit.open(view, new CDORevisionHandler(){

                public boolean handleRevision(CDORevision revision) {
                    if (ids.contains(revision.getID())) {
                        return true;
                    }
                    return revisionHandler.handleRevision(revision);
                }
            }, monitor.fork());
            Unit unit = this.unit;
            return unit;
            finally {
                monitor.done();
            }
        }

        public void notifyHookedInitializers() {
            this.unitInitialized.countDown();
        }

        public boolean handleRevision(CDORevision revision) {
            if (this.revisionHandler.handleRevision(revision)) {
                if (this.hasHookedRevisionHandlers) {
                    for (CDORevisionHandler hookedRevisionHandler : this.hookedRevisionHandlers) {
                        hookedRevisionHandler.handleRevision(revision);
                    }
                }
                return true;
            }
            return false;
        }

        public void addObjectAttacher(ObjectAttacher objectAttacher, List<CDOID> ids) {
            this.concurrentObjectAttachers.put(objectAttacher, ids);
        }
    }
}

