/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.migrator.tasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.internal.migrator.tasks.CDOTask;

public class ImportProjectTask
extends CDOTask {
    private String projectName;
    private File fromLocation;

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setFromLocation(File fromLocation) {
        this.fromLocation = fromLocation;
    }

    @Override
    protected void checkAttributes() throws BuildException {
        ImportProjectTask.assertTrue("'projectName' must be specified.", this.projectName != null && this.projectName.length() != 0);
        ImportProjectTask.assertTrue("'fromLocation' must be specified.", this.fromLocation != null);
        ImportProjectTask.assertTrue("'fromLocation' must be point to an existing directory.", this.fromLocation.isDirectory());
    }

    @Override
    protected void doExecute() throws Exception {
        IProject project = this.root.getProject(this.projectName);
        if (project.exists()) {
            File existingLocation = new File(project.getLocation().toOSString()).getCanonicalFile();
            if (!existingLocation.equals(this.fromLocation)) {
                throw new BuildException("Project " + this.projectName + " exists in different location: " + existingLocation);
            }
            this.verbose("Project " + this.fromLocation + " is already imported.");
            return;
        }
        this.verbose("Importing project " + this.fromLocation + " ...");
        Path locationPath = new Path(this.fromLocation.getAbsolutePath());
        IProjectDescription projectDescription = this.workspace.newProjectDescription(this.projectName);
        projectDescription.setLocation((IPath)locationPath);
        project.create(projectDescription, (IProgressMonitor)new NullProgressMonitor());
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

