/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.buddies.protocol;

import java.util.Set;
import org.eclipse.net4j.buddies.IBuddySession;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.IBuddyContainer;
import org.eclipse.net4j.buddies.common.ICollaboration;
import org.eclipse.net4j.buddies.internal.common.Membership;
import org.eclipse.net4j.buddies.internal.common.protocol.ProtocolUtil;
import org.eclipse.net4j.internal.buddies.BuddyCollaboration;
import org.eclipse.net4j.internal.buddies.Self;
import org.eclipse.net4j.internal.buddies.protocol.BuddiesClientProtocol;
import org.eclipse.net4j.signal.Indication;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;

public class CollaborationInitiatedIndication
extends Indication {
    public CollaborationInitiatedIndication(BuddiesClientProtocol protocol) {
        super((SignalProtocol)protocol, (short)7);
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        IBuddySession session = (IBuddySession)this.getProtocol().getInfraStructure();
        Self self = (Self)session.getSelf();
        long collaborationID = in.readLong();
        Set buddies = ProtocolUtil.readBuddies((ExtendedDataInputStream)in, (IBuddyContainer)session);
        String[] facilityTypes = ProtocolUtil.readFacilityTypes((ExtendedDataInputStream)in);
        BuddyCollaboration collaboration = (BuddyCollaboration)self.getCollaboration(collaborationID);
        if (collaboration == null) {
            collaboration = new BuddyCollaboration(session, collaborationID);
            collaboration.activate();
            Membership.create((IBuddy)self, (ICollaboration)collaboration);
            for (IBuddy buddy : buddies) {
                Membership.create((IBuddy)buddy, (ICollaboration)collaboration);
            }
        } else {
            for (IBuddy buddy : buddies) {
                Membership.create((IBuddy)buddy, (ICollaboration)collaboration);
            }
        }
        String[] stringArray = facilityTypes;
        int n = facilityTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String facilityType = stringArray[n2];
            collaboration.installFacility(facilityType, false);
            ++n2;
        }
    }
}

