/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ISetMessage;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.config.QvtConfigurationProperty;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.config.QvtConfigurationPropertyType;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.ApplyTransformationData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class QvtTransformationConfigurationUI {
    protected static final IStructuredContentProvider CONTENT_PROVIDER = new IStructuredContentProvider(){

        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof ConfigurationPropertyValueList)) {
                return null;
            }
            return ((ConfigurationPropertyValueList)inputElement).getAll();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    protected final MyLabelProvider LABEL_PROVIDER = new MyLabelProvider();
    protected final ICellModifier CELL_MODIFIER = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            boolean result = "2".equals(property);
            if (result) {
                ConfigurationPropertyValue value = (ConfigurationPropertyValue)element;
                if (QvtTransformationConfigurationUI.this.isBooleanValue(value)) {
                    QvtTransformationConfigurationUI.this.setCellEditor((CellEditor)QvtTransformationConfigurationUI.this.getBooleanComboBox());
                } else if (QvtTransformationConfigurationUI.this.isEnumValue(value)) {
                    QvtTransformationConfigurationUI.this.setCellEditor(QvtTransformationConfigurationUI.this.getEnumComboBox((EEnum)value.getProperty().getType().getImplementation()));
                } else {
                    QvtTransformationConfigurationUI.this.setCellEditor((CellEditor)QvtTransformationConfigurationUI.this.myTextCellEditor);
                }
            }
            return result;
        }

        public Object getValue(Object element, String property) {
            ConfigurationPropertyValue value = (ConfigurationPropertyValue)element;
            if (QvtTransformationConfigurationUI.this.isBooleanValue(value)) {
                return value.getValue() == Boolean.TRUE ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            if (QvtTransformationConfigurationUI.this.isEnumValue(value)) {
                EEnum eEnum = (EEnum)value.getProperty().getType().getImplementation();
                return eEnum.getELiterals().indexOf(value.getValue());
            }
            if (value.getValue() == QvtConfigurationPropertyType.NOT_SET) {
                return "";
            }
            return value.getProperty().getType().stringValueOf(value.getValue());
        }

        public void modify(Object element, String property, Object value) {
            Object valueToBeSet;
            ConfigurationPropertyValue cpValue;
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (QvtTransformationConfigurationUI.this.isBooleanValue(cpValue = (ConfigurationPropertyValue)element)) {
                valueToBeSet = (Integer)value == 1;
            } else if (QvtTransformationConfigurationUI.this.isEnumValue(cpValue)) {
                EEnum eEnum = (EEnum)cpValue.getProperty().getType().getImplementation();
                valueToBeSet = eEnum.getEEnumLiteral(QvtTransformationConfigurationUI.this.myComboBoxCellEditor.getItems()[(Integer)value]);
            } else {
                valueToBeSet = cpValue.getProperty().getType().valueOf(value.toString());
            }
            cpValue.setValue(valueToBeSet);
            QvtTransformationConfigurationUI.this.myTableViewer.refresh();
            QvtTransformationConfigurationUI.this.notifyListeners(cpValue.getProperty());
        }
    };
    private ISetMessage mySetMessage;
    private final ConfigurationPropertyValueList myProperties = new ConfigurationPropertyValueList();
    private TableViewer myTableViewer;
    private QvtTransformation myTransformation;
    private final ApplyTransformationData myData;
    private final Set<PropertyChangeListener> myListeners = new HashSet<PropertyChangeListener>();
    private boolean myValid;
    private CellEditor[] myEditors;
    private TextCellEditor myTextCellEditor;
    private ComboBoxCellEditor myComboBoxCellEditor;
    private static final String[] BOOLEAN_ITEMS = new String[]{Boolean.FALSE.toString(), Boolean.TRUE.toString()};
    private static final String[] COLUMNS_TO_UPDATE = new String[]{"2"};

    public QvtTransformationConfigurationUI(ApplyTransformationData data, ISetMessage sm) {
        this.mySetMessage = sm;
        this.myData = data;
    }

    public void createControl(Composite parent) {
        int style = 101124;
        this.myTableViewer = new TableViewer(parent, style);
        GridData gridData = new GridData(1808);
        this.myTableViewer.getControl().setLayoutData((Object)gridData);
        this.myTableViewer.setContentProvider((IContentProvider)CONTENT_PROVIDER);
        this.myTableViewer.setLabelProvider((IBaseLabelProvider)this.LABEL_PROVIDER);
        Table table = this.myTableViewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.hookContextMenu();
        this.createColumn(table, layout, Messages.QvtTransformationConfigurationUI_PropertyColumn);
        this.createColumn(table, layout, Messages.QvtTransformationConfigurationUI_TypeColumn);
        this.createColumn(table, layout, Messages.QvtTransformationConfigurationUI_ValueColumn);
        this.myEditors = new CellEditor[3];
        this.myTextCellEditor = new TextCellEditor((Composite)this.myTableViewer.getTable());
        this.myComboBoxCellEditor = new ComboBoxCellEditor((Composite)this.myTableViewer.getTable(), BOOLEAN_ITEMS, 12);
        this.myEditors[2] = this.myTextCellEditor;
        this.myTableViewer.setCellEditors(this.myEditors);
        this.myTableViewer.setColumnProperties(new String[]{"0", "1", "2"});
        this.myTableViewer.setInput((Object)this.myProperties);
        this.myTableViewer.setCellModifier(this.CELL_MODIFIER);
    }

    protected void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new ContributionItem(){
                    private MenuItem myUnsetMenuItem;

                    public void fill(Menu menu, int index) {
                        if (this.myUnsetMenuItem == null) {
                            this.createUnsetMenuItem(menu);
                        }
                        this.myUnsetMenuItem.setEnabled(!QvtTransformationConfigurationUI.this.myTableViewer.getSelection().isEmpty());
                    }

                    private void createUnsetMenuItem(Menu menu) {
                        this.myUnsetMenuItem = new MenuItem(menu, 8);
                        this.myUnsetMenuItem.setText(Messages.QvtTransformationConfigurationUI_UnsetMenuItem);
                        this.myUnsetMenuItem.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent e) {
                                IStructuredSelection sel;
                                ConfigurationPropertyValue firstElement;
                                ISelection selection = QvtTransformationConfigurationUI.this.myTableViewer.getSelection();
                                if (selection instanceof IStructuredSelection && (firstElement = (ConfigurationPropertyValue)(sel = (IStructuredSelection)selection).getFirstElement()) != null) {
                                    firstElement.setValue(QvtConfigurationPropertyType.NOT_SET);
                                    QvtTransformationConfigurationUI.this.myTableViewer.update((Object)firstElement, COLUMNS_TO_UPDATE);
                                    QvtTransformationConfigurationUI.this.notifyListeners(firstElement.getProperty());
                                }
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                                this.widgetSelected(e);
                            }
                        });
                    }
                });
            }
        });
        Menu menu = menuManager.createContextMenu(this.myTableViewer.getControl());
        this.myTableViewer.getControl().setMenu(menu);
    }

    private void createColumn(Table table, TableLayout layout, String name) {
        TableColumn nameColumn = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, true));
        nameColumn.setText(name);
    }

    public void loadValues() {
        this.myTransformation = this.myData.getTransformation();
        Map<String, String> valueMap = this.myData.getConfiguration();
        this.myProperties.clear();
        if (this.myTransformation != null) {
            try {
                Set configurationProperties = this.myTransformation.getConfigurationProperties();
                for (QvtConfigurationProperty property : configurationProperties) {
                    this.myProperties.addProperty(property, valueMap.get(property.getName()));
                }
            }
            catch (MdaException mdaException) {
                // empty catch block
            }
        }
        this.myTableViewer.refresh();
    }

    public void performApply() {
        this.myData.getConfiguration().clear();
        this.myProperties.fillMap(this.myData.getConfiguration());
    }

    public void validate() {
        this.mySetMessage.setMessage(null);
        ConfigurationPropertyValue error = this.myProperties.getFirstError();
        if (error != null) {
            this.mySetMessage.setErrorMessage(NLS.bind((String)Messages.QvtTransformationConfigurationUI_InvalidProperyValue, (Object)String.valueOf(error.getValue()), (Object)error.getProperty().getName()));
            this.myValid = false;
            return;
        }
        this.mySetMessage.setErrorMessage(null);
        this.myValid = true;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myListeners.remove(listener);
    }

    private void notifyListeners(QvtConfigurationProperty property) {
        for (PropertyChangeListener listener : this.myListeners) {
            listener.changePerformed(property);
        }
    }

    private ComboBoxCellEditor getBooleanComboBox() {
        this.myComboBoxCellEditor.setItems(BOOLEAN_ITEMS);
        return this.myComboBoxCellEditor;
    }

    private void setCellEditor(CellEditor e) {
        this.myEditors[2] = e;
        this.myTableViewer.setCellEditors(this.myEditors);
    }

    private boolean isBooleanValue(ConfigurationPropertyValue value) {
        return value.getProperty().getType().getImplementation() == Boolean.class || value.getProperty().getType().getImplementation() == Boolean.TYPE;
    }

    private boolean isEnumValue(ConfigurationPropertyValue value) {
        return value.getProperty().getType().getImplementation() instanceof EEnum;
    }

    private CellEditor getEnumComboBox(EEnum eEnum) {
        EList literals = eEnum.getELiterals();
        String[] items = new String[literals.size()];
        int i = 0;
        for (EEnumLiteral literal : literals) {
            items[i] = literal.getLiteral();
            ++i;
        }
        this.myComboBoxCellEditor.setItems(items);
        return this.myComboBoxCellEditor;
    }

    private static class ConfigurationPropertyValue {
        private final QvtConfigurationProperty myProperty;
        private Object myValue;

        public ConfigurationPropertyValue(QvtConfigurationProperty prop) {
            this.myProperty = prop;
        }

        public ConfigurationPropertyValue(QvtConfigurationProperty prop, Object value) {
            this(prop);
            this.myValue = value;
        }

        public Object getValue() {
            return this.myValue;
        }

        public void setValue(Object value) {
            this.myValue = value;
        }

        public QvtConfigurationProperty getProperty() {
            return this.myProperty;
        }

        public String toString() {
            return this.myValue.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigurationPropertyValueList {
        private List<ConfigurationPropertyValue> myValues = new ArrayList<ConfigurationPropertyValue>();

        private ConfigurationPropertyValueList() {
        }

        public void addProperty(QvtConfigurationProperty property, String value) {
            this.myValues.add(new ConfigurationPropertyValue(property, property.getType().valueOf(value)));
        }

        public void clear() {
            this.myValues.clear();
        }

        public ConfigurationPropertyValue[] getAll() {
            return this.myValues.toArray(new ConfigurationPropertyValue[0]);
        }

        public void fillMap(Map<String, String> valueMap) {
            for (ConfigurationPropertyValue value : this.myValues) {
                if (value.getValue() == QvtConfigurationPropertyType.NOT_SET) continue;
                valueMap.put(value.getProperty().getName(), value.getProperty().getType().stringValueOf(value.getValue()));
            }
        }

        public ConfigurationPropertyValue getFirstError() {
            for (ConfigurationPropertyValue value : this.myValues) {
                if (!(value.getValue() instanceof QvtConfigurationPropertyType.ErrorValue)) continue;
                return value;
            }
            return null;
        }
    }

    private class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MyLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 2) {
                ConfigurationPropertyValue value = (ConfigurationPropertyValue)element;
                if (value.getValue() == QvtConfigurationPropertyType.NOT_SET) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                }
                if (value.getValue() instanceof QvtConfigurationPropertyType.ErrorValue) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                return element.toString();
            }
            ConfigurationPropertyValue value = (ConfigurationPropertyValue)element;
            switch (columnIndex) {
                case 0: {
                    return value.getProperty().getName();
                }
                case 1: {
                    return value.getProperty().getType().getName();
                }
                case 2: {
                    return value.toString();
                }
            }
            return null;
        }
    }

    public static interface PropertyChangeListener {
        public void changePerformed(QvtConfigurationProperty var1);
    }
}

