/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.lang.invoke.CallSite;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PGPPublicKeyViewDialog
extends TitleAreaDialog {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneOffset.UTC);
    private final PGPPublicKey originalKey;
    private final PGPPublicKeyService keyService;
    private StyledText styledText;

    public PGPPublicKeyViewDialog(Shell parentShell, PGPPublicKey key, PGPPublicKeyService keyService) {
        super(parentShell);
        this.originalKey = key;
        this.keyService = keyService;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ProvUIMessages.PGPPublicKeyViewDialog_Title);
        if (this.keyService != null) {
            this.computeVerifiedCertifications(newShell);
        }
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x860);
    }

    protected Control createDialogArea(Composite parent) {
        FontData[] fontData;
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        this.styledText = new StyledText(composite, 2824);
        this.styledText.setLayoutData((Object)new GridData(4, 4, true, true));
        FontData[] fontDataArray = fontData = JFaceResources.getTextFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontDataElement = fontDataArray[n2];
            fontDataElement.setHeight(fontDataElement.getHeight() - 1);
            ++n2;
        }
        Font font = new Font((Device)this.styledText.getDisplay(), fontData);
        this.styledText.setFont(font);
        this.styledText.addDisposeListener(e -> font.dispose());
        GC gc = new GC((Drawable)this.styledText);
        gc.setFont(font);
        data.widthHint = PGPPublicKeyViewDialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)110);
        gc.dispose();
        this.update(this.originalKey, Set.of());
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true).setFocus();
    }

    protected void update(PGPPublicKey key, Set<PGPPublicKey> verifiedCertifications) {
        StyledString content = new StyledString();
        String fingerprint = PGPPublicKeyService.toHexFingerprint((PGPPublicKey)key);
        PublicKeyPacket publicKeyPacket = key.getPublicKeyPacket();
        publicKeyPacket.getAlgorithm();
        content.append(" ");
        content.append(publicKeyPacket instanceof PublicSubkeyPacket ? "sub" : "pub", StyledString.QUALIFIER_STYLER);
        content.append(" ");
        int algorithm = publicKeyPacket.getAlgorithm();
        switch (algorithm) {
            case 1: 
            case 2: 
            case 3: {
                content.append("rsa");
                break;
            }
            case 17: {
                content.append("dsa");
                break;
            }
            case 16: 
            case 20: {
                content.append("elgamal");
                break;
            }
            default: {
                content.append("[");
                content.append(Integer.toString(algorithm));
                content.append("]");
            }
        }
        int bitStrength = key.getBitStrength();
        content.append(Integer.toString(bitStrength));
        content.append("/");
        content.append(fingerprint);
        content.append(" ");
        content.append(DATE_FORMAT.format(key.getCreationTime().toInstant()));
        content.append(" ");
        content.append("\n");
        ArrayList users = new ArrayList();
        key.getUserIDs().forEachRemaining(users::add);
        if (!users.isEmpty()) {
            for (String user : users) {
                content.append(" ");
                content.append("uid", StyledString.QUALIFIER_STYLER);
                content.append(" ");
                content.append(user, StyledString.COUNTER_STYLER);
                content.append("\n");
            }
        }
        Long subKeyOf = null;
        Iterator signatures = key.getSignatures();
        while (signatures.hasNext()) {
            PGPSignature signature = (PGPSignature)signatures.next();
            long keyID = signature.getKeyID();
            if (signature.getSignatureType() == 24) {
                subKeyOf = keyID;
            }
            content.append(" ");
            content.append("sig", StyledString.QUALIFIER_STYLER);
            content.append(" ");
            content.append(PGPPublicKeyService.toHex((long)keyID));
            content.append(" ");
            Date creationTime = signature.getCreationTime();
            String formattedCreationTime = DATE_FORMAT.format(creationTime.toInstant());
            content.append(formattedCreationTime);
            long signatureExpirationTime = signature.getHashedSubPackets().getSignatureExpirationTime();
            content.append(" ");
            content.append(signatureExpirationTime == 0L ? formattedCreationTime.replaceAll(".", "_") : DATE_FORMAT.format(Instant.ofEpochMilli(creationTime.getTime() + 1000L * signatureExpirationTime)));
            content.append(" ");
            Optional<PGPPublicKey> resolvedKey = verifiedCertifications.stream().filter(k -> k.getKeyID() == keyID).findFirst();
            long keyExpirationTime = signature.getHashedSubPackets().getKeyExpirationTime();
            content.append(keyExpirationTime == 0L || resolvedKey == null || !resolvedKey.isPresent() ? formattedCreationTime.replaceAll(".", "_") : DATE_FORMAT.format(Instant.ofEpochMilli(resolvedKey.get().getCreationTime().getTime() + 1000L * keyExpirationTime)));
            if (resolvedKey != null && resolvedKey.isPresent()) {
                content.append(" ");
                content.append(this.getLabel(resolvedKey.get()), StyledString.COUNTER_STYLER);
            }
            content.append("\n");
        }
        this.styledText.setText(content.getString());
        this.styledText.setStyleRanges(content.getStyleRanges());
        ArrayList<CallSite> title = new ArrayList<CallSite>();
        if (subKeyOf != null) {
            long keyID = subKeyOf;
            verifiedCertifications.stream().filter(k -> k.getKeyID() == keyID).findFirst().ifPresentOrElse(k -> {
                boolean bl = title.add((CallSite)((Object)this.getLabel((PGPPublicKey)k)));
            }, () -> {
                boolean bl = title.add((CallSite)((Object)PGPPublicKeyService.toHex((long)keyID)));
            });
        }
        title.add((CallSite)((Object)((subKeyOf == null ? "" : "sub ") + (users.isEmpty() ? fingerprint : (String)users.get(0)))));
        this.setTitle(String.join((CharSequence)"\n", title));
    }

    private String getLabel(PGPPublicKey key) {
        Iterator userIDs = key.getUserIDs();
        if (userIDs.hasNext()) {
            return (String)userIDs.next();
        }
        return PGPPublicKeyService.toHexFingerprint((PGPPublicKey)key);
    }

    private void computeVerifiedCertifications(final Shell shell) {
        final Display display = shell.getDisplay();
        new Job(PGPPublicKeyViewDialog.class.getName()){
            {
                super($anonymous0);
                this.setSystem(true);
                this.setPriority(20);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                PGPPublicKeyService pGPPublicKeyService = PGPPublicKeyViewDialog.this.keyService;
                synchronized (pGPPublicKeyService) {
                    PGPPublicKey enhancedKey = PGPPublicKeyViewDialog.this.keyService.addKey(PGPPublicKeyViewDialog.this.originalKey);
                    Set verifiedCertifications = PGPPublicKeyViewDialog.this.keyService.getVerifiedCertifications(PGPPublicKeyViewDialog.this.originalKey);
                    display.asyncExec(() -> {
                        if (!shell.isDisposed()) {
                            PGPPublicKeyViewDialog.this.update(enhancedKey, verifiedCertifications);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

