/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class URLClassLoader
extends java.net.URLClassLoader {
    private static Logger logger = Logger.getLogger(URLClassLoader.class.getName());
    private List<URL> urls = new LinkedList<URL>();
    private ArrayList<Loader> loaders;
    private AccessControlContext acc;

    public URLClassLoader(URL[] urls) {
        super(new URL[0]);
        this.initURLs(urls);
        this.loaders = new ArrayList(urls.length);
        int i = 0;
        while (i < urls.length) {
            Loader loader = URLClassLoader.createLoader(urls[i]);
            if (loader != null) {
                this.loaders.add(loader);
            }
            ++i;
        }
        this.acc = AccessController.getContext();
    }

    private void initURLs(URL[] urls) {
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            this.urls.add(url);
            ++n2;
        }
    }

    public URLClassLoader(URL[] urls, ClassLoader parent) {
        super(new URL[0], parent);
        this.initURLs(urls);
        this.loaders = new ArrayList(urls.length);
        int i = 0;
        while (i < urls.length) {
            Loader loader = URLClassLoader.createLoader(urls[i]);
            if (loader != null) {
                this.loaders.add(loader);
            }
            ++i;
        }
        this.acc = AccessController.getContext();
    }

    @Override
    public void close() {
        if (this.loaders != null) {
            for (Loader loader : this.loaders) {
                try {
                    loader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.loaders = null;
        }
    }

    @Override
    public void addURL(URL url) {
        if (url == null || this.urls.contains(url)) {
            return;
        }
        this.urls.add(url);
        Loader loader = URLClassLoader.createLoader(url);
        if (loader != null) {
            this.loaders.add(loader);
        }
    }

    @Override
    public URL[] getURLs() {
        return this.urls.toArray(new URL[0]);
    }

    @Override
    protected Class<?> findClass(final String name) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    return URLClassLoader.this.findClass1(name);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    protected Class<?> findClass1(String name) throws ClassNotFoundException {
        if (this.loaders == null) {
            throw new ClassNotFoundException(name);
        }
        String path = name.replace('.', '/').concat(".class");
        try {
            Resource res = this.loadResource(path);
            if (res != null) {
                CodeSource codeSource = res.getCodeSource();
                this.definePackage(name, res);
                byte[] b = res.getBytes();
                return this.defineClass(name, b, 0, b.length, codeSource);
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        throw new ClassNotFoundException(name);
    }

    protected void definePackage(String className, Resource resource) {
        int pos = className.lastIndexOf(46);
        if (pos == -1) {
            return;
        }
        String packageName = className.substring(0, pos);
        Package pkg = this.getPackage(packageName);
        if (pkg != null) {
            return;
        }
        try {
            Manifest manifest = resource.getManifest();
            if (manifest == null) {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            } else {
                CodeSource codeSource = resource.getCodeSource();
                URL codeBase = codeSource == null ? null : codeSource.getLocation();
                this.definePackage(packageName, manifest, codeBase);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public URL findResource(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return URLClassLoader.this.findResource1(name);
            }
        }, this.acc);
    }

    protected URL findResource1(String name) {
        if (this.loaders != null) {
            for (Loader loader : this.loaders) {
                try {
                    URL url = loader.findResource(name);
                    if (url == null) continue;
                    return url;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Enumeration<URL>>(){

            @Override
            public Enumeration<URL> run() {
                return URLClassLoader.this.findResources1(name);
            }
        }, this.acc);
    }

    protected Enumeration<URL> findResources1(String name) {
        Vector<URL> urls = new Vector<URL>();
        if (this.loaders != null) {
            for (Loader loader : this.loaders) {
                try {
                    URL url = loader.findResource(name);
                    if (url == null) continue;
                    urls.add(url);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return urls.elements();
    }

    private Resource loadResource(String name) throws IOException {
        for (Loader loader : this.loaders) {
            Resource resource = loader.loadResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    static Loader createLoader(URL url) {
        try {
            String file = url.getFile();
            if (file != null && file.endsWith("/")) {
                if ("file".equals(url.getProtocol())) {
                    return new FileLoader(url);
                }
                return new UrlLoader(url);
            }
            return new JarLoader(url);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "can not load the class from " + url, ex);
            return null;
        }
    }

    static byte[] loadStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(in.available());
        byte[] bytes = new byte[1024];
        int readSize = in.read(bytes);
        while (readSize != -1) {
            out.write(bytes, 0, readSize);
            readSize = in.read(bytes);
        }
        return out.toByteArray();
    }

    private static String getFilePath(URL url) {
        String path = url.getFile();
        return URLClassLoader.decode(path);
    }

    public static String decode(String s) {
        boolean changed = false;
        int length = s.length();
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        byte[] bytes = null;
        while (i < length) {
            char c = s.charAt(i);
            if (c == '%') {
                try {
                    if (bytes == null) {
                        bytes = new byte[(length - i) / 3];
                    }
                    int pos = 0;
                    while (i + 2 < length && c == '%') {
                        bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                        if ((i += 3) >= length) continue;
                        c = s.charAt(i);
                    }
                    if (i < length && c == '%') {
                        throw new IllegalArgumentException("Incorrect escape pattern.");
                    }
                    buffer.append(new String(bytes, 0, pos, "utf-8"));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal hex numbers in escape pattern." + e.getMessage());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                changed = true;
                continue;
            }
            buffer.append(c);
            ++i;
        }
        return changed ? buffer.toString() : s;
    }

    static class FileLoader
    extends Loader {
        URL baseUrl;
        File baseDir;
        CodeSource codeSource;

        FileLoader(URL url) {
            this.baseUrl = url;
            this.baseDir = new File(URLClassLoader.getFilePath(url));
            this.codeSource = new CodeSource(this.baseUrl, null);
        }

        @Override
        void close() throws IOException {
        }

        @Override
        URL findResource(String name) throws IOException {
            File file = new File(this.baseDir, name.replace('/', File.separatorChar));
            if (file.exists() && file.isFile()) {
                return file.toURI().toURL();
            }
            return null;
        }

        @Override
        Resource loadResource(String name) throws IOException {
            File file = new File(this.baseDir, name.replace('/', File.separatorChar));
            if (file.exists()) {
                FileInputStream in = new FileInputStream(file);
                Throwable throwable = null;
                Object var5_6 = null;
                try {
                    try {
                        final byte[] bytes = URLClassLoader.loadStream(in);
                        return new Resource(){

                            @Override
                            public byte[] getBytes() {
                                return bytes;
                            }

                            @Override
                            CodeSource getCodeSource() {
                                return codeSource;
                            }

                            @Override
                            Manifest getManifest() {
                                return null;
                            }
                        };
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return null;
        }
    }

    static class JarLoader
    extends Loader {
        URL baseUrl;
        URL jarUrl;
        JarFile jarFile;
        Manifest jarManifest;

        JarLoader(URL url) throws IOException {
            this.baseUrl = url;
            this.jarUrl = new URL("jar", "", -1, this.baseUrl + "!/");
            if (this.baseUrl.getProtocol().equalsIgnoreCase("file")) {
                String filePath = URLClassLoader.getFilePath(this.baseUrl);
                this.jarFile = new JarFile(filePath);
            } else {
                JarURLConnection jarConn = (JarURLConnection)this.jarUrl.openConnection();
                this.jarFile = jarConn.getJarFile();
            }
            this.jarManifest = this.jarFile.getManifest();
        }

        @Override
        public void close() throws IOException {
            if (this.jarFile != null) {
                this.jarFile.close();
                this.jarFile = null;
            }
        }

        @Override
        URL findResource(String name) throws IOException {
            ZipEntry entry;
            if (this.jarFile != null && (entry = this.jarFile.getEntry(name)) != null) {
                return new URL(this.jarUrl, name, new JarEntryHandler(entry));
            }
            return null;
        }

        @Override
        Resource loadResource(String name) throws IOException {
            JarEntry entry;
            if (this.jarFile != null && (entry = this.jarFile.getJarEntry(name)) != null) {
                InputStream in = this.jarFile.getInputStream(entry);
                Throwable throwable = null;
                Object var5_6 = null;
                try {
                    try {
                        final byte[] bytes = URLClassLoader.loadStream(in);
                        return new Resource(){

                            @Override
                            byte[] getBytes() {
                                return bytes;
                            }

                            @Override
                            CodeSource getCodeSource() {
                                return new CodeSource(baseUrl, entry.getCodeSigners());
                            }

                            @Override
                            Manifest getManifest() {
                                return jarManifest;
                            }
                        };
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return null;
        }

        private class JarEntryHandler
        extends URLStreamHandler {
            private ZipEntry entry;

            JarEntryHandler(ZipEntry entry) {
                this.entry = entry;
            }

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                return new URLConnection(u){

                    @Override
                    public void connect() throws IOException {
                    }

                    @Override
                    public int getContentLength() {
                        return (int)JarEntryHandler.this.entry.getSize();
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        if (((JarEntryHandler)JarEntryHandler.this).JarLoader.this.jarFile != null) {
                            return ((JarEntryHandler)JarEntryHandler.this).JarLoader.this.jarFile.getInputStream(JarEntryHandler.this.entry);
                        }
                        throw new IOException("ClassLoader has been closed");
                    }
                };
            }
        }
    }

    static abstract class Loader {
        Loader() {
        }

        abstract URL findResource(String var1) throws IOException;

        abstract Resource loadResource(String var1) throws IOException;

        abstract void close() throws IOException;
    }

    static abstract class Resource {
        Resource() {
        }

        abstract CodeSource getCodeSource();

        abstract Manifest getManifest();

        abstract byte[] getBytes() throws IOException;
    }

    static class UrlLoader
    extends Loader {
        CodeSource codeSource;
        URL baseUrl;

        UrlLoader(URL url) {
            this.baseUrl = url;
            this.codeSource = new CodeSource(url, null);
        }

        @Override
        void close() throws IOException {
        }

        @Override
        URL findResource(String name) throws IOException {
            URL url = new URL(this.baseUrl, name);
            URLConnection conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection hconn = (HttpURLConnection)conn;
                hconn.setRequestMethod("HEAD");
                if (hconn.getResponseCode() >= 400) {
                    return null;
                }
            } else {
                InputStream is = url.openStream();
                is.close();
            }
            return url;
        }

        @Override
        Resource loadResource(String name) throws IOException {
            URL url = new URL(this.baseUrl, name);
            InputStream in = url.openStream();
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                try {
                    final byte[] bytes = URLClassLoader.loadStream(in);
                    return new Resource(){

                        @Override
                        byte[] getBytes() {
                            return bytes;
                        }

                        @Override
                        CodeSource getCodeSource() {
                            return codeSource;
                        }

                        @Override
                        Manifest getManifest() {
                            return null;
                        }
                    };
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

