/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.diagram.description.tool.ToolPackage;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.interpreter.IInterpreterMessages;
import org.eclipse.sirius.tools.api.ui.resource.ISiriusMessages;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public final class DiagramElementMappingHelper {
    private DiagramElementMappingHelper() {
    }

    public static void refreshSemanticElements(DiagramElementMapping self, DDiagramElement dde, IInterpreter interpreter) {
        Collection<Object> semanticElements = Lists.newArrayList();
        if (!StringUtil.isEmpty((String)self.getSemanticElements())) {
            semanticElements = DiagramElementMappingHelper.evaluateSemanticElements(self, dde, interpreter);
        }
        if (!(semanticElements != null && !semanticElements.isEmpty() || dde.getTarget() == null || self instanceof EdgeMapping && !((EdgeMapping)self).isUseDomainElement())) {
            semanticElements = Collections.singletonList(dde.getTarget());
        }
        if (!semanticElements.isEmpty() && !Iterables.elementsEqual(semanticElements, (Iterable)dde.getSemanticElements())) {
            dde.getSemanticElements().clear();
            dde.getSemanticElements().addAll(semanticElements);
        }
    }

    public static String computeLabel(DDiagramElement diagramElement, BasicLabelStyleDescription style, DDiagram diagram, IInterpreter interpreter) {
        String result = null;
        interpreter.setVariable("diagram", (Object)diagram);
        interpreter.setVariable("view", (Object)diagramElement);
        try {
            try {
                result = interpreter.evaluateString(diagramElement.getTarget(), style.getLabelExpression());
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression(), (Throwable)e);
                result = IInterpreterMessages.DEFAULT_NAME_ON_FACTORY_EXCEPTION;
                interpreter.unSetVariable("view");
                interpreter.unSetVariable("diagram");
            }
        }
        finally {
            interpreter.unSetVariable("view");
            interpreter.unSetVariable("diagram");
        }
        return result;
    }

    public static String computeInputLabelOfDirectEditLabel(DDiagramElement diagramElement, DDiagram diagram, DirectEditLabel labelDirectEdit, IInterpreter interpreter) {
        String result = null;
        interpreter.setVariable("diagram", (Object)diagram);
        interpreter.setVariable("view", (Object)diagramElement);
        try {
            try {
                result = interpreter.evaluateString(diagramElement.getTarget(), labelDirectEdit.getInputLabelExpression());
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)labelDirectEdit, (EStructuralFeature)ToolPackage.eINSTANCE.getDirectEditLabel_InputLabelExpression(), (Throwable)e);
                result = IInterpreterMessages.DEFAULT_NAME_ON_FACTORY_EXCEPTION;
                interpreter.unSetVariable("view");
                interpreter.unSetVariable("diagram");
            }
        }
        finally {
            interpreter.unSetVariable("view");
            interpreter.unSetVariable("diagram");
        }
        return result;
    }

    private static Collection<EObject> evaluateSemanticElements(DiagramElementMapping self, DDiagramElement dde, IInterpreter interpreter) {
        Collection<Object> semanticElements = Collections.emptyList();
        if (dde.getTarget() != null && !StringUtil.isEmpty((String)self.getSemanticElements())) {
            EObject context = dde.getTarget();
            try {
                try {
                    interpreter.setVariable("view", (Object)dde);
                    DDiagram parentDiagram = dde.getParentDiagram();
                    interpreter.setVariable("diagram", (Object)parentDiagram);
                    interpreter.setVariable("viewpoint", (Object)parentDiagram);
                    if (dde.eContainer() != null) {
                        interpreter.setVariable("containerView", (Object)dde.eContainer());
                        if (dde.eContainer() instanceof DSemanticDecorator) {
                            interpreter.setVariable("container", (Object)((DSemanticDecorator)dde.eContainer()).getTarget());
                        }
                    }
                    if (self instanceof EdgeMapping && dde instanceof DEdge) {
                        DEdge edge = (DEdge)dde;
                        interpreter.setVariable("source", (Object)DiagramElementMappingHelper.getSemanticTarget(edge.getSourceNode()));
                        interpreter.setVariable("target", (Object)DiagramElementMappingHelper.getSemanticTarget(edge.getTargetNode()));
                        interpreter.setVariable("sourceView", (Object)edge.getSourceNode());
                        interpreter.setVariable("targetView", (Object)edge.getTargetNode());
                    }
                    semanticElements = interpreter.evaluateCollection(context, self.getSemanticElements());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)self, (EStructuralFeature)DescriptionPackage.eINSTANCE.getDiagramElementMapping_SemanticElements(), (Throwable)e);
                    interpreter.unSetVariable("diagram");
                    interpreter.unSetVariable("view");
                    interpreter.unSetVariable("viewpoint");
                    if (dde.eContainer() != null) {
                        interpreter.unSetVariable("containerView");
                        if (dde.eContainer() instanceof DSemanticDecorator) {
                            interpreter.unSetVariable("container");
                        }
                    }
                    if (self instanceof EdgeMapping && dde instanceof DEdge) {
                        interpreter.unSetVariable("source");
                        interpreter.unSetVariable("target");
                        interpreter.unSetVariable("sourceView");
                        interpreter.unSetVariable("targetView");
                    }
                }
            }
            finally {
                interpreter.unSetVariable("diagram");
                interpreter.unSetVariable("view");
                interpreter.unSetVariable("viewpoint");
                if (dde.eContainer() != null) {
                    interpreter.unSetVariable("containerView");
                    if (dde.eContainer() instanceof DSemanticDecorator) {
                        interpreter.unSetVariable("container");
                    }
                }
                if (self instanceof EdgeMapping && dde instanceof DEdge) {
                    interpreter.unSetVariable("source");
                    interpreter.unSetVariable("target");
                    interpreter.unSetVariable("sourceView");
                    interpreter.unSetVariable("targetView");
                }
            }
        }
        return semanticElements;
    }

    public static Iterator<EObject> getSemanticIterator(AbstractNodeMapping self, EObject context, EObject diagram) {
        Iterator<Object> result;
        if (!StringUtil.isEmpty((String)self.getSemanticCandidatesExpression())) {
            try {
                IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(context);
                interpreter.setVariable("viewpoint", (Object)diagram);
                interpreter.setVariable("viewPoint", (Object)diagram);
                interpreter.setVariable("diagram", (Object)diagram);
                interpreter.setVariable("containerView", (Object)diagram);
                Collection resCollection = interpreter.evaluateCollection(context, self.getSemanticCandidatesExpression());
                interpreter.unSetVariable("viewpoint");
                interpreter.unSetVariable("viewPoint");
                interpreter.unSetVariable("containerView");
                interpreter.unSetVariable("diagram");
                return resCollection.iterator();
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)self, (EStructuralFeature)DescriptionPackage.eINSTANCE.getDiagramElementMapping_SemanticCandidatesExpression(), (Throwable)e);
                result = Collections.emptyList().iterator();
            }
        } else {
            result = DiagramElementMappingHelper.extEAllContents(context);
        }
        return result;
    }

    private static Iterator<EObject> extEAllContents(EObject eObj) {
        ArrayList eAllContentsIterators = Lists.newArrayList();
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(eObj);
        Session session = SessionManager.INSTANCE.getSession(eObj);
        for (Resource resource : session.getSemanticResources()) {
            for (EObject root : resource.getContents()) {
                eAllContentsIterators.add(accessor.eAllContents(root));
            }
        }
        return Iterators.concat((Iterator[])((Iterator[])Iterables.toArray((Iterable)eAllContentsIterators, Iterator.class)));
    }

    private static EObject getSemanticTarget(EdgeTarget edgeTarget) {
        if (edgeTarget instanceof DSemanticDecorator) {
            return ((DSemanticDecorator)edgeTarget).getTarget();
        }
        if (edgeTarget != null) {
            SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.DiagramElementMappingHelper_edgeTargetMsg, String.valueOf(edgeTarget), ISiriusMessages.IS_NOT_A_DECORATE_SEMANTIC_ELEMENT), null);
        }
        return null;
    }
}

