/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.Messages;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.NotationPredicate;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.query.SequenceNodeQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.util.RangeSetter;
import org.eclipse.sirius.diagram.sequence.business.internal.util.SubEventsHelper;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class Operand
extends AbstractSequenceNode
implements ISequenceEvent {
    public static final int VISUAL_ID = 3008;
    public static final int COMPARTMENT_VISUAL_ID = 7002;

    Operand(Node node) {
        super(node);
        Preconditions.checkArgument((boolean)Operand.notationPredicate().apply((Object)node), (Object)Messages.Operand_nonOperandNode);
    }

    public static Predicate<View> notationPredicate() {
        return new NotationPredicate(NotationPackage.eINSTANCE.getNode(), 3008, Operand.viewpointElementPredicate());
    }

    public static Predicate<View> compartmentNotationPredicate() {
        return new NotationPredicate(NotationPackage.eINSTANCE.getNode(), 7002, Operand.viewpointElementPredicate());
    }

    public static Predicate<DDiagramElement> viewpointElementPredicate() {
        return SiriusElementPredicate.INSTANCE;
    }

    @Override
    public Option<Lifeline> getLifeline() {
        return Options.newNone();
    }

    @Override
    public Rectangle getProperLogicalBounds() {
        Rectangle cfBounds = this.getCombinedFragment().getProperLogicalBounds();
        if (this.getNotationNode().getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)this.getNotationNode().getLayoutConstraint();
            return new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight()).getTranslated(cfBounds.getLocation());
        }
        throw new RuntimeException();
    }

    @Override
    public ISequenceEvent getParentEvent() {
        return this.getCombinedFragment();
    }

    @Override
    public ISequenceEvent getHierarchicalParentEvent() {
        return this.getCombinedFragment();
    }

    @Override
    public List<ISequenceEvent> getSubEvents() {
        return new SubEventsHelper(this).getSubEvents();
    }

    @Override
    public Collection<ISequenceEvent> getEventsToMoveWith() {
        return this.getSubEvents();
    }

    @Override
    public Range getVerticalRange() {
        return new SequenceNodeQuery(this.getNotationNode()).getVerticalRange();
    }

    @Override
    public boolean isLogicallyInstantaneous() {
        return false;
    }

    @Override
    public void setVerticalRange(Range range) throws IllegalStateException {
        RangeSetter.setVerticalRange(this, range);
    }

    public CombinedFragment getCombinedFragment() {
        EObject viewContainer = this.view.eContainer();
        if (viewContainer instanceof View) {
            View parentView = (View)viewContainer;
            Option<CombinedFragment> parentElement = ISequenceElementAccessor.getCombinedFragment(parentView);
            if (parentElement.some()) {
                return (CombinedFragment)parentElement.get();
            }
            View grandParentView = (View)viewContainer.eContainer();
            Option<CombinedFragment> grandparentElement = ISequenceElementAccessor.getCombinedFragment(grandParentView);
            if (grandparentElement.some()) {
                return (CombinedFragment)grandparentElement.get();
            }
        }
        throw new RuntimeException(MessageFormat.format(Messages.Operand_invalidOperandContext, this));
    }

    public int getIndex() {
        CombinedFragment parentCombinedFragment = this.getCombinedFragment();
        return parentCombinedFragment.getIndexOfOperand(this);
    }

    public boolean isLastOperand() {
        return this.getIndex() == this.getCombinedFragment().getOperands().size() - 1;
    }

    public boolean isFirstOperand() {
        return this.getIndex() == 0;
    }

    public Option<Operand> getFollowingOperand() {
        CombinedFragment combinedFragment = this.getCombinedFragment();
        return combinedFragment.getOperand(combinedFragment.getIndexOfOperand(this) + 1);
    }

    public Option<Operand> getPreviousOperand() {
        CombinedFragment combinedFragment = this.getCombinedFragment();
        return combinedFragment.getOperand(combinedFragment.getIndexOfOperand(this) - 1);
    }

    @Override
    public boolean canChildOccupy(ISequenceEvent child, Range range) {
        return new SubEventsHelper(this).canChildOccupy(child, range);
    }

    @Override
    public boolean canChildOccupy(ISequenceEvent child, Range range, List<ISequenceEvent> eventsToIgnore, Collection<Lifeline> lifelines) {
        return new SubEventsHelper(this).canChildOccupy(child, range, eventsToIgnore, lifelines);
    }

    @Override
    public Range getOccupiedRange() {
        return new ISequenceEventQuery(this).getOccupiedRange();
    }

    @Override
    public Range getValidSubEventsRange() {
        return this.getVerticalRange().shrinked(5);
    }

    public Collection<Lifeline> computeCoveredLifelines() {
        return this.getCombinedFragment().computeCoveredLifelines();
    }

    public EventEnd getLastContainedEventEnd() {
        List<ISequenceEvent> subEvents = this.getSubEvents();
        if (subEvents.isEmpty()) {
            List<EventEnd> ends = EventEndHelper.findEndsFromSemanticOrdering(this);
            assert (!ends.isEmpty());
            return ends.get(0);
        }
        ISequenceEvent lastEvent = subEvents.get(subEvents.size() - 1);
        List<EventEnd> ends = EventEndHelper.findEndsFromSemanticOrdering(lastEvent);
        assert (ends.size() == 2);
        return ends.get(1);
    }

    @Override
    public Option<Operand> getParentOperand() {
        return this.getCombinedFragment().getParentOperand();
    }

    private static enum SiriusElementPredicate implements Predicate<DDiagramElement>
    {
        INSTANCE;


        public boolean apply(DDiagramElement input) {
            return AbstractSequenceElement.isSequenceDiagramElement(input, DescriptionPackage.eINSTANCE.getOperandMapping());
        }
    }
}

