/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.util;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;

public abstract class UnicodeSupport {
    private static final UnicodeSupport INSTANCE = new Default();

    UnicodeSupport() {
    }

    public static int codePointAt(StringBuffer buffer, int offset) {
        return INSTANCE.codePointAt0(buffer, offset);
    }

    public static void setCodePointAt(StringBuffer buffer, int offset, int codePoint) {
        INSTANCE.setCodePointAt0(buffer, offset, codePoint);
    }

    public static int shiftCodePointOffsetBy(String text, int offset, int shift) {
        return INSTANCE.shiftCodePointOffsetBy0(text, offset, shift);
    }

    public static int toLowerCase(int codePoint) {
        return INSTANCE.toLowerCase0(codePoint);
    }

    public static int toUpperCase(int codePoint) {
        return INSTANCE.toUpperCase0(codePoint);
    }

    public static String toLowerCase(String text) {
        return INSTANCE.toLowerCase0(text);
    }

    public static String toUpperCase(String text) {
        return INSTANCE.toUpperCase0(text);
    }

    abstract int codePointAt0(StringBuffer var1, int var2);

    abstract void setCodePointAt0(StringBuffer var1, int var2, int var3);

    abstract int shiftCodePointOffsetBy0(String var1, int var2, int var3);

    abstract int toLowerCase0(int var1);

    abstract int toUpperCase0(int var1);

    abstract String toLowerCase0(String var1);

    abstract String toUpperCase0(String var1);

    static final class Default
    extends UnicodeSupport {
        Default() {
        }

        int codePointAt0(StringBuffer buffer, int offset) {
            return buffer.codePointAt(offset);
        }

        int shiftCodePointOffsetBy0(String text, int offset, int shift) {
            return text.offsetByCodePoints(offset, shift);
        }

        void setCodePointAt0(StringBuffer buffer, int offset, int codePoint) {
            int existingCodePoint = buffer.codePointAt(offset);
            int width = Character.charCount(existingCodePoint);
            buffer.replace(offset, offset + width, String.valueOf(Character.toChars(codePoint)));
        }

        int toLowerCase0(int codePoint) {
            return Character.toLowerCase(codePoint);
        }

        String toLowerCase0(String text) {
            return text.toLowerCase();
        }

        int toUpperCase0(int codePoint) {
            return Character.toUpperCase(codePoint);
        }

        String toUpperCase0(String text) {
            return text.toUpperCase();
        }
    }

    static final class ICU
    extends UnicodeSupport {
        public ICU() {
            UTF16.charAt((String)this.getClass().getName(), (int)1);
        }

        int codePointAt0(StringBuffer buffer, int offset) {
            return UTF16.charAt((StringBuffer)buffer, (int)offset);
        }

        int shiftCodePointOffsetBy0(String text, int offset, int shift) {
            return UTF16.moveCodePointOffset((String)text, (int)offset, (int)shift);
        }

        void setCodePointAt0(StringBuffer buffer, int offset, int codePoint) {
            UTF16.setCharAt((StringBuffer)buffer, (int)offset, (int)codePoint);
        }

        int toLowerCase0(int codePoint) {
            return UCharacter.toLowerCase((int)codePoint);
        }

        String toLowerCase0(String text) {
            return UCharacter.toLowerCase((String)text);
        }

        int toUpperCase0(int codePoint) {
            return UCharacter.toUpperCase((int)codePoint);
        }

        String toUpperCase0(String text) {
            return UCharacter.toUpperCase((String)text);
        }
    }
}

