/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.query.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.eclipse.lyo.core.query.ScopedSortTerm;
import org.eclipse.lyo.core.query.SimpleSortTerm;
import org.eclipse.lyo.core.query.SortTerm;
import org.eclipse.lyo.core.query.impl.ScopedSortTermInvocationHandler;
import org.eclipse.lyo.core.query.impl.SimpleSortTermInvocationHandler;

public class SortTermsInvocationHandler
implements InvocationHandler {
    private final Tree tree;
    private final Map<String, String> prefixMap;
    private List<SortTerm> children = null;

    public SortTermsInvocationHandler(Tree tree, Map<String, String> prefixMap) {
        this.tree = tree;
        this.prefixMap = prefixMap;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.children == null) {
            this.children = new ArrayList<SortTerm>(this.tree.getChildCount());
            for (int index = 0; index < this.tree.getChildCount(); ++index) {
                Tree child = this.tree.getChild(index);
                this.children.add((SortTerm)(switch (child.getType()) {
                    case 22 -> Proxy.newProxyInstance(SimpleSortTerm.class.getClassLoader(), new Class[]{SimpleSortTerm.class}, (InvocationHandler)new SimpleSortTermInvocationHandler(child, this.prefixMap));
                    case 21 -> Proxy.newProxyInstance(ScopedSortTerm.class.getClassLoader(), new Class[]{ScopedSortTerm.class}, (InvocationHandler)new ScopedSortTermInvocationHandler(child, this.prefixMap));
                    default -> throw new IllegalStateException("unimplemented type of sort term: " + child.getText());
                }));
            }
            this.children = Collections.unmodifiableList(this.children);
        }
        if (method.getName().equals("children")) {
            return this.children;
        }
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (SortTerm term : this.children) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            buffer.append(term.toString());
        }
        return buffer.toString();
    }
}

