/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.calculator;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.lsat.motioncalculator.MotionCalculator;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.motioncalculator.MotionProfile;
import org.eclipse.lsat.motioncalculator.MotionProfileParameter;
import org.eclipse.lsat.motioncalculator.MotionProfileProvider;
import org.eclipse.lsat.motioncalculator.MotionSegment;
import org.eclipse.lsat.motioncalculator.MotionValidationException;
import org.eclipse.lsat.motioncalculator.PositionInfo;
import org.eclipse.lsat.timing.Activator;

public class MotionCalculatorExtension
implements MotionCalculator,
Comparable<MotionCalculatorExtension> {
    public static final String EXTENSION_POINT = "org.eclipse.lsat.timing.calculator";
    private static final Pattern KEY_PATTERN = Pattern.compile("^[a-zA-Z_][a-zA-Z_0-9]*$");
    private static MotionCalculatorExtension selectedMotionCalculator = null;
    private final IConfigurationElement configurationElement;
    private MotionCalculator delegate = null;
    private Map<String, MotionProfile> motionProfiles = null;
    private MotionProfile defaultProfile;

    static {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        preferenceStore.setDefault(EXTENSION_POINT, "org.eclipse.lsat.timing.calculator.PointToPointMotionCalculator");
    }

    public static final List<MotionCalculatorExtension> getAvailableMotionCalculators() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        ArrayList<MotionCalculatorExtension> result = new ArrayList<MotionCalculatorExtension>(configurationElements.length);
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (configurationElement.isValid()) {
                result.add(new MotionCalculatorExtension(configurationElement));
            }
            ++n2;
        }
        return result;
    }

    public static final MotionCalculatorExtension getSelectedMotionCalculator() throws MotionException {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String motionCalculatorId = preferenceStore.getString(EXTENSION_POINT);
        if (selectedMotionCalculator == null || !MotionCalculatorExtension.selectedMotionCalculator.configurationElement.isValid() || !selectedMotionCalculator.getId().equals(motionCalculatorId)) {
            List<MotionCalculatorExtension> availableMotionCalculators = MotionCalculatorExtension.getAvailableMotionCalculators();
            Optional<MotionCalculatorExtension> motionCalculator = availableMotionCalculators.stream().filter(e -> e.getId().equals(motionCalculatorId)).findFirst();
            if (!motionCalculator.isPresent()) {
                throw new MotionException("No motion calculator found for id: " + motionCalculatorId);
            }
            motionCalculator.get().initialize();
            selectedMotionCalculator = motionCalculator.get();
        }
        return selectedMotionCalculator;
    }

    private MotionCalculatorExtension(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
    }

    @Override
    public int compareTo(MotionCalculatorExtension o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public String getId() {
        return this.configurationElement.getAttribute("id");
    }

    public String getName() {
        return this.configurationElement.getAttribute("name");
    }

    private void initialize() throws MotionException {
        IConfigurationElement[] motionProfileElements;
        try {
            this.delegate = (MotionCalculator)this.configurationElement.createExecutableExtension("class");
        }
        catch (CoreException e) {
            throw new MotionException("Failed to instantiate motion calculator: " + e.getMessage(), (Throwable)e);
        }
        this.motionProfiles = new LinkedHashMap<String, MotionProfile>();
        if (this.delegate instanceof MotionProfileProvider) {
            MotionProfileProvider provider = (MotionProfileProvider)this.delegate;
            provider.getSupportedProfiles().stream().forEach(p -> {
                MotionProfile motionProfile = this.motionProfiles.put(p.getKey(), (MotionProfile)p);
            });
        }
        IConfigurationElement[] iConfigurationElementArray = motionProfileElements = this.configurationElement.getChildren("MotionProfile");
        int n = motionProfileElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement motionProfileElement = iConfigurationElementArray[n2];
            String motionProfileKey = motionProfileElement.getAttribute("key");
            if (!KEY_PATTERN.matcher(motionProfileKey).matches()) {
                throw new MotionException(String.format("Encountered problem while configuring MotionCalculator '%s': MotionProfile key '%s' should start with a letter ('a'..'z'|'A'..'Z') or underscore '_' followed by any number of letters, underscores and numbers ('0'..'9').", this.getName(), motionProfileKey));
            }
            String motionProfileName = motionProfileElement.getAttribute("name");
            String motionProfileURL = motionProfileElement.getAttribute("url");
            String motionProfileDefaultProfile = motionProfileElement.getAttribute("defaultProfile");
            ArrayList<MotionProfileParameter> parameters = new ArrayList<MotionProfileParameter>();
            IConfigurationElement[] iConfigurationElementArray2 = motionProfileElement.getChildren("Parameter");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement parameterElement = iConfigurationElementArray2[n4];
                String parameterKey = parameterElement.getAttribute("key");
                if (!KEY_PATTERN.matcher(parameterKey).matches() && !KEY_PATTERN.matcher(motionProfileKey).matches()) {
                    throw new MotionException(String.format("Encountered problem while configuring MotionCalculator '%s': Parameter key '%s' of MotionProfile '%s' should start with a letter ('a'..'z'|'A'..'Z') or underscore '_' followed by any number of letters, underscores and numbers ('0'..'9').", this.getName(), parameterKey, motionProfileKey));
                }
                String parematerName = parameterElement.getAttribute("name");
                boolean parameterRequired = Boolean.parseBoolean(parameterElement.getAttribute("required"));
                parameters.add(new MotionProfileParameter(parameterKey, parematerName, parameterRequired));
                ++n4;
            }
            try {
                MotionProfile motionProfile = new MotionProfile(motionProfileKey, motionProfileName, motionProfileURL == null ? null : new URL(motionProfileURL), parameters);
                motionProfile.setDefaultProfile(Boolean.valueOf(motionProfileDefaultProfile).booleanValue());
                MotionProfile previousValue = this.motionProfiles.put(motionProfileKey, motionProfile);
                if (previousValue != null) {
                    throw new MotionException("MotionProfile keys should be unique: " + motionProfileKey);
                }
            }
            catch (MalformedURLException e) {
                throw new MotionException(String.format("Failed to parse URL for motion profile %s: %s", motionProfileName, e.getMessage()), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new MotionException(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        Set defaultProfiles = this.motionProfiles.values().stream().filter(p -> this.motionProfiles.size() == 1 || p.isDefaultProfile()).collect(Collectors.toCollection(LinkedHashSet::new));
        if (defaultProfiles.size() == 0) {
            throw new MotionException("No default MotionProfile specified");
        }
        if (defaultProfiles.size() > 1) {
            throw new MotionException(String.valueOf(String.join((CharSequence)",", (CharSequence[])defaultProfiles.stream().map(MotionProfile::getKey).toArray(String[]::new))) + " are default! Only one default MotionProfile is allowed");
        }
        this.defaultProfile = (MotionProfile)defaultProfiles.stream().findFirst().get();
    }

    public MotionProfile getMotionProfile(String key) {
        this.validate();
        if (key == null || key.isEmpty()) {
            return this.defaultProfile;
        }
        return this.motionProfiles.get(key);
    }

    public Collection<MotionProfile> getMotionProfiles() {
        this.validate();
        return this.motionProfiles.values();
    }

    public void validate(List<MotionSegment> segments) throws MotionValidationException {
        this.validate();
        this.delegate.validate(segments);
    }

    public List<Double> calculateTimes(List<MotionSegment> segments) throws MotionException {
        this.validate();
        return this.delegate.calculateTimes(segments);
    }

    public Collection<PositionInfo> getPositionInfo(List<MotionSegment> segments) throws MotionException {
        this.validate();
        return this.delegate.getPositionInfo(segments);
    }

    private void validate() {
        if (this.delegate == null || this.motionProfiles == null || this.defaultProfile == null) {
            throw new IllegalStateException("MotionCalculatorExtension not initialized: " + this.getId());
        }
    }
}

