/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.scheduler.algorithm;

import java.math.BigDecimal;
import java.util.Collection;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.lsat.common.graph.directed.Edge;
import org.eclipse.lsat.common.scheduler.algorithm.CycleFoundException;
import org.eclipse.lsat.common.scheduler.algorithm.SchedulerBase;
import org.eclipse.lsat.common.scheduler.algorithm.SchedulerException;
import org.eclipse.lsat.common.scheduler.algorithm.internal.ExecutiontimesValidator;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.resources.Resource;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;
import org.eclipse.lsat.common.scheduler.schedule.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsapScheduler<T extends Task>
extends SchedulerBase<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsapScheduler.class);

    @Override
    protected Logger getLog() {
        return LOGGER;
    }

    @Override
    protected EValidator[] getComplementaryGraphValidators() {
        return new EValidator[]{ExecutiontimesValidator.INSTANCE};
    }

    @Override
    protected final void performScheduling() throws SchedulerException {
        Iterable<T> tasks = this.getAllTasksInTopologicalOrder();
        if (tasks == null) {
            throw new CycleFoundException("Cycle exists in graph!!");
        }
        for (Task task : tasks) {
            ScheduledTask<Task> scheduledTask = this.createScheduledTask(task, true);
            SequenceMetaData asapSequenceMetaData = null;
            for (Sequence sequence : this.getSequences((Collection<Resource>)task.getResources())) {
                SequenceMetaData sequenceMetaData = this.startTimeOnSequence(scheduledTask, sequence);
                if (asapSequenceMetaData != null && sequenceMetaData.getTime().compareTo(asapSequenceMetaData.getTime()) >= 0) continue;
                asapSequenceMetaData = sequenceMetaData;
            }
            if (asapSequenceMetaData == null) {
                throw new SchedulerException((CharSequence)("Could not determine sequence for task: " + scheduledTask.getName()));
            }
            scheduledTask.setStartTime(asapSequenceMetaData.getTime());
            scheduledTask.setEndTime(asapSequenceMetaData.getTime().add(scheduledTask.getTask().getExecutionTime()));
            asapSequenceMetaData.getSequence().getScheduledTasks().add(asapSequenceMetaData.getIndex(), scheduledTask);
        }
    }

    protected Iterable<? extends T> getAllTasksInTopologicalOrder() {
        return this.getGraph().allNodesInTopologicalOrder();
    }

    protected SequenceMetaData startTimeOnSequence(ScheduledTask<T> scheduledTask, Sequence<T> sequence) {
        int index;
        BigDecimal earliestStartTime = this.getEarliestStartTime(scheduledTask, sequence);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace("Earliest start time for task '{}' = {}", (Object)scheduledTask.getName(), (Object)earliestStartTime);
        }
        BigDecimal startTime = (index = sequence.getScheduledTasks().size()) > 0 ? earliestStartTime.max(((ScheduledTask)sequence.getScheduledTasks().get(index - 1)).getEndTime()) : earliestStartTime;
        return new SequenceMetaData(sequence, startTime, index);
    }

    protected BigDecimal getEarliestStartTime(ScheduledTask<T> scheduledTask, Sequence<T> sequence) {
        BigDecimal earliestStartTime = sequence.getResource().getStart();
        for (Edge edge : scheduledTask.getIncomingEdges()) {
            ScheduledTask precedingTask = (ScheduledTask)edge.getSourceNode();
            earliestStartTime = earliestStartTime.max(precedingTask.getEndTime());
        }
        return earliestStartTime;
    }

    @Override
    protected void postProcessSchedule() {
    }

    protected class SequenceMetaData {
        private final Sequence<T> sequence;
        private final BigDecimal time;
        private final int index;

        SequenceMetaData(Sequence<T> sequence, BigDecimal time, int index) {
            this.sequence = sequence;
            this.time = time;
            this.index = index;
        }

        public Sequence<T> getSequence() {
            return this.sequence;
        }

        public BigDecimal getTime() {
            return this.time;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

